/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.ExternalJavaDocAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.function.Supplier;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentHelpAction
extends AnAction {
    private static final String DEFAULT_ANDROID_REFERENCE_PREFIX = "https://developer.android.com/reference/";
    private final Project myProject;
    private final Supplier<String> myTagNameSupplier;

    public ComponentHelpAction(@NotNull Project project, @NotNull Supplier<String> tagNameSupplier) {
        super("Android Documentation");
        this.myProject = project;
        this.myTagNameSupplier = tagNameSupplier;
        this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(112, 64)));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        String tagName = this.myTagNameSupplier.get();
        if (tagName == null) {
            return;
        }
        String className2 = this.findClassName(tagName);
        if (className2 == null) {
            return;
        }
        String reference2 = ComponentHelpAction.computeReferenceFromClassName(className2);
        if (reference2 != null) {
            BrowserUtil.browse((String)reference2);
            return;
        }
        PsiClass psiClass = this.findClassByClassName(className2);
        if (psiClass == null) {
            return;
        }
        ExternalJavaDocAction.showExternalJavadoc((PsiElement)psiClass, null, null, (DataContext)event.getDataContext());
    }

    @Nullable
    private String findClassName(@NotNull String tagName) {
        if (tagName.indexOf(46) != -1) {
            return tagName;
        }
        if (this.findClassByClassName("android.widget." + tagName) != null) {
            return "android.widget." + tagName;
        }
        if (this.findClassByClassName("android.view." + tagName) != null) {
            return "android.view." + tagName;
        }
        if (this.findClassByClassName("android.webkit." + tagName) != null) {
            return "android.webkit." + tagName;
        }
        return null;
    }

    @Nullable
    private PsiClass findClassByClassName(@NotNull String fullyQualifiedClassName) {
        JavaPsiFacade javaFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        return javaFacade.findClass(fullyQualifiedClassName, GlobalSearchScope.allScope((Project)this.myProject));
    }

    @Nullable
    private static String computeReferenceFromClassName(@NotNull String className2) {
        if (className2.startsWith("android.") || className2.startsWith("android.support.") || className2.startsWith("androidx.") || className2.startsWith("com.google.android.")) {
            return DEFAULT_ANDROID_REFERENCE_PREFIX + StringUtil.replaceChar((String)className2, (char)'.', (char)'/') + ".html";
        }
        return null;
    }
}

