/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.builders.PathStringBuilder;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.BorderModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.FillModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.GradientModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.InheritedProperties;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ResizingConstraint;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.StyleModel;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ShapeModel {
    private static final int DEFAULT_BORDER_WIDTH_VALUE = 0;
    private static final int DEFAULT_COLOR_VALUE = 0;
    protected boolean isFlippedHorizontal;
    protected boolean isFlippedVertical;
    protected boolean isClosed;
    protected boolean hasClippingMask;
    protected boolean shouldBreakMaskChain;
    @Nullable
    protected StyleModel myShapeStyle;
    protected boolean myIsClosed;
    protected int myShapeOperation;
    protected boolean myHasClippingMask;
    protected boolean myShouldBreakMaskChain;
    protected boolean myIsLastShape;
    @NotNull
    protected ResizingConstraint myResizingConstraint;
    @NotNull
    protected Point2D.Double myShapeFrameLocation;
    protected boolean myIsFlippedVertical;
    protected boolean myIsflippedhorizontal;
    protected int myRotationDegrees;
    @NotNull
    private Shape myShape;
    @NotNull
    private Rectangle2D myShapeBounds;

    public ShapeModel(@NotNull Shape shape, @Nullable StyleModel style, boolean flippedHorizontal, boolean flippedVertical, boolean closed, int rotation, int operation, @NotNull Point2D.Double framePosition, boolean hasClippingMask, boolean shouldBreakMaskChain, boolean isLastShapeGroup, @NotNull ResizingConstraint constraint) {
        this.myShape = shape;
        this.myIsClosed = closed;
        this.myShapeOperation = operation;
        this.myHasClippingMask = hasClippingMask;
        this.myShouldBreakMaskChain = shouldBreakMaskChain;
        this.myIsLastShape = isLastShapeGroup;
        this.myShapeStyle = style;
        this.myResizingConstraint = constraint;
        this.myIsflippedhorizontal = flippedHorizontal;
        this.myIsFlippedVertical = flippedVertical;
        this.myShapeFrameLocation = framePosition;
        this.myRotationDegrees = rotation;
        this.myShapeBounds = shape.getBounds2D();
    }

    @NotNull
    public Shape getShape() {
        return this.myShape;
    }

    public int getBooleanOperation() {
        return this.myShapeOperation;
    }

    @Nullable
    public BorderModel getShapeBorder() {
        return this.myShapeStyle != null ? this.myShapeStyle.getBorder() : null;
    }

    public int getBorderColor() {
        return this.getShapeBorder() != null ? this.getShapeBorder().getColor().getRGB() : 0;
    }

    public int getBorderWidth() {
        return this.getShapeBorder() != null ? this.getShapeBorder().getWidth() : 0;
    }

    @Nullable
    public FillModel getFill() {
        return this.myShapeStyle != null ? this.myShapeStyle.getFill() : null;
    }

    public int getFillColor() {
        return this.getFill() != null ? this.getFill().getColor().getRGB() : 0;
    }

    @Nullable
    public GradientModel getGradient() {
        return this.getFill() != null ? this.getFill().getGradientModel() : null;
    }

    public boolean hasClippingMask() {
        return this.myHasClippingMask;
    }

    public boolean shouldBreakMaskChain() {
        return this.myShouldBreakMaskChain;
    }

    public boolean isLastShape() {
        return this.myIsLastShape;
    }

    @NotNull
    public ResizingConstraint getResizingConstraint() {
        return this.myResizingConstraint;
    }

    @NotNull
    public Point2D.Double getShapeFrameLocation() {
        return this.myShapeFrameLocation;
    }

    @NotNull
    protected AffineTransform computeAffineTransform(@Nullable InheritedProperties inheritedProperties) {
        if (inheritedProperties != null) {
            this.myShapeFrameLocation.setLocation(inheritedProperties.getInheritedTranslation());
            this.myIsflippedhorizontal = inheritedProperties.isInheritedFlipX();
            this.myIsFlippedVertical = inheritedProperties.isInheritedFlipY();
            this.myRotationDegrees = inheritedProperties.getInheritedRotation();
        }
        AffineTransform shapeTransform = new AffineTransform();
        shapeTransform.setToIdentity();
        shapeTransform.translate(this.myShapeFrameLocation.getX(), this.myShapeFrameLocation.getY());
        if (this.myIsflippedhorizontal) {
            shapeTransform.scale(-1.0, 1.0);
            shapeTransform.translate(-(this.myShapeBounds.getWidth() + 2.0 * this.myShapeBounds.getX()), 0.0);
        }
        if (this.myIsFlippedVertical) {
            shapeTransform.scale(1.0, -1.0);
            shapeTransform.translate(0.0, -(this.myShapeBounds.getHeight() + 2.0 * this.myShapeBounds.getY()));
        }
        shapeTransform.rotate(Math.toRadians(-this.myRotationDegrees), this.myShapeBounds.getCenterX(), this.myShapeBounds.getCenterY());
        return shapeTransform;
    }

    @NotNull
    public String getPathString() {
        PathStringBuilder pathStringBuilder = new PathStringBuilder();
        PathIterator pathIterator = this.myShape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            double[] coordinates = new double[6];
            int type = pathIterator.currentSegment(coordinates);
            switch (type) {
                case 0: {
                    pathStringBuilder.startPath(coordinates[0], coordinates[1]);
                    break;
                }
                case 1: {
                    pathStringBuilder.createLine(coordinates[0], coordinates[1]);
                    break;
                }
                case 3: {
                    pathStringBuilder.createBezierCurve(coordinates);
                    break;
                }
                case 2: {
                    pathStringBuilder.createQuadCurve(coordinates[0], coordinates[1], coordinates[2], coordinates[3]);
                    break;
                }
                case 4: {
                    pathStringBuilder.endPath();
                }
            }
            pathIterator.next();
        }
        return pathStringBuilder.build();
    }

    protected void transformGradient(@NotNull AffineTransform transform) {
        GradientModel shapeGradient;
        FillModel shapeFill = this.myShapeStyle != null ? this.myShapeStyle.getFill() : null;
        GradientModel gradientModel = shapeGradient = shapeFill != null ? shapeFill.getGradientModel() : null;
        if (shapeGradient != null) {
            shapeGradient.applyTransformation(transform);
        }
    }

    public void applyOpacity(double parentOpacity) {
        if (this.myShapeStyle != null) {
            this.myShapeStyle.applyOpacity(parentOpacity);
        }
    }

    public void setFramePosition(@NotNull Point2D.Double position) {
        this.myShapeFrameLocation = position;
    }

    public abstract void applyTransformations(@Nullable InheritedProperties var1);

    public abstract void scale(double var1, double var3);

    public abstract void translateTo(double var1, double var3);
}

