/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.ServiceProxy;
import com.android.tools.idea.transport.TransportBytesPreprocessor;
import com.android.tools.idea.transport.TransportEventPreprocessor;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ServerServiceDefinition;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransportServiceProxy
extends ServiceProxy
implements AndroidDebugBridge.IClientChangeListener,
AndroidDebugBridge.IDeviceChangeListener {
    private static final String EMULATOR = "Emulator";
    static final String PRE_LOLLIPOP_FAILURE_REASON = "Pre-Lollipop devices are not supported.";
    private final TransportServiceGrpc.TransportServiceBlockingStub myServiceStub;
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final Common.Device myProfilerDevice;
    private final Map<Client, Common.Process> myCachedProcesses = Collections.synchronizedMap(new HashMap());
    private final boolean myIsDeviceApiSupported;
    private final BlockingDeque<Common.Event> myEventQueue;
    private Thread myEventsListenerThread;
    private final Map<Commands.Command.CommandType, TransportProxy.ProxyCommandHandler> myCommandHandlers = new HashMap<Commands.Command.CommandType, TransportProxy.ProxyCommandHandler>();
    private final List<TransportEventPreprocessor> myEventPreprocessors = new ArrayList<TransportEventPreprocessor>();
    private final List<TransportBytesPreprocessor> myDataPreprocessors = new ArrayList<TransportBytesPreprocessor>();
    @NotNull
    private final Map<String, ByteString> myProxyBytesCache;
    private long myLatestEventTimestampNs = Long.MIN_VALUE;
    @Nullable
    private CountDownLatch myEventStreamingLatch = null;

    private static Logger getLog() {
        return Logger.getInstance(TransportServiceProxy.class);
    }

    public TransportServiceProxy(@NotNull IDevice ddmlibDevice, @NotNull Common.Device transportDevice, @NotNull ManagedChannel channel, @NotNull BlockingDeque<Common.Event> proxyEventQueue, @NotNull Map<String, ByteString> proxyBytesCache) {
        super(TransportServiceGrpc.getServiceDescriptor());
        this.myDevice = ddmlibDevice;
        this.myProfilerDevice = transportDevice;
        this.myIsDeviceApiSupported = this.myProfilerDevice.getUnsupportedReason().isEmpty();
        this.myServiceStub = TransportServiceGrpc.newBlockingStub((Channel)channel);
        this.myEventQueue = proxyEventQueue;
        this.myProxyBytesCache = proxyBytesCache;
        TransportServiceProxy.getLog().info(String.format("ProfilerDevice created: %s", this.myProfilerDevice));
        this.updateProcesses();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
    }

    public void registerCommandHandler(Commands.Command.CommandType commandType, TransportProxy.ProxyCommandHandler handler2) {
        this.myCommandHandlers.put(commandType, handler2);
    }

    public void registerEventPreprocessor(TransportEventPreprocessor eventPreprocessor) {
        this.myEventPreprocessors.add(eventPreprocessor);
    }

    public void registerDataPreprocessor(TransportBytesPreprocessor dataPreprocessor) {
        this.myDataPreprocessors.add(dataPreprocessor);
    }

    @NotNull
    public static Common.Device transportDeviceFromIDevice(@NotNull IDevice device) {
        long device_id;
        final StringBuilder bootIdBuilder = new StringBuilder();
        try {
            device.executeShellCommand("cat /proc/sys/kernel/random/boot_id", (IShellOutputReceiver)new MultiLineReceiver(){

                public void processNewLines(String[] lines2) {
                    assert (lines2.length == 1);
                    bootIdBuilder.append(lines2[0]);
                }

                public boolean isCancelled() {
                    return false;
                }
            });
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            TransportServiceProxy.getLog().warn(String.format("Unable to retrieve boot_id from device %s", device), e);
        }
        String bootId = bootIdBuilder.toString();
        if (bootId.isEmpty()) {
            bootId = String.valueOf(device.getSerialNumber().hashCode());
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(bootId.getBytes());
            digest.update(device.getSerialNumber().getBytes());
            device_id = ByteBuffer.wrap(digest.digest()).getLong();
        }
        catch (NoSuchAlgorithmException e) {
            TransportServiceProxy.getLog().info("SHA-256 is not available", (Throwable)e);
            device_id = new Random(System.currentTimeMillis()).nextLong();
        }
        return Common.Device.newBuilder().setDeviceId(device_id).setSerial(device.getSerialNumber()).setModel(TransportServiceProxy.getDeviceModel(device)).setVersion(StringUtil.notNullize((String)device.getProperty("ro.build.version.release"))).setCodename(StringUtil.notNullize((String)device.getVersion().getCodename())).setApiLevel(device.getVersion().getApiLevel()).setFeatureLevel(device.getVersion().getFeatureLevel()).setManufacturer(TransportServiceProxy.getDeviceManufacturer(device)).setIsEmulator(device.isEmulator()).setBuildTags(device.getProperty("ro.build.tags")).setBuildType(device.getProperty("ro.build.type")).setCpuAbi(device.getProperty("ro.product.cpu.abi")).setState(TransportServiceProxy.convertState(device.getState())).setUnsupportedReason(TransportServiceProxy.getDeviceUnsupportedReason(device)).build();
    }

    private static Common.Device.State convertState(@NotNull IDevice.DeviceState state) {
        switch (state) {
            case OFFLINE: {
                return Common.Device.State.OFFLINE;
            }
            case ONLINE: {
                return Common.Device.State.ONLINE;
            }
            case DISCONNECTED: {
                return Common.Device.State.DISCONNECTED;
            }
        }
        return Common.Device.State.UNSPECIFIED;
    }

    @NotNull
    private static String getDeviceUnsupportedReason(@NotNull IDevice device) {
        String unsupportedReason = "";
        if (device.getVersion().getFeatureLevel() < 21) {
            unsupportedReason = PRE_LOLLIPOP_FAILURE_REASON;
        }
        return unsupportedReason;
    }

    @NotNull
    public static String getDeviceModel(@NotNull IDevice device) {
        return device.isEmulator() ? StringUtil.notNullize((String)device.getAvdName(), (String)"Unknown") : DevicePropertyUtil.getModel(device, "Unknown");
    }

    @NotNull
    public static String getDeviceManufacturer(@NotNull IDevice device) {
        return DevicePropertyUtil.getManufacturer(device, device.isEmulator() ? EMULATOR : "");
    }

    @Override
    public void disconnect() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        if (this.myEventStreamingLatch != null) {
            try {
                this.myEventStreamingLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void getDevices(Transport.GetDevicesRequest request, StreamObserver<Transport.GetDevicesResponse> responseObserver2) {
        Transport.GetDevicesResponse response = Transport.GetDevicesResponse.newBuilder().addDevice(this.myProfilerDevice).build();
        responseObserver2.onNext((Object)response);
        responseObserver2.onCompleted();
    }

    public void getEvents(Transport.GetEventsRequest request, StreamObserver<Common.Event> responseObserver2) {
        new Thread(() -> {
            Iterator response = this.myServiceStub.getEvents(request);
            try {
                while (response.hasNext()) {
                    Common.Event event = (Common.Event)response.next();
                    if (event == null) continue;
                    this.myEventQueue.offer(event);
                }
            }
            catch (StatusRuntimeException statusRuntimeException) {
                // empty catch block
            }
            if (this.myEventsListenerThread != null) {
                this.myEventsListenerThread.interrupt();
                this.myEventsListenerThread = null;
            }
        }).start();
        this.myEventStreamingLatch = new CountDownLatch(1);
        this.myEventsListenerThread = new Thread(() -> {
            HashMap<Common.Event.Kind, Long2ObjectMap> ongoingEventGroups = new HashMap<Common.Event.Kind, Long2ObjectMap>();
            while (!Thread.currentThread().isInterrupted() || !this.myEventQueue.isEmpty()) {
                try {
                    Common.Event event = this.myEventQueue.take();
                    this.myLatestEventTimestampNs = Math.max(this.myLatestEventTimestampNs, event.getTimestamp());
                    for (TransportEventPreprocessor preprocessor : this.myEventPreprocessors) {
                        if (!preprocessor.shouldPreprocess(event)) continue;
                        preprocessor.preprocessEvent(event).forEach(generatedEvent -> responseObserver2.onNext(generatedEvent));
                    }
                    if (event.getIsEnded()) {
                        ongoingEventGroups.computeIfPresent(event.getKind(), (kind, map2) -> {
                            map2.remove(event.getGroupId());
                            return map2.isEmpty() ? null : map2;
                        });
                    } else if (event.getGroupId() != 0L) {
                        ongoingEventGroups.compute(event.getKind(), (kind, map2) -> {
                            if (map2 == null) {
                                map2 = new Long2ObjectOpenHashMap();
                            }
                            map2.put(event.getGroupId(), (Object)event);
                            return map2;
                        });
                    }
                    responseObserver2.onNext((Object)event);
                }
                catch (InterruptedException exception) {
                    Thread.currentThread().interrupt();
                }
            }
            for (Common.Event.Kind kind2 : ongoingEventGroups.keySet()) {
                for (Common.Event lastEvent : ((Long2ObjectMap)ongoingEventGroups.get(kind2)).values()) {
                    responseObserver2.onNext((Object)this.generateEndEvent(lastEvent));
                }
            }
            responseObserver2.onCompleted();
            this.myEventStreamingLatch.countDown();
        });
        this.myEventsListenerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBytes(@NotNull Transport.BytesRequest request, StreamObserver<Transport.BytesResponse> responseObserver2) {
        Map<String, ByteString> map2 = this.myProxyBytesCache;
        synchronized (map2) {
            Transport.BytesResponse.Builder response;
            if (this.myProxyBytesCache.containsKey(request.getId())) {
                response = Transport.BytesResponse.newBuilder().setContents(this.myProxyBytesCache.get(request.getId()));
                this.myProxyBytesCache.remove(request.getId());
            } else {
                response = this.myServiceStub.getBytes(request).toBuilder();
            }
            for (TransportBytesPreprocessor preprocessor : this.myDataPreprocessors) {
                if (!preprocessor.shouldPreprocess(request)) continue;
                response.setContents(preprocessor.preprocessBytes(request.getId(), response.getContents()));
            }
            responseObserver2.onNext((Object)response.build());
            responseObserver2.onCompleted();
        }
    }

    @NotNull
    private Common.Event generateEndEvent(@NotNull Common.Event previousEvent) {
        return Common.Event.newBuilder().setKind(previousEvent.getKind()).setGroupId(previousEvent.getGroupId()).setPid(previousEvent.getPid()).setTimestamp(this.myLatestEventTimestampNs + 1L).setIsEnded(true).build();
    }

    public void getCurrentTime(Transport.TimeRequest request, StreamObserver<Transport.TimeResponse> responseObserver2) {
        Transport.TimeResponse response;
        if (this.myIsDeviceApiSupported) {
            try {
                response = this.myServiceStub.getCurrentTime(request);
            }
            catch (StatusRuntimeException e) {
                responseObserver2.onError((Throwable)e);
                return;
            }
        } else {
            response = Transport.TimeResponse.getDefaultInstance();
        }
        responseObserver2.onNext((Object)response);
        responseObserver2.onCompleted();
    }

    public void getProcesses(Transport.GetProcessesRequest request, StreamObserver<Transport.GetProcessesResponse> responseObserver2) {
        Transport.GetProcessesResponse response = Transport.GetProcessesResponse.newBuilder().addAllProcess(this.myCachedProcesses.values()).build();
        responseObserver2.onNext((Object)response);
        responseObserver2.onCompleted();
    }

    public void execute(Transport.ExecuteRequest request, StreamObserver<Transport.ExecuteResponse> responseObserver2) {
        Commands.Command command = request.getCommand();
        Transport.ExecuteResponse response = this.myCommandHandlers.containsKey(command.getType()) && this.myCommandHandlers.get(command.getType()).shouldHandle(command) ? this.myCommandHandlers.get(command.getType()).execute(command) : this.myServiceStub.execute(request);
        responseObserver2.onNext((Object)response);
        responseObserver2.onCompleted();
    }

    public void deviceConnected(IDevice device) {
    }

    public void deviceDisconnected(IDevice device) {
    }

    public void deviceChanged(IDevice device, int changeMask) {
        if (device == this.myDevice && (changeMask & 2) != 0) {
            this.updateProcesses();
        }
    }

    public void clientChanged(Client client, int changeMask) {
        if ((changeMask & 1) != 0 && client.getDevice() == this.myDevice && client.getClientData().getClientDescription() != null) {
            this.updateProcesses(Collections.singletonList(client), Collections.EMPTY_LIST);
        }
    }

    @Override
    public ServerServiceDefinition getServiceDefinition() {
        HashMap overrides = Maps.newHashMap();
        overrides.put(TransportServiceGrpc.getGetVersionMethod(), ServerCalls.asyncUnaryCall((request, observer2) -> this.getDevices((Transport.GetDevicesRequest)request, (StreamObserver<Transport.GetDevicesResponse>)observer2)));
        overrides.put(TransportServiceGrpc.getGetProcessesMethod(), ServerCalls.asyncUnaryCall((request, observer2) -> this.getProcesses((Transport.GetProcessesRequest)request, (StreamObserver<Transport.GetProcessesResponse>)observer2)));
        overrides.put(TransportServiceGrpc.getGetCurrentTimeMethod(), ServerCalls.asyncUnaryCall((request, observer2) -> this.getCurrentTime((Transport.TimeRequest)request, (StreamObserver<Transport.TimeResponse>)observer2)));
        overrides.put(TransportServiceGrpc.getGetEventsMethod(), ServerCalls.asyncUnaryCall((request, observer2) -> this.getEvents((Transport.GetEventsRequest)request, (StreamObserver<Common.Event>)observer2)));
        overrides.put(TransportServiceGrpc.getGetBytesMethod(), ServerCalls.asyncUnaryCall((request, observer2) -> this.getBytes((Transport.BytesRequest)request, (StreamObserver<Transport.BytesResponse>)observer2)));
        overrides.put(TransportServiceGrpc.getExecuteMethod(), ServerCalls.asyncUnaryCall((request, observer2) -> this.execute((Transport.ExecuteRequest)request, (StreamObserver<Transport.ExecuteResponse>)observer2)));
        return this.generatePassThroughDefinitions(overrides, (AbstractStub)this.myServiceStub);
    }

    private void updateProcesses() {
        if (!this.myIsDeviceApiSupported) {
            return;
        }
        Set updatedClients = Arrays.stream(this.myDevice.getClients()).filter(c -> c.getClientData().getClientDescription() != null).collect(Collectors.toSet());
        Set<Client> existingClients = this.myCachedProcesses.keySet();
        ImmutableSet removedClients = Sets.difference(existingClients, updatedClients).immutableCopy();
        ImmutableSet addedClients = Sets.difference(updatedClients, existingClients).immutableCopy();
        this.updateProcesses((Collection<Client>)addedClients, (Collection<Client>)removedClients);
    }

    private void updateProcesses(@NotNull Collection<Client> addedClients, @NotNull Collection<Client> removedClients) {
        Transport.TimeResponse times;
        if (!this.myIsDeviceApiSupported || !this.myDevice.isOnline()) {
            return;
        }
        try {
            times = this.myServiceStub.getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(this.myProfilerDevice.getDeviceId()).build());
        }
        catch (Exception e) {
            TransportServiceProxy.getLog().info((Throwable)e);
            return;
        }
        for (Client client : addedClients) {
            String description2 = client.getClientData().getClientDescription();
            if (description2 == null) continue;
            String abi = client.getClientData().getAbi();
            String abiCpuArch = abi != null && abi.contains(")") ? abi.substring(abi.indexOf(40) + 1, abi.indexOf(41)) : Abi.getEnum((String)((String)this.myDevice.getAbis().get(0))).getCpuArch();
            Common.Process process = Common.Process.newBuilder().setName(client.getClientData().getClientDescription()).setPid(client.getClientData().getPid()).setDeviceId(this.myProfilerDevice.getDeviceId()).setState(Common.Process.State.ALIVE).setStartTimestampNs(times.getTimestampNs()).setAbiCpuArch(abiCpuArch).build();
            this.myCachedProcesses.put(client, process);
            this.myEventQueue.offer(Common.Event.newBuilder().setGroupId((long)process.getPid()).setPid(process.getPid()).setKind(Common.Event.Kind.PROCESS).setProcess(Common.ProcessData.newBuilder().setProcessStarted(Common.ProcessData.ProcessStarted.newBuilder().setProcess(process))).setTimestamp(times.getTimestampNs()).build());
        }
        this.removeProcesses(removedClients, times.getTimestampNs());
    }

    private void removeProcesses(@NotNull Collection<Client> removedClients, long timestampNs) {
        for (Client client : removedClients) {
            Common.Process process = this.myCachedProcesses.remove(client);
            if (process == null) continue;
            this.myEventQueue.offer(Common.Event.newBuilder().setGroupId((long)process.getPid()).setPid(process.getPid()).setKind(Common.Event.Kind.PROCESS).setIsEnded(true).setTimestamp(timestampNs).build());
        }
    }

    @NotNull
    Map<Client, Common.Process> getCachedProcesses() {
        return this.myCachedProcesses;
    }
}

