/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExcludedModules
implements Iterable<Module> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<Module> myExcludedModules = new HashSet<Module>();

    ExcludedModules(@NotNull Module module2) {
        this.myProject = module2.getProject();
    }

    void add(@NotNull DependencySet dependencies2) {
        for (ModuleDependency dependency : dependencies2.onModules()) {
            Module dependencyModule = dependency.getModule();
            if (dependencyModule == null) continue;
            this.myExcludedModules.add(dependencyModule);
        }
    }

    void remove(@NotNull DependencySet dependencies2) {
        for (ModuleDependency dependency : dependencies2.onModules()) {
            Module dependencyModule = dependency.getModule();
            if (dependencyModule == null) continue;
            this.myExcludedModules.remove(dependencyModule);
        }
    }

    boolean contains(@Nullable Module module2) {
        return this.myExcludedModules.contains(module2);
    }

    @NotNull
    Project getProject() {
        return this.myProject;
    }

    @Override
    public Iterator<Module> iterator() {
        return this.myExcludedModules.iterator();
    }
}

