/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.annotations.concurrency.UiThread;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.util.EditorUtil;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0007Jg\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00112M\b\u0002\u0010\u0017\u001aG\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u001d0\u0018H\u0007J \u0010\u0017\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0011H\u0003J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u000bH\u0007J&\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110&2\u0006\u0010'\u001a\u00020\u001dH\u0007J\u001c\u0010(\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u00112\b\b\u0002\u0010)\u001a\u00020\u001dH\u0007J\u001a\u0010*\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u0013H\u0007J\u001a\u0010*\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u0011H\u0007J\"\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u00012\b\u0010-\u001a\u0004\u0018\u00010\u000b2\u0006\u0010.\u001a\u00020\u0011H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006/"}, d2={"Lcom/android/tools/idea/templates/TemplateUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "WINDOWS_NEWLINE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "knownVersions", "", "", "getKnownVersions", "()Ljava/util/List;", "checkDirectoryIsWriteable", "", "directory", "Ljava/io/File;", "checkedCreateDirectoryIfMissing", "Lcom/intellij/openapi/vfs/VirtualFile;", "copyDirectory", "src", "dest", "copyFile", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "file", "destination", "", "fileToCopy", "parent", "hasExtension", "extension", "openEditors", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "select", "readTextFromDisk", "warnIfNotExists", "readTextFromDocument", "writeTextFile", "requestor", "contents", "to", "intellij.android.core"})
public final class TemplateUtils {
    private static final Logger LOG;
    private static final Pattern WINDOWS_NEWLINE;
    public static final TemplateUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> getKnownVersions() {
        void $this$mapTo$iv$iv;
        Object object;
        Collection collection2;
        void $this$mapTo$iv$iv22;
        void $this$filterTo$iv$iv;
        AndroidSdkData sdkData;
        AndroidSdkData androidSdkData = sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        IAndroidTarget[] $this$orEmpty$iv = androidSdkData != null ? androidSdkData.getTargets() : null;
        boolean $i$f$orEmpty = false;
        IAndroidTarget[] iAndroidTargetArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            iAndroidTargetArray = new IAndroidTarget[]{};
        }
        IAndroidTarget[] $this$filter$iv = iAndroidTargetArray;
        boolean $i$f$filter = false;
        IAndroidTarget[] iAndroidTargetArray2 = $this$filter$iv;
        Iterable<void> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (IAndroidTarget element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!(it.isPlatform() && !it.getVersion().isPreview())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List targets = (List)destination$iv$iv;
        Iterable $this$map$iv = targets;
        int $i$f$map = 0;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv322 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv22) {
            void it;
            IAndroidTarget element$iv$iv;
            element$iv$iv = (IAndroidTarget)item$iv$iv;
            collection2 = destination$iv$iv322;
            boolean bl = false;
            object = it.getVersion().getApiLevel();
            collection2.add(object);
        }
        List targetLevels = (List)destination$iv$iv322;
        $i$f$map = 30;
        Integer n = (Integer)CollectionsKt.max((Iterable)targetLevels);
        int $this$mapTo$iv$iv22 = n != null ? n : 0;
        boolean destination$iv$iv322 = false;
        int maxApi = Math.max($i$f$map, $this$mapTo$iv$iv22);
        $i$f$map = 1;
        Iterable $this$map$iv2 = (Iterable)new IntRange($i$f$map, maxApi);
        boolean $i$f$map2 = false;
        Iterable destination$iv$iv322 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int bl = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection2 = destination$iv$iv2;
            boolean bl2 = false;
            object = SdkVersionInfo.getAndroidName((int)it);
            collection2.add(object);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void openEditors(@NotNull Project project, @NotNull Collection<? extends File> files2, boolean select2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        VirtualFile last = null;
        Iterable $this$filter$iv = files2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File p1 = (File)element$iv$iv;
            boolean bl = false;
            if (!p1.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile virtualFile;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if (VfsUtil.findFileByIoFile((File)it, (boolean)true) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            VirtualFile it$iv$iv = virtualFile;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            last = it;
            EditorUtil.openEditor(project, it);
        }
        if (select2 && last != null) {
            VirtualFile virtualFile = last;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            EditorUtil.selectEditor(project, virtualFile);
        }
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String readTextFromDisk(@NotNull File file2, boolean warnIfNotExists) {
        String string;
        boolean bl = file2.isAbsolute();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        try {
            string = Files.asCharSource((File)file2, (Charset)Charsets.UTF_8).read();
        }
        catch (IOException e) {
            if (warnIfNotExists) {
                LOG.warn((Throwable)e);
            }
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String readTextFromDisk$default(File file2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return TemplateUtils.readTextFromDisk(file2, bl);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String readTextFromDisk(@NotNull File file2) {
        return TemplateUtils.readTextFromDisk$default(file2, false, 2, null);
    }

    @JvmStatic
    @Nullable
    public static final String readTextFromDocument(@NotNull Project project, @NotNull File file2) {
        boolean bl = project.isInitialized();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file2);
        if (vFile == null) {
            LOG.debug("Cannot find file " + file2.getPath() + " in the VFS");
            return null;
        }
        return TemplateUtils.readTextFromDocument(project, vFile);
    }

    @JvmStatic
    @Nullable
    public static final String readTextFromDocument(@NotNull Project project, @NotNull VirtualFile file2) {
        boolean bl = project.isInitialized();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(file2){
            final /* synthetic */ VirtualFile $file;

            public final String compute() {
                Document document;
                Document document2 = document = FileDocumentManager.getInstance().getDocument(this.$file);
                return document2 != null ? document2.getText() : null;
            }
            {
                this.$file = virtualFile;
            }
        });
    }

    @JvmStatic
    public static final void writeTextFile(@NotNull Object requestor, @Nullable String contents, @NotNull File to) throws IOException {
        Document document;
        if (contents == null) {
            return;
        }
        VirtualFile vf = LocalFileSystem.getInstance().findFileByIoFile(to);
        if (vf == null) {
            VirtualFile parentDir = TemplateUtils.checkedCreateDirectoryIfMissing(to.getParentFile());
            vf = parentDir.createChildData(requestor, to.getName());
        }
        if ((document = FileDocumentManager.getInstance().getDocument(vf)) != null) {
            document.setText((CharSequence)WINDOWS_NEWLINE.matcher(contents).replaceAll("\n"));
            FileDocumentManager.getInstance().saveDocument(document);
        } else {
            String string = contents;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            vf.setBinaryContent(byArray, -1L, -1L, requestor);
        }
    }

    @JvmStatic
    @NotNull
    public static final VirtualFile checkedCreateDirectoryIfMissing(@NotNull File directory) throws IOException {
        return (VirtualFile)WriteCommandAction.runWriteCommandAction(null, (ThrowableComputable)((ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(directory){
            final /* synthetic */ File $directory;

            public final VirtualFile compute() {
                VirtualFile virtualFile = VfsUtil.createDirectoryIfMissing((String)this.$directory.getAbsolutePath());
                if (virtualFile == null) {
                    throw (Throwable)new IOException("Unable to create " + this.$directory.getAbsolutePath());
                }
                return virtualFile;
            }
            {
                this.$directory = file2;
            }
        }));
    }

    @JvmStatic
    public static final void checkDirectoryIsWriteable(@NotNull File directory) throws IOException {
        File d = directory;
        while (!d.exists() || !d.isDirectory()) {
            d = d.getParentFile();
        }
        if (!d.canWrite()) {
            throw (Throwable)new IOException("Cannot write to folder: " + d.getAbsolutePath());
        }
    }

    @JvmStatic
    @UiThread
    @JvmOverloads
    public static final void copyDirectory(@NotNull VirtualFile src, @NotNull File dest, @NotNull Function3<? super VirtualFile, ? super VirtualFile, ? super File, Boolean> copyFile) {
        if (VfsUtilCore.visitChildrenRecursively((VirtualFile)src, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(copyFile, src, dest, new VirtualFileVisitor.Option[0]){
            final /* synthetic */ Function3 $copyFile;
            final /* synthetic */ VirtualFile $src;
            final /* synthetic */ File $dest;

            public boolean visitFile(@NotNull VirtualFile file2) {
                try {
                    return (Boolean)this.$copyFile.invoke((Object)file2, (Object)this.$src, (Object)this.$dest);
                }
                catch (IOException e) {
                    throw (Throwable)new VirtualFileVisitor.VisitorException((Throwable)e);
                }
            }
            {
                this.$copyFile = $captured_local_variable$0;
                this.$src = $captured_local_variable$1;
                this.$dest = $captured_local_variable$2;
                super($super_call_param$3);
            }
        }), IOException.class) == null) {
            Intrinsics.throwNpe();
        }
    }

    public static /* synthetic */ void copyDirectory$default(VirtualFile virtualFile, File file2, Function3 function3, int n, Object object) {
        if ((n & 4) != 0) {
            function3 = (Function3)new Function3<VirtualFile, VirtualFile, File, Boolean>(INSTANCE){

                public final boolean invoke(@NotNull VirtualFile p1, @NotNull VirtualFile p2, @NotNull File p3) {
                    TemplateUtils cfr_ignored_0 = (TemplateUtils)this.receiver;
                    return TemplateUtils.access$copyFile(p1, p2, p3);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(TemplateUtils.class);
                }

                public final String getName() {
                    return "copyFile";
                }

                public final String getSignature() {
                    return "copyFile(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/io/File;)Z";
                }
            };
        }
        TemplateUtils.copyDirectory(virtualFile, file2, (Function3<? super VirtualFile, ? super VirtualFile, ? super File, Boolean>)function3);
    }

    @JvmStatic
    @UiThread
    @JvmOverloads
    public static final void copyDirectory(@NotNull VirtualFile src, @NotNull File dest) {
        TemplateUtils.copyDirectory$default(src, dest, null, 4, null);
    }

    @JvmStatic
    @UiThread
    private static final boolean copyFile(VirtualFile fileToCopy, VirtualFile parent, File destination) {
        VirtualFile targetVf;
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)fileToCopy, (VirtualFile)parent, (char)File.separatorChar);
        boolean bl = relativePath != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = fileToCopy.getPath() + " is not a child of " + parent;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (fileToCopy.isDirectory()) {
            TemplateUtils.checkedCreateDirectoryIfMissing(new File(destination, relativePath));
            return true;
        }
        File target = new File(destination, relativePath);
        VirtualFile toDir = TemplateUtils.checkedCreateDirectoryIfMissing(target.getParentFile());
        VirtualFile virtualFile = targetVf = LocalFileSystem.getInstance().findFileByIoFile(target);
        if (virtualFile != null) {
            if (virtualFile.exists()) {
                return false;
            }
        }
        VfsUtilCore.copyFile((Object)INSTANCE, (VirtualFile)fileToCopy, (VirtualFile)toDir);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean hasExtension(@NotNull File file2, @NotNull String extension) {
        CharSequence charSequence;
        String string;
        block2: {
            void $this$trimStart$iv;
            String string2 = extension;
            string = Files.getFileExtension((String)file2.getName());
            boolean $i$f$trimStart = false;
            CharSequence $this$trimStart$iv$iv = (CharSequence)$this$trimStart$iv;
            boolean $i$f$trimStart2 = false;
            int n = 0;
            int n2 = $this$trimStart$iv$iv.length();
            while (n < n2) {
                void index$iv$iv;
                char it = $this$trimStart$iv$iv.charAt((int)index$iv$iv);
                boolean bl = false;
                if (!(it == '.')) {
                    charSequence = $this$trimStart$iv$iv.subSequence((int)index$iv$iv, $this$trimStart$iv$iv.length());
                    break block2;
                }
                ++index$iv$iv;
            }
            charSequence = "";
        }
        String string3 = ((Object)charSequence).toString();
        return StringsKt.equals((String)string, (String)string3, (boolean)true);
    }

    private TemplateUtils() {
    }

    static {
        TemplateUtils templateUtils;
        INSTANCE = templateUtils = new TemplateUtils();
        LOG = Logger.getInstance((String)"#org.jetbrains.android.templates.DomUtilities");
        WINDOWS_NEWLINE = Pattern.compile("\r\n");
    }

    public static final /* synthetic */ boolean access$copyFile(VirtualFile fileToCopy, VirtualFile parent, File destination) {
        return TemplateUtils.copyFile(fileToCopy, parent, destination);
    }
}

