/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.util.StudioPathManager;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import java.io.File;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.annotations.NotNull;

public class ExternalAnnotationsSupport {
    private static final Logger LOG = Logger.getInstance(ExternalAnnotationsSupport.class);

    private static void checkAnnotationsJarAttached(@NotNull PsiFile file2, @NotNull ProblemsHolder holder) {
    }

    public static void attachJdkAnnotations(@NotNull SdkModificator modificator) {
        File sdkRoot;
        String sdkRootPath;
        AndroidSdkAdditionalData additionalData;
        String platformHash;
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        VirtualFile root2 = null;
        if (modificator.getSdkAdditionalData() instanceof AndroidSdkAdditionalData && (platformHash = (additionalData = (AndroidSdkAdditionalData)modificator.getSdkAdditionalData()).getBuildTargetHashString()) != null && (sdkRootPath = modificator.getHomePath()) != null && (sdkRoot = new File(sdkRootPath)).isDirectory()) {
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(ExternalAnnotationsSupport.class);
            AndroidSdkHandler sdkHandler = AndroidSdkHandler.getInstance((File)sdkRoot);
            LocalPackage info2 = sdkHandler.getLocalPackage("platforms;" + platformHash, (ProgressIndicator)progress);
            if (info2 != null) {
                DetailsTypes.PlatformDetailsType details;
                Revision revision = info2.getVersion();
                if (info2.getTypeDetails() instanceof DetailsTypes.PlatformDetailsType && ((details = (DetailsTypes.PlatformDetailsType)info2.getTypeDetails()).getApiLevel() >= 29 || details.getApiLevel() == 28 && revision.getMajor() >= 5)) {
                    String releaseLocation = info2.getLocation().getPath() + File.separator + "data" + File.separator + "annotations.zip";
                    root2 = fileManager.findFileByUrl("jar://" + FileUtil.toSystemIndependentName((String)releaseLocation) + "!/");
                }
            }
        }
        if (root2 == null) {
            String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
            String releaseLocation = homePath + "/plugins/android/lib/androidAnnotations.jar";
            root2 = fileManager.findFileByUrl("jar://" + releaseLocation + "!/");
            if (root2 == null) {
                String[] paths;
                for (String relativePath : paths = new String[]{StudioPathManager.isRunningFromSources() ? FileUtil.join((String[])new String[]{StudioPathManager.getSourcesRoot(), "tools/adt/idea/android/annotations"}) : null, FileUtil.join((String[])new String[]{homePath, "android/android/annotations"}), FileUtil.join((String[])new String[]{homePath, "community/android/android/annotations"})}) {
                    if (relativePath == null) continue;
                    if (root2 != null) break;
                    root2 = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)relativePath));
                }
            }
            if (root2 == null) {
                LOG.error("jdk annotations not found in: " + releaseLocation);
                return;
            }
        }
        OrderRootType annoType = AnnotationOrderRootType.getInstance();
        modificator.removeRoot(root2, annoType);
        modificator.addRoot(root2, annoType);
    }

    public static void addAnnotations(@NotNull Sdk sdk) {
        SdkModificator modifier2 = sdk.getSdkModificator();
        ExternalAnnotationsSupport.attachJdkAnnotations(modifier2);
        modifier2.commitChanges();
    }

    public static void addAnnotationsIfNecessary(@NotNull Sdk sdk) {
        VirtualFile[] roots = sdk.getRootProvider().getFiles(AnnotationOrderRootType.getInstance());
        if (roots.length > 0) {
            return;
        }
        SdkModificator modifier2 = sdk.getSdkModificator();
        ExternalAnnotationsSupport.attachJdkAnnotations(modifier2);
        modifier2.commitChanges();
    }
}

