/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.util;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.sdklib.AndroidVersion;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiUserUtils {
    public static final int PRIMARY_USERID = 0;

    public static boolean isCurrentUserThePrimaryUser(@NotNull IDevice device, long timeout, TimeUnit units, boolean defaultValue2) {
        if (device.getVersion().getApiLevel() < AndroidVersion.SUPPORTS_MULTI_USER.getApiLevel()) {
            return false;
        }
        CountDownLatch latch = new CountDownLatch(1);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
        try {
            device.executeShellCommand("am get-current-user", (IShellOutputReceiver)receiver);
        }
        catch (Exception e) {
            return defaultValue2;
        }
        try {
            latch.await(timeout, units);
        }
        catch (InterruptedException e) {
            Logger.getInstance(MultiUserUtils.class).warn("Timed out waiting for output from `am get-current-user`, returning " + defaultValue2);
            return defaultValue2;
        }
        String output = receiver.getOutput();
        try {
            return Integer.parseInt(output.trim()) == 0;
        }
        catch (NumberFormatException e) {
            if (output.length() > 40) {
                output = output.substring(0, 40) + "...";
            }
            Logger.getInstance(MultiUserUtils.class).warn("Error parsing output of `am get-current-user`: " + output);
            return defaultValue2;
        }
    }

    public static boolean hasMultipleUsers(@Nullable IDevice device, long timeout, TimeUnit units, boolean defaultValue2) {
        if (device == null) {
            return defaultValue2;
        }
        if (device.getVersion().getApiLevel() < AndroidVersion.SUPPORTS_MULTI_USER.getApiLevel()) {
            return false;
        }
        PmListUserReceiver receiver = new PmListUserReceiver();
        try {
            device.executeShellCommand("pm list users", (IShellOutputReceiver)receiver, timeout, units);
        }
        catch (Exception e) {
            Logger.getInstance(MultiUserUtils.class).warn("Timed out waiting for output from `pm list users`, returning " + defaultValue2);
            return defaultValue2;
        }
        return receiver.getNumUsers() > 1;
    }

    public static int getUserIdFromAmParameters(@NotNull String amFlags) {
        String userFlag = "--user";
        int i2 = amFlags.indexOf(userFlag);
        if (i2 < 0) {
            return 0;
        }
        if ((i2 += userFlag.length() + 1) > amFlags.length()) {
            return 0;
        }
        amFlags = amFlags.substring(i2).trim();
        try {
            return Integer.parseInt(amFlags);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @VisibleForTesting
    static final class PmListUserReceiver
    extends MultiLineReceiver {
        private int myNumUsers = 0;

        PmListUserReceiver() {
        }

        public void processNewLines(String[] lines2) {
            for (String line2 : lines2) {
                if (!line2.contains("UserInfo{")) continue;
                ++this.myNumUsers;
            }
        }

        public boolean isCancelled() {
            return false;
        }

        private int getNumUsers() {
            return this.myNumUsers;
        }
    }
}

