/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.tasks.SplitApkDeployTaskContext;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DynamicAppDeployTaskContext
implements SplitApkDeployTaskContext {
    private ApkInfo myApkInfo;
    private List<String> myDisabledFeatures;

    public DynamicAppDeployTaskContext(@NotNull ApkInfo apkInfo, @NotNull List<String> disabledFeatures) {
        this.myApkInfo = apkInfo;
        this.myDisabledFeatures = disabledFeatures;
    }

    @Override
    @NotNull
    public String getApplicationId() {
        return this.myApkInfo.getApplicationId();
    }

    @Override
    public boolean isPatchBuild() {
        return false;
    }

    @Override
    @NotNull
    public List<File> getArtifacts() {
        return this.myApkInfo.getFiles().stream().filter(entry -> DynamicAppUtils.isFeatureEnabled(this.myDisabledFeatures, entry)).map(entry -> entry.getApkFile()).collect(Collectors.toList());
    }

    @NotNull
    public List<String> getDisabledFeatures() {
        return this.myDisabledFeatures;
    }

    @Override
    public void notifyInstall(@NotNull Project project, @NotNull IDevice device, boolean status) {
    }
}

