/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.AndroidLogcatToolWindowFactory;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import org.jetbrains.annotations.NotNull;

public class ClearLogcatTask
implements LaunchTask {
    private final Project myProject;
    private static final String ID = "CLEAR_LOGCAT";

    public ClearLogcatTask(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Clearing logcat";
    }

    @Override
    public int getDuration() {
        return 1;
    }

    @Override
    public LaunchResult run(@NotNull LaunchContext launchContext) {
        ClearLogcatTask.clearLogcatAndConsole(this.myProject, launchContext.getDevice());
        return LaunchResult.success();
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    private static void clearLogcatAndConsole(final @NotNull Project project, final @NotNull IDevice device) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(AndroidLogcatToolWindowFactory.getToolWindowId());
                if (toolWindow == null) {
                    return;
                }
                for (Content content2 : toolWindow.getContentManager().getContents()) {
                    AndroidLogcatView view = (AndroidLogcatView)content2.getUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY);
                    if (view == null) continue;
                    AndroidLogcatService.getInstance().clearLogcat(device, project);
                }
            }
        });
    }
}

