/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.emulator.snapshot.SnapshotOuterClass;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.deployment.AsyncSupplier;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Snapshot;
import com.android.tools.idea.run.deployment.VirtualDevice;
import com.android.tools.idea.run.deployment.VirtualDeviceName;
import com.android.tools.idea.run.deployment.VirtualDevicePath;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VirtualDevicesTask
implements AsyncSupplier<Collection<VirtualDevice>> {
    @NotNull
    private final ExecutorService myExecutorService;
    @NotNull
    private final @NotNull Supplier<@NotNull Collection<@NotNull AvdInfo>> myGetAvds;
    @NotNull
    private final BooleanSupplier mySelectDeviceSnapshotComboBoxSnapshotsEnabled;
    @NotNull
    private final FileSystem myFileSystem;
    @NotNull
    private final @NotNull Function<@NotNull AvdInfo, @NotNull AndroidDevice> myNewLaunchableAndroidDevice;
    @Nullable
    private final LaunchCompatibilityChecker myChecker;

    private VirtualDevicesTask(@NotNull Builder builder2) {
        assert (builder2.myExecutorService != null);
        this.myExecutorService = builder2.myExecutorService;
        assert (builder2.myGetAvds != null);
        this.myGetAvds = builder2.myGetAvds;
        assert (builder2.mySelectDeviceSnapshotComboBoxSnapshotsEnabled != null);
        this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled = builder2.mySelectDeviceSnapshotComboBoxSnapshotsEnabled;
        assert (builder2.myFileSystem != null);
        this.myFileSystem = builder2.myFileSystem;
        assert (builder2.myNewLaunchableAndroidDevice != null);
        this.myNewLaunchableAndroidDevice = builder2.myNewLaunchableAndroidDevice;
        this.myChecker = builder2.myChecker;
    }

    @Override
    @NotNull
    public ListenableFuture<Collection<VirtualDevice>> get() {
        return MoreExecutors.listeningDecorator((ExecutorService)this.myExecutorService).submit(this::getVirtualDevices);
    }

    @NotNull
    private Collection<VirtualDevice> getVirtualDevices() {
        Collection<AvdInfo> avdCollection = this.myGetAvds.get();
        Stream<AvdInfo> avdStream = avdCollection.stream();
        Collection deviceCollection = !this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled.getAsBoolean() ? (Collection)avdStream.map(avd -> this.newDisconnectedDevice((AvdInfo)avd, null)).collect(Collectors.toList()) : (Collection)avdStream.flatMap(this::newDisconnectedDevices).collect(Collectors.toList());
        if (!VirtualDevicesTask.hasDuplicateKeys(deviceCollection)) {
            return deviceCollection;
        }
        Logger.getInstance(VirtualDevicesTask.class).warn("duplicate keys found");
        VirtualDevicesTask.logDebugStrings(avdCollection);
        return VirtualDevicesTask.newListWithoutDuplicateKeys(deviceCollection);
    }

    @NotNull
    private Stream<VirtualDevice> newDisconnectedDevices(@NotNull AvdInfo device) {
        Stream.Builder<VirtualDevice> builder2 = Stream.builder().add(this.newDisconnectedDevice(device, null));
        this.getSnapshots(device).stream().map(snapshot -> this.newDisconnectedDevice(device, (Snapshot)snapshot)).forEach(builder2::add);
        return builder2.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Collection<Snapshot> getSnapshots(@NotNull AvdInfo device) {
        Path snapshots = this.myFileSystem.getPath(device.getDataFolderPath(), "snapshots");
        if (!Files.isDirectory(snapshots, new LinkOption[0])) {
            return ImmutableList.of();
        }
        try (Stream<Path> stream = Files.list(snapshots);){
            Collection collection2 = (Collection)stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(this::getSnapshot).filter(Objects::nonNull).sorted().collect(ImmutableList.toImmutableList());
            return collection2;
        }
        catch (IOException exception) {
            Logger.getInstance(VirtualDevicesTask.class).warn(snapshots.toString(), (Throwable)exception);
            return ImmutableList.of();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @VisibleForTesting
    Snapshot getSnapshot(@NotNull Path snapshotDirectory) {
        Path snapshotProtocolBuffer = snapshotDirectory.resolve("snapshot.pb");
        Path snapshotDirectoryName = snapshotDirectory.getFileName();
        if (!Files.exists(snapshotProtocolBuffer, new LinkOption[0])) {
            return new Snapshot(snapshotDirectoryName, this.myFileSystem);
        }
        try (InputStream in = Files.newInputStream(snapshotProtocolBuffer, new OpenOption[0]);){
            Snapshot snapshot = this.getSnapshot(SnapshotOuterClass.Snapshot.parseFrom((InputStream)in), snapshotDirectoryName);
            return snapshot;
        }
        catch (IOException exception) {
            Logger.getInstance(VirtualDevicesTask.class).warn(snapshotDirectory.toString(), (Throwable)exception);
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    Snapshot getSnapshot(@NotNull SnapshotOuterClass.Snapshot snapshot, @NotNull Path snapshotDirectory) {
        if (snapshot.getImagesCount() == 0) {
            return null;
        }
        String name = snapshot.getLogicalName();
        if (name.isEmpty()) {
            return new Snapshot(snapshotDirectory, this.myFileSystem);
        }
        return new Snapshot(snapshotDirectory, name);
    }

    @NotNull
    private VirtualDevice newDisconnectedDevice(@NotNull AvdInfo avd, @Nullable Snapshot snapshot) {
        AndroidDevice device = this.myNewLaunchableAndroidDevice.apply(avd);
        VirtualDevice.Builder builder2 = new VirtualDevice.Builder().setName(avd.getDisplayName()).setKey(new VirtualDevicePath(avd.getDataFolderPath())).setAndroidDevice(device).setNameKey(new VirtualDeviceName(avd.getName())).setSnapshot(snapshot);
        if (this.myChecker == null) {
            return builder2.build();
        }
        LaunchCompatibility compatibility = this.myChecker.validate(device);
        return builder2.setValid(!compatibility.isCompatible().equals((Object)ThreeState.NO)).setValidityReason(compatibility.getReason()).build();
    }

    private static boolean hasDuplicateKeys(@NotNull @NotNull Collection<@NotNull ? extends Device> devices2) {
        Collection keys = devices2.stream().map(Device::getKey).collect(Collectors.toSet());
        return keys.size() != devices2.size();
    }

    private static void logDebugStrings(@NotNull @NotNull Collection<@NotNull AvdInfo> avds) {
        Logger logger2 = Logger.getInstance(VirtualDevicesTask.class);
        avds.stream().map(AvdInfo::toDebugString).forEach(arg_0 -> ((Logger)logger2).warn(arg_0));
    }

    @NotNull
    private static @NotNull List<@NotNull VirtualDevice> newListWithoutDuplicateKeys(@NotNull @NotNull Collection<@NotNull VirtualDevice> devices2) {
        HashSet keys = Sets.newHashSetWithExpectedSize((int)devices2.size());
        return ContainerUtil.filter(devices2, device -> keys.add(device.getKey()));
    }

    static final class Builder {
        @Nullable
        private ExecutorService myExecutorService;
        private @Nullable Supplier<@NotNull Collection<@NotNull AvdInfo>> myGetAvds;
        @Nullable
        private BooleanSupplier mySelectDeviceSnapshotComboBoxSnapshotsEnabled;
        @Nullable
        private FileSystem myFileSystem;
        private @Nullable Function<@NotNull AvdInfo, @NotNull AndroidDevice> myNewLaunchableAndroidDevice;
        @Nullable
        private LaunchCompatibilityChecker myChecker;

        Builder() {
        }

        @NotNull
        Builder setExecutorService(@NotNull ExecutorService executorService) {
            this.myExecutorService = executorService;
            return this;
        }

        @NotNull
        Builder setGetAvds(@NotNull @NotNull Supplier<@NotNull Collection<@NotNull AvdInfo>> getAvds) {
            this.myGetAvds = getAvds;
            return this;
        }

        @NotNull
        Builder setSelectDeviceSnapshotComboBoxSnapshotsEnabled(@NotNull BooleanSupplier selectDeviceSnapshotComboBoxSnapshotsEnabled) {
            this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled = selectDeviceSnapshotComboBoxSnapshotsEnabled;
            return this;
        }

        @NotNull
        Builder setFileSystem(@NotNull FileSystem fileSystem) {
            this.myFileSystem = fileSystem;
            return this;
        }

        @NotNull
        Builder setNewLaunchableAndroidDevice(@NotNull @NotNull Function<@NotNull AvdInfo, @NotNull AndroidDevice> newLaunchableAndroidDevice) {
            this.myNewLaunchableAndroidDevice = newLaunchableAndroidDevice;
            return this;
        }

        @NotNull
        Builder setChecker(@Nullable LaunchCompatibilityChecker checker2) {
            this.myChecker = checker2;
            return this;
        }

        @NotNull
        VirtualDevicesTask build() {
            return new VirtualDevicesTask(this);
        }
    }
}

