/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.Devices;
import com.android.tools.idea.run.deployment.SelectDeviceAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SnapshotActionGroup
extends ActionGroup {
    @NotNull
    private final List<Device> myDevices;

    SnapshotActionGroup(@NotNull List<Device> devices2) {
        this.setPopup(true);
        this.myDevices = devices2;
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent event) {
        DeviceAndSnapshotComboBoxAction action2 = DeviceAndSnapshotComboBoxAction.getInstance();
        return (AnAction[])this.myDevices.stream().map(device -> SelectDeviceAction.newSnapshotActionGroupChild(device, action2)).toArray(AnAction[]::new);
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        presentation.setIcon(this.getIcon());
        presentation.setText(this.getText(), false);
    }

    @NotNull
    private Icon getIcon() {
        Optional<Icon> icon2 = this.myDevices.stream().filter(Device::isConnected).map(Device::getIcon).findFirst();
        return icon2.orElse(this.myDevices.get(0).getIcon());
    }

    @NotNull
    private String getText() {
        String name = this.getProperty(Device::getName);
        assert (name != null);
        return Devices.getText(name, this.getProperty(Device::getValidityReason));
    }

    @Nullable
    private <P> P getProperty(@NotNull Function<Device, P> accessor) {
        P property2 = accessor.apply(this.myDevices.get(0));
        assert (this.myDevices.subList(1, this.myDevices.size()).stream().map(accessor).allMatch(Predicate.isEqual(property2)));
        return property2;
    }
}

