/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.deployment.AsyncDevicesGetter;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxTarget;
import com.android.tools.idea.run.deployment.DevicesSelectedService;
import com.android.tools.idea.run.deployment.SelectMultipleDevicesDialog;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.base.MoreObjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeviceAndSnapshotComboBoxTargetProvider
extends DeployTargetProvider {
    static final Key<@NotNull Boolean> MULTIPLE_DEPLOY_TARGETS = Key.create((String)"com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxTargetProvider.MULTIPLE_DEPLOY_TARGETS");

    @Override
    @NotNull
    public String getId() {
        return TargetSelectionMode.DEVICE_AND_SNAPSHOT_COMBO_BOX.name();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Use the device/snapshot drop down";
    }

    @Override
    @NotNull
    public DeployTargetState createState() {
        return DeployTargetState.DEFAULT_STATE;
    }

    @Override
    @NotNull
    public DeployTargetConfigurable createConfigurable(@NotNull Project project, @NotNull Disposable parent, @NotNull DeployTargetConfigurableContext context) {
        return DeployTargetConfigurable.DEFAULT_CONFIGURABLE;
    }

    @Override
    public boolean requiresRuntimePrompt(@NotNull Project project) {
        return (Boolean)MoreObjects.firstNonNull((Object)project.getUserData(MULTIPLE_DEPLOY_TARGETS), (Object)false);
    }

    @Override
    @Nullable
    public DeployTarget showPrompt(@NotNull AndroidFacet facet2) {
        List<Device> devices2;
        Project project = facet2.getModule().getProject();
        if (!new SelectMultipleDevicesDialog(project, devices2 = AsyncDevicesGetter.getInstance(project).get().orElse(Collections.emptyList())).showAndGet()) {
            return null;
        }
        return new DeviceAndSnapshotComboBoxTarget(DevicesSelectedService.getInstance(project).getDevicesSelectedWithDialog(devices2));
    }

    @Override
    @NotNull
    public DeployTarget getDeployTarget(@NotNull Project project) {
        return new DeviceAndSnapshotComboBoxTarget(DeviceAndSnapshotComboBoxAction.getInstance().getSelectedDevices(project));
    }
}

