/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.deployer.DeploymentCacheDatabase;
import com.android.tools.deployer.SqlApkFileDatabase;
import com.android.tools.deployer.tasks.TaskRunner;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

public class DeploymentService {
    private final ExecutorService service = Executors.newFixedThreadPool(5);
    private final TaskRunner runner = new TaskRunner(this.service);
    private final NotNullLazyValue<SqlApkFileDatabase> dexDatabase;
    private final NotNullLazyValue<DeploymentCacheDatabase> deploymentCacheDatabase;

    @NotNull
    public static DeploymentService getInstance(@NotNull Project project) {
        return (DeploymentService)ServiceManager.getService((Project)project, DeploymentService.class);
    }

    private DeploymentService() {
        Path dexDbPath = Paths.get(PathManager.getSystemPath(), ".dex_cache.db");
        Path deployDbPath = Paths.get(PathManager.getSystemPath(), ".deploy_cache.db");
        this.dexDatabase = NotNullLazyValue.createValue(() -> new SqlApkFileDatabase(dexDbPath.toFile(), PathManager.getTempPath()));
        this.deploymentCacheDatabase = NotNullLazyValue.createValue(() -> new DeploymentCacheDatabase(deployDbPath.toFile()));
    }

    public TaskRunner getTaskRunner() {
        return this.runner;
    }

    public SqlApkFileDatabase getDexDatabase() {
        return (SqlApkFileDatabase)this.dexDatabase.getValue();
    }

    public DeploymentCacheDatabase getDeploymentCacheDatabase() {
        return (DeploymentCacheDatabase)this.deploymentCacheDatabase.getValue();
    }
}

