/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.deployable.SwappableProcessHandler;
import com.android.tools.idea.run.deployment.AndroidExecutionTarget;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRemoteDebugProcessHandler
extends ProcessHandler
implements SwappableProcessHandler {
    private final Project myProject;

    public AndroidRemoteDebugProcessHandler(Project project) {
        this.myProject = project;
        this.putCopyableUserData(SwappableProcessHandler.EXTENSION_KEY, this);
    }

    public void startNotify() {
        final DebugProcess debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        DebugProcessListener listener2 = new DebugProcessListener(){

            public void processDetached(@NotNull DebugProcess process, boolean closedByUser) {
                debugProcess.removeDebugProcessListener((DebugProcessListener)this);
                AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> AndroidRemoteDebugProcessHandler.this.notifyProcessDetached(), 1L, TimeUnit.SECONDS);
            }
        };
        debugProcess.addDebugProcessListener(listener2);
        try {
            super.startNotify();
        }
        finally {
            if (debugProcess.isDetached()) {
                debugProcess.removeDebugProcessListener(listener2);
                this.notifyProcessDetached();
            }
        }
    }

    protected void destroyProcessImpl() {
        DebugProcess debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        if (debugProcess != null) {
            debugProcess.stop(true);
        }
        this.notifyProcessTerminated(0);
    }

    protected void detachProcessImpl() {
        DebugProcess debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        if (debugProcess != null) {
            debugProcess.stop(false);
        }
        this.notifyProcessDetached();
    }

    public boolean detachIsDefault() {
        return false;
    }

    public boolean isSilentlyDestroyOnClose() {
        return false;
    }

    public OutputStream getProcessInput() {
        return null;
    }

    @Override
    @Nullable
    public Executor getExecutor() {
        AndroidSessionInfo sessionInfo = (AndroidSessionInfo)this.getUserData(AndroidSessionInfo.KEY);
        if (sessionInfo == null) {
            return null;
        }
        return sessionInfo.getExecutor();
    }

    @Override
    public boolean isRunningWith(@NotNull RunConfiguration runConfiguration, @NotNull ExecutionTarget executionTarget) {
        AndroidSessionInfo sessionInfo = (AndroidSessionInfo)this.getUserData(AndroidSessionInfo.KEY);
        if (sessionInfo == null) {
            return false;
        }
        if (sessionInfo.getRunConfiguration() != runConfiguration) {
            return false;
        }
        if (executionTarget instanceof AndroidExecutionTarget) {
            Client client = (Client)this.getUserData(AndroidSessionInfo.ANDROID_DEBUG_CLIENT);
            if (client == null || !client.isValid()) {
                return false;
            }
            IDevice device = client.getDevice();
            return ((AndroidExecutionTarget)executionTarget).getRunningDevices().stream().anyMatch(d -> d == device);
        }
        return sessionInfo.getExecutionTarget().getId().equals(executionTarget.getId());
    }
}

