/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.aar;

import com.android.tools.idea.resources.aar.FrameworkResourceRepository;
import com.android.tools.idea.resources.base.Base128OutputStream;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.io.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;

public class FrameworkResJarCreator {
    public static void main(@NotNull String[] args) {
        if (args.length != 2) {
            FrameworkResJarCreator.printUsage(FrameworkResJarCreator.class.getName());
            System.exit(1);
        }
        Path resDirectory = Paths.get(args[0], new String[0]).toAbsolutePath().normalize();
        Path jarFile = Paths.get(args[1], new String[0]).toAbsolutePath().normalize();
        try {
            FrameworkResJarCreator.createJar(resDirectory, jarFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @VisibleForTesting
    static void createJar(@NotNull Path resDirectory, @NotNull Path jarFile) throws IOException {
        FrameworkResourceRepository repository = FrameworkResourceRepository.create(resDirectory, null, null, false);
        Set<String> languages2 = repository.getLanguageGroups();
        try (ZipOutputStream zip = new ZipOutputStream(Files.newOutputStream(jarFile, new OpenOption[0]));){
            for (String language : languages2) {
                String entryName = FrameworkResourceRepository.getResourceTableNameForLanguage(language);
                FrameworkResJarCreator.createZipEntry(entryName, FrameworkResJarCreator.getEncodedResources(repository, language), zip);
            }
            Path parentDir = resDirectory.getParent();
            List<Path> files2 = FrameworkResJarCreator.getContainedFiles(resDirectory);
            for (Path file2 : files2) {
                String relativePath = FileUtil.toSystemIndependentName((String)parentDir.relativize(file2).toString());
                if (relativePath.equals("res/version")) continue;
                FrameworkResJarCreator.createZipEntry(relativePath, Files.readAllBytes(file2), zip);
            }
        }
    }

    @NotNull
    private static List<Path> getContainedFiles(@NotNull Path resDirectory) throws IOException {
        final ArrayList<Path> files2 = new ArrayList<Path>();
        Files.walkFileTree(resDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            @NotNull
            public FileVisitResult visitFile(@NotNull Path file2, @NotNull BasicFileAttributes attrs) {
                files2.add(file2);
                return FileVisitResult.CONTINUE;
            }
        });
        Collections.sort(files2);
        return files2;
    }

    private static void createZipEntry(@NotNull String name, @NotNull byte[] content2, @NotNull ZipOutputStream zip) throws IOException {
        ZipEntry entry = new ZipEntry(name);
        zip.putNextEntry(entry);
        zip.write(content2);
        zip.closeEntry();
    }

    @NotNull
    private static byte[] getEncodedResources(@NotNull FrameworkResourceRepository repository, @NotNull String language) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (Base128OutputStream stream = new Base128OutputStream(byteStream);){
            repository.writeToStream(stream, config -> language.equals(FrameworkResourceRepository.getLanguageGroup(config)));
        }
        return byteStream.toByteArray();
    }

    private static void printUsage(@NotNull String programName) {
        System.out.println(String.format("Usage: %s <res_directory> <jar_file>", programName));
    }
}

