/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SampleDataResourceValueImpl;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.sampledata.SampleDataCsvParser;
import com.android.ide.common.resources.sampledata.SampleDataHolder;
import com.android.ide.common.resources.sampledata.SampleDataJsonParser;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.ResolvableResourceItem;
import com.android.tools.idea.sampledata.datasource.HardcodedContent;
import com.google.common.base.Joiner;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SampleDataResourceItem
implements ResourceItem,
ResolvableResourceItem {
    private static final Logger LOG = Logger.getInstance(SampleDataResourceItem.class);
    private static final Cache<String, SampleDataHolder> sSampleDataCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).softValues().weigher((key, value2) -> value2.getFileSizeMb()).maximumWeight(50L).build();
    @NotNull
    private final SingleNamespaceResourceRepository myOwner;
    @NotNull
    private final String myName;
    @NotNull
    private final Function<OutputStream, Exception> myDataSource;
    @NotNull
    private final Supplier<Long> myDataSourceModificationStamp;
    @Nullable
    private final SmartPsiElementPointer<PsiElement> mySourceElement;
    @Nullable
    private ResourceValue myResourceValue;
    @NotNull
    private final ContentType myContentType;

    private SampleDataResourceItem(@NotNull SingleNamespaceResourceRepository owner, @NotNull String name, @NotNull Function<OutputStream, Exception> dataSource, @NotNull Supplier<Long> dataSourceModificationStamp, @Nullable SmartPsiElementPointer<PsiElement> sourceElement, @NotNull ContentType contentType) {
        this.myOwner = owner;
        this.myName = name;
        this.myDataSource = dataSource;
        this.myDataSourceModificationStamp = dataSourceModificationStamp;
        this.mySourceElement = sourceElement;
        this.myContentType = contentType;
    }

    public static void invalidateCache() {
        sSampleDataCache.invalidateAll();
    }

    @NotNull
    static SampleDataResourceItem getFromStaticDataSource(@NotNull SingleNamespaceResourceRepository repository, @NotNull String name, @NotNull Function<OutputStream, Exception> source, @NotNull ContentType contentType) {
        return new SampleDataResourceItem(repository, name, source, () -> 1L, null, contentType);
    }

    @NotNull
    private static SampleDataResourceItem getFromPlainFile(@NotNull SingleNamespaceResourceRepository repository, @NotNull SmartPsiElementPointer<PsiElement> filePointer) {
        VirtualFile vFile = filePointer.getVirtualFile();
        String fileName = vFile.getName();
        return new SampleDataResourceItem(repository, fileName, output -> {
            PsiElement sourceElement = filePointer.getElement();
            if (sourceElement == null) {
                LOG.warn("File pointer was invalidated and the repository was not refreshed");
                return null;
            }
            try {
                output.write(sourceElement.getText().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                LOG.warn("Unable to load content from plain file " + fileName, (Throwable)e);
                return e;
            }
            return null;
        }, () -> vFile.getModificationStamp() + 1L, filePointer, ContentType.UNKNOWN);
    }

    @NotNull
    private static SampleDataResourceItem getFromDirectory(@NotNull SingleNamespaceResourceRepository repository, @NotNull SmartPsiElementPointer<PsiElement> directoryPointer) {
        VirtualFile directory = directoryPointer.getVirtualFile();
        return new SampleDataResourceItem(repository, directory.getName(), output -> {
            try (PrintStream printStream = new PrintStream((OutputStream)output, false, StandardCharsets.UTF_8.name());){
                Arrays.stream(directory.getChildren()).filter(child -> !child.isDirectory()).sorted(Comparator.comparing(VirtualFile::getName)).forEach(file2 -> printStream.println(file2.getPath()));
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Throwable)e);
            }
            return null;
        }, () -> directory.getModificationStamp() + 1L, directoryPointer, ContentType.IMAGE);
    }

    @NotNull
    private static SampleDataResourceItem getFromJsonFile(@NotNull SingleNamespaceResourceRepository repository, @NotNull SmartPsiElementPointer<PsiElement> jsonPointer, @NotNull String contentPath) {
        VirtualFile vFile = jsonPointer.getVirtualFile();
        String fileName = vFile.getName();
        return new SampleDataResourceItem(repository, fileName + contentPath, output -> {
            if (contentPath.isEmpty()) {
                return null;
            }
            PsiElement source = jsonPointer.getElement();
            if (source == null) {
                LOG.warn("JSON file pointer was invalidated and the repository was not refreshed");
                return null;
            }
            try {
                StringReader input = new StringReader(source.getText());
                SampleDataJsonParser parser = SampleDataJsonParser.parse((Reader)input);
                if (parser != null) {
                    output.write(parser.getContentFromPath(contentPath));
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to load content from json file " + fileName, (Throwable)e);
                return e;
            }
            return null;
        }, () -> vFile.getModificationStamp() + 1L, jsonPointer, ContentType.UNKNOWN);
    }

    @NotNull
    private static String getTextFromPsiElementPointer(SmartPsiElementPointer<PsiElement> pointer) {
        PsiElement rootJsonElement = pointer.getElement();
        return rootJsonElement != null ? rootJsonElement.getText() : "";
    }

    @NotNull
    public static List<SampleDataResourceItem> getFromPsiFileSystemItem(@NotNull SingleNamespaceResourceRepository repository, @NotNull PsiFileSystemItem sampleDataSource) throws IOException {
        String extension = sampleDataSource.getVirtualFile().getExtension();
        if (extension == null) {
            extension = "";
        }
        SmartPsiElementPointer psiPointer = SmartPointerManager.getInstance((Project)sampleDataSource.getProject()).createSmartPsiElementPointer((PsiElement)sampleDataSource);
        switch (extension) {
            case "json": {
                SampleDataJsonParser parser;
                String jsonText = SampleDataResourceItem.getTextFromPsiElementPointer((SmartPsiElementPointer<PsiElement>)psiPointer);
                try (StringReader reader = new StringReader(jsonText);){
                    parser = SampleDataJsonParser.parse((Reader)reader);
                }
                if (parser == null) {
                    return Collections.emptyList();
                }
                Set possiblePaths = parser.getPossiblePaths();
                ImmutableList.Builder items2 = ImmutableList.builder();
                for (String path2 : possiblePaths) {
                    items2.add((Object)SampleDataResourceItem.getFromJsonFile(repository, (SmartPsiElementPointer<PsiElement>)psiPointer, path2));
                }
                return items2.build();
            }
            case "csv": {
                SampleDataCsvParser parser;
                String csvText = SampleDataResourceItem.getTextFromPsiElementPointer((SmartPsiElementPointer<PsiElement>)psiPointer);
                try (StringReader reader = new StringReader(csvText);){
                    parser = SampleDataCsvParser.parse((Reader)reader);
                }
                Set possiblePaths = parser.getPossiblePaths();
                items2 = ImmutableList.builder();
                for (String path3 : possiblePaths) {
                    items2.add(new SampleDataResourceItem(repository, sampleDataSource.getName() + path3, new HardcodedContent(Joiner.on((char)'\n').join((Iterable)parser.getPath(path3))), () -> psiPointer.getVirtualFile().getModificationStamp() + 1L, (SmartPsiElementPointer<PsiElement>)psiPointer, ContentType.UNKNOWN));
                }
                return items2.build();
            }
        }
        return ImmutableList.of((Object)(sampleDataSource instanceof PsiDirectory ? SampleDataResourceItem.getFromDirectory(repository, (SmartPsiElementPointer<PsiElement>)psiPointer) : SampleDataResourceItem.getFromPlainFile(repository, (SmartPsiElementPointer<PsiElement>)psiPointer)));
    }

    @Nullable
    private byte[] getContent(@Nullable Runnable onCachedOutOfDate) {
        SampleDataHolder value2 = (SampleDataHolder)sSampleDataCache.getIfPresent((Object)this.getName());
        if (value2 == null || value2.getLastModification() == 0L || value2.getLastModification() != this.myDataSourceModificationStamp.get().longValue()) {
            long lastModificationStamp = this.myDataSourceModificationStamp.get();
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                Exception e = this.myDataSource.apply(output);
                if (e == null) {
                    byte[] content2 = output.toByteArray();
                    value2 = new SampleDataHolder(this.getName(), lastModificationStamp, content2.length / 1000000, content2);
                    sSampleDataCache.put((Object)this.getName(), (Object)value2);
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            if (onCachedOutOfDate != null) {
                onCachedOutOfDate.run();
            }
        }
        return value2 != null ? value2.getContents() : null;
    }

    @Nullable
    public String getValueText() {
        byte[] content2 = this.getContent(null);
        return content2 != null ? new String(content2, StandardCharsets.UTF_8) : null;
    }

    @NotNull
    public SingleNamespaceResourceRepository getRepository() {
        return this.myOwner;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public ResourceType getType() {
        return ResourceType.SAMPLE_DATA;
    }

    @Nullable
    public String getLibraryName() {
        return null;
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        return this.myOwner.getNamespace();
    }

    @NotNull
    public ResourceReference getReferenceToSelf() {
        return new ResourceReference(this.getNamespace(), this.getType(), this.getName());
    }

    @NotNull
    public FolderConfiguration getConfiguration() {
        return DEFAULT_CONFIGURATION;
    }

    @NotNull
    public String getKey() {
        return this.getType() + "/" + this.getName();
    }

    @NotNull
    public ResourceValue getResourceValue() {
        byte[] content2 = this.getContent(() -> {
            this.myResourceValue = null;
        });
        if (this.myResourceValue == null) {
            this.myResourceValue = new SampleDataResourceValueImpl(this.getReferenceToSelf(), content2);
        }
        return this.myResourceValue;
    }

    @Nullable
    public PathString getSource() {
        return null;
    }

    public boolean isFileBased() {
        return false;
    }

    @Override
    @NotNull
    public ResolveResult createResolveResult() {
        return new ResolveResult(){

            @Nullable
            public PsiElement getElement() {
                return SampleDataResourceItem.this.mySourceElement != null ? SampleDataResourceItem.this.mySourceElement.getElement() : null;
            }

            public boolean isValidResult() {
                return true;
            }
        };
    }

    @NotNull
    public ContentType getContentType() {
        return this.myContentType;
    }

    public static enum ContentType {
        UNKNOWN,
        TEXT,
        IMAGE;

    }
}

