/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.FileResourceNameValidator;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.resources.ResourceVisibility;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.AbstractResourceRepositoryWithLocking;
import com.android.tools.idea.res.AndroidFileChangeListener;
import com.android.tools.idea.res.FileTimeStampLengthHasher;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.LoggingPsiTreeChangeListener;
import com.android.tools.idea.res.PsiResourceFile;
import com.android.tools.idea.res.PsiResourceItem;
import com.android.tools.idea.res.ResourceFolderRepositoryCachingData;
import com.android.tools.idea.res.ResourceItemSource;
import com.android.tools.idea.res.ResourceRepositoryImplUtil;
import com.android.tools.idea.res.VfsDensityBasedFileResourceItem;
import com.android.tools.idea.res.VfsFileResourceItem;
import com.android.tools.idea.res.VfsResourceFile;
import com.android.tools.idea.resources.base.Base128InputStream;
import com.android.tools.idea.resources.base.BasicDensityBasedFileResourceItem;
import com.android.tools.idea.resources.base.BasicFileResourceItem;
import com.android.tools.idea.resources.base.BasicResourceItem;
import com.android.tools.idea.resources.base.BasicValueResourceItemBase;
import com.android.tools.idea.resources.base.LoadableResourceRepository;
import com.android.tools.idea.resources.base.RepositoryConfiguration;
import com.android.tools.idea.resources.base.RepositoryLoader;
import com.android.tools.idea.resources.base.ResourceSerializationUtil;
import com.android.tools.idea.resources.base.ResourceSourceFile;
import com.android.tools.idea.util.FileExtensions;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiTreeAnyChangeAbstractAdapter;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.concurrency.EdtExecutorService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public final class ResourceFolderRepository
extends LocalResourceRepository
implements LoadableResourceRepository {
    static final String CACHE_FILE_FORMAT_VERSION = "2";
    private static final byte[] CACHE_FILE_HEADER = "Resource cache".getBytes(StandardCharsets.UTF_8);
    private static final double CACHE_STALENESS_THRESHOLD = 0.05;
    private static final Comparator<ResourceItemSource<? extends ResourceItem>> SOURCE_COMPARATOR = Comparator.comparing(ResourceItemSource::getFolderConfiguration);
    private static final Logger LOG = Logger.getInstance(ResourceFolderRepository.class);
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final PsiTreeChangeListener myPsiListener;
    @NotNull
    private final VirtualFile myResourceDir;
    @NotNull
    private final ResourceNamespace myNamespace;
    @NotNull
    private final String myResourcePathPrefix;
    @NotNull
    private final PathString myResourcePathBase;
    private int myNumXmlFilesLoadedInitially;
    private int myNumXmlFilesLoadedInitiallyFromSources;
    @NotNull
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> myResourceTable = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);
    @NotNull
    private final Map<VirtualFile, ResourceItemSource<? extends ResourceItem>> mySources = new HashMap<VirtualFile, ResourceItemSource<? extends ResourceItem>>();
    @NotNull
    private final PsiManager myPsiManager;
    @NotNull
    private final PsiNameHelper myPsiNameHelper;
    @NotNull
    private final WolfTheProblemSolver myWolfTheProblemSolver;
    @NotNull
    private final PsiDocumentManager myPsiDocumentManager;
    @NotNull
    private final Object scanLock = new Object();
    @NotNull
    private final Set<VirtualFile> myPendingScans = new HashSet<VirtualFile>();
    @VisibleForTesting
    static int ourFullRescans;
    @VisibleForTesting
    static int ourLayoutlibCacheFlushes;

    @NotNull
    static ResourceFolderRepository create(@NotNull AndroidFacet facet2, @NotNull VirtualFile dir, @NotNull ResourceNamespace namespace, @Nullable ResourceFolderRepositoryCachingData cachingData) {
        return new ResourceFolderRepository(facet2, dir, namespace, cachingData);
    }

    private ResourceFolderRepository(@NotNull AndroidFacet facet2, @NotNull VirtualFile resourceDir, @NotNull ResourceNamespace namespace, @Nullable ResourceFolderRepositoryCachingData cachingData) {
        super(resourceDir.getName());
        this.myFacet = facet2;
        this.myResourceDir = resourceDir;
        this.myNamespace = namespace;
        this.myResourcePathPrefix = RepositoryLoader.portableFileName(this.myResourceDir.getPath()) + '/';
        this.myResourcePathBase = new PathString(this.myResourcePathPrefix);
        this.myPsiManager = PsiManager.getInstance((Project)this.getProject());
        this.myPsiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        this.myPsiNameHelper = PsiNameHelper.getInstance((Project)this.getProject());
        this.myWolfTheProblemSolver = WolfTheProblemSolver.getInstance((Project)this.getProject());
        Object psiListener = (Boolean)StudioFlags.INCREMENTAL_RESOURCE_REPOSITORIES.get() != false ? new IncrementalUpdatePsiListener() : new SimplePsiListener();
        this.myPsiListener = LOG.isDebugEnabled() ? new LoggingPsiTreeChangeListener((PsiTreeChangeListener)psiListener, LOG) : psiListener;
        Loader loader = new Loader(this, cachingData);
        loader.load();
    }

    @NotNull
    public VirtualFile getResourceDir() {
        return this.myResourceDir;
    }

    @Override
    @Nullable
    public String getLibraryName() {
        return null;
    }

    @Override
    @NotNull
    public Path getOrigin() {
        return Paths.get(this.myResourceDir.getPath(), new String[0]);
    }

    @Override
    @NotNull
    public String getResourceUrl(@NotNull String relativeResourcePath) {
        return this.myResourcePathPrefix + relativeResourcePath;
    }

    @Override
    @NotNull
    public PathString getSourceFile(@NotNull String relativeResourcePath, boolean forFileResource) {
        return this.myResourcePathBase.resolve(relativeResourcePath);
    }

    @Nullable
    public String getPackageName() {
        return ResourceRepositoryImplUtil.getPackageName(this.myNamespace, this.myFacet);
    }

    @Override
    public boolean containsUserDefinedResources() {
        return true;
    }

    private static void addToResult(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull ResourceItem item) {
        result2.computeIfAbsent(item.getType(), t -> LinkedListMultimap.create()).put((Object)item.getName(), (Object)item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitToRepository(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> itemsByType) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            this.commitToRepositoryWithoutLock(itemsByType);
        }
    }

    private void commitToRepositoryWithoutLock(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> itemsByType) {
        for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : itemsByType.entrySet()) {
            this.getOrCreateMap(entry.getKey()).putAll((Multimap)entry.getValue());
        }
    }

    @VisibleForTesting
    boolean hasFreshFileCache() {
        return (double)this.myNumXmlFilesLoadedInitiallyFromSources <= (double)this.myNumXmlFilesLoadedInitially * 0.05;
    }

    int getNumXmlFilesLoadedInitially() {
        return this.myNumXmlFilesLoadedInitially;
    }

    int getNumXmlFilesLoadedInitiallyFromSources() {
        return this.myNumXmlFilesLoadedInitiallyFromSources;
    }

    @Nullable
    private PsiFile ensureValid(@NotNull PsiFile psiFile2) {
        if (psiFile2.isValid()) {
            return psiFile2;
        }
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        if (virtualFile != null && virtualFile.exists() && !this.getProject().isDisposed()) {
            return this.myPsiManager.findFile(virtualFile);
        }
        return null;
    }

    private void scanFileResourceFileAsPsi(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull ResourceFolderType folderType, @NotNull FolderConfiguration folderConfiguration, @NotNull ResourceType type, boolean idGenerating, @NotNull PsiFile file2) {
        String resourceName = SdkUtils.fileNameToResourceName((String)file2.getName());
        if (!this.checkResourceFilename(file2, folderType)) {
            return;
        }
        RepositoryConfiguration configuration = new RepositoryConfiguration(this, folderConfiguration);
        PsiResourceItem item = PsiResourceItem.forFile(resourceName, type, this, file2, false);
        if (idGenerating) {
            ArrayList<PsiResourceItem> items2 = new ArrayList<PsiResourceItem>();
            items2.add(item);
            ResourceFolderRepository.addToResult(result2, item);
            this.addIds(result2, items2, file2);
            PsiResourceFile resourceFile = new PsiResourceFile(file2, items2, folderType, configuration);
            this.mySources.put(file2.getVirtualFile(), resourceFile);
        } else {
            PsiResourceFile resourceFile = new PsiResourceFile(file2, Collections.singletonList(item), folderType, configuration);
            this.mySources.put(file2.getVirtualFile(), resourceFile);
            ResourceFolderRepository.addToResult(result2, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor2) {
        if (visitor2.shouldVisitNamespace(this.myNamespace)) {
            Object object = ITEM_MAP_LOCK;
            synchronized (object) {
                if (ResourceFolderRepository.acceptByResources(this.myResourceTable, (ResourceVisitor)visitor2) == ResourceVisitor.VisitResult.ABORT) {
                    return ResourceVisitor.VisitResult.ABORT;
                }
            }
        }
        return ResourceVisitor.VisitResult.CONTINUE;
    }

    @Override
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (!namespace.equals((Object)this.myNamespace)) {
            return null;
        }
        return this.myResourceTable.get(type);
    }

    @NotNull
    private ListMultimap<String, ResourceItem> getOrCreateMap(@NotNull ResourceType type) {
        LinkedListMultimap multimap = this.myResourceTable.get(type);
        if (multimap == null) {
            multimap = LinkedListMultimap.create();
            this.myResourceTable.put(type, (ListMultimap<String, ResourceItem>)multimap);
        }
        return multimap;
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        return this.myNamespace;
    }

    private void addIds(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull List<PsiResourceItem> items2, @NotNull PsiFile file2) {
        this.addIds(result2, items2, (PsiElement)file2, false);
    }

    private void addIds(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull List<PsiResourceItem> items2, @NotNull PsiElement element2, boolean calledFromPsiListener) {
        Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)element2, XmlTag.class);
        if (element2 instanceof XmlTag) {
            this.addIds(result2, items2, (XmlTag)element2, calledFromPsiListener);
        }
        if (!xmlTags.isEmpty()) {
            for (XmlTag tag : xmlTags) {
                this.addIds(result2, items2, tag, calledFromPsiListener);
            }
        }
    }

    private void addIds(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull List<PsiResourceItem> items2, @NotNull XmlTag tag, boolean calledFromPsiListener) {
        assert (tag.isValid());
        for (XmlAttribute attribute : tag.getAttributes()) {
            PsiResourceItem item = this.createIdFromAttribute(attribute, calledFromPsiListener);
            if (item == null) continue;
            items2.add(item);
            ResourceFolderRepository.addToResult(result2, item);
        }
    }

    @Nullable
    private PsiResourceItem createIdFromAttribute(XmlAttribute attribute, boolean calledFromPsiListener) {
        String id;
        PsiResourceItem item = null;
        String attributeValue = StringUtil.notNullize((String)attribute.getValue()).trim();
        if (attributeValue.startsWith("@+id/") && !attribute.getNamespace().equals("http://schemas.android.com/tools") && ResourceFolderRepository.isValidValueResourceName(id = attributeValue.substring("@+id/".length()))) {
            item = PsiResourceItem.forXmlTag(id, ResourceType.ID, this, attribute.getParent(), calledFromPsiListener);
        }
        return item;
    }

    private boolean scanValueFileAsPsi(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull PsiFile file2, @NotNull FolderConfiguration folderConfiguration) {
        boolean added = false;
        FileType fileType = file2.getFileType();
        if (fileType == XmlFileType.INSTANCE) {
            XmlFile xmlFile = (XmlFile)file2;
            assert (xmlFile.isValid());
            XmlDocument document = xmlFile.getDocument();
            if (document != null) {
                XmlTag root2 = document.getRootTag();
                if (root2 == null) {
                    return false;
                }
                if (!root2.getName().equals("resources")) {
                    return false;
                }
                XmlTag[] subTags = root2.getSubTags();
                ArrayList<PsiResourceItem> items2 = new ArrayList<PsiResourceItem>(subTags.length);
                for (XmlTag tag : subTags) {
                    XmlTag[] attrs;
                    String name = tag.getAttributeValue("name");
                    ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(tag);
                    if (type == null || !ResourceFolderRepository.isValidValueResourceName(name)) continue;
                    PsiResourceItem item = PsiResourceItem.forXmlTag(name, type, this, tag, false);
                    ResourceFolderRepository.addToResult(result2, item);
                    items2.add(item);
                    added = true;
                    if (type != ResourceType.STYLEABLE || (attrs = tag.getSubTags()).length <= 0) continue;
                    for (XmlTag child : attrs) {
                        String attrName = child.getAttributeValue("name");
                        if (!ResourceFolderRepository.isValidValueResourceName(attrName) || attrName.startsWith("android:") || child.getAttribute("format") == null && child.getSubTags().length <= 0) continue;
                        PsiResourceItem attrItem = PsiResourceItem.forXmlTag(attrName, ResourceType.ATTR, this, child, false);
                        items2.add(attrItem);
                        ResourceFolderRepository.addToResult(result2, attrItem);
                    }
                }
                PsiResourceFile resourceFile = new PsiResourceFile(file2, items2, ResourceFolderType.VALUES, new RepositoryConfiguration(this, folderConfiguration));
                this.mySources.put(file2.getVirtualFile(), resourceFile);
            }
        }
        return added;
    }

    @Contract(value="null -> false")
    private static boolean isValidValueResourceName(@Nullable String name) {
        return !StringUtil.isEmpty((String)name) && ValueResourceNameValidator.getErrorText((String)name, null) == null;
    }

    private boolean checkResourceFilename(@NotNull PathString file2, @NotNull ResourceFolderType folderType) {
        VirtualFile virtualFile;
        if (FileResourceNameValidator.getErrorTextForFileResource((String)file2.getFileName(), (ResourceFolderType)folderType) != null && (virtualFile = FileExtensions.toVirtualFile(file2)) != null) {
            this.myWolfTheProblemSolver.reportProblemsFromExternalSource(virtualFile, (Object)this);
        }
        return this.myPsiNameHelper.isIdentifier(SdkUtils.fileNameToResourceName((String)file2.getFileName()));
    }

    private boolean checkResourceFilename(@NotNull PsiFile file2, @NotNull ResourceFolderType folderType) {
        VirtualFile virtualFile;
        if (FileResourceNameValidator.getErrorTextForFileResource((String)file2.getName(), (ResourceFolderType)folderType) != null && (virtualFile = file2.getVirtualFile()) != null) {
            this.myWolfTheProblemSolver.reportProblemsFromExternalSource(virtualFile, (Object)this);
        }
        return this.myPsiNameHelper.isIdentifier(SdkUtils.fileNameToResourceName((String)file2.getName()));
    }

    private boolean convertToPsiIfNeeded(@NotNull PsiFile psiFile2, @NotNull ResourceFolderType folderType) {
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        ResourceItemSource<? extends ResourceItem> resFile = this.mySources.get(virtualFile);
        if (resFile instanceof PsiResourceFile) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Converting to PSI ", new Object[]{psiFile2});
        }
        this.scheduleScan(virtualFile, folderType);
        return true;
    }

    private boolean isResourceFolder(@NotNull VirtualFile virtualFile) {
        VirtualFile parentDirectory;
        if (virtualFile.isDirectory() && (parentDirectory = virtualFile.getParent()) != null) {
            return parentDirectory.equals(this.myResourceDir);
        }
        return false;
    }

    private boolean isResourceFile(@NotNull VirtualFile virtualFile) {
        VirtualFile parent = virtualFile.getParent();
        return parent != null && this.isResourceFolder(parent);
    }

    private boolean isResourceFile(@NotNull PsiFile psiFile2) {
        return this.isResourceFile(psiFile2.getVirtualFile());
    }

    @Override
    boolean isScanPending(@NotNull PsiFile psiFile2) {
        return this.isScanPending(psiFile2.getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isScanPending(@NotNull VirtualFile virtualFile) {
        Object object = this.scanLock;
        synchronized (object) {
            return this.myPendingScans.contains(virtualFile);
        }
    }

    void scheduleScan(@NotNull VirtualFile virtualFile) {
        ResourceFolderType folderType = IdeResourcesUtil.getFolderType(virtualFile);
        if (folderType != null) {
            this.scheduleScan(virtualFile, folderType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleScan(@NotNull VirtualFile virtualFile, @NotNull ResourceFolderType folderType) {
        Object object = this.scanLock;
        synchronized (object) {
            if (!this.myPendingScans.add(virtualFile)) {
                return;
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!virtualFile.isValid() || !this.isScanPending(virtualFile)) {
                return;
            }
            PsiFile psiFile2 = this.findPsiFile(virtualFile);
            if (psiFile2 == null) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (this.isScanPending(virtualFile)) {
                    this.scan(psiFile2, folderType);
                    Object object = this.scanLock;
                    synchronized (object) {
                        this.myPendingScans.remove(virtualFile);
                    }
                }
            });
        });
    }

    @Nullable
    private PsiFile findPsiFile(@NotNull VirtualFile virtualFile) {
        try {
            return PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile);
        }
        catch (AlreadyDisposedException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        ArrayList<VirtualFile> files2;
        super.sync();
        Object object = this.scanLock;
        synchronized (object) {
            if (this.myPendingScans.isEmpty()) {
                return;
            }
            files2 = new ArrayList<VirtualFile>(this.myPendingScans);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (VirtualFile virtualFile : files2) {
                PsiFile psiFile2;
                ResourceFolderType folderType;
                if (!virtualFile.isValid() || (folderType = IdeResourcesUtil.getFolderType(virtualFile)) == null || (psiFile2 = this.findPsiFile(virtualFile)) == null) continue;
                this.scan(psiFile2, folderType);
            }
        });
        object = this.scanLock;
        synchronized (object) {
            this.myPendingScans.clear();
        }
    }

    @Slow
    public void scanRecursively(@NotNull VirtualFileFilter filter2) {
        PsiManager manager = PsiManager.getInstance((Project)this.myFacet.getModule().getProject());
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)this.myResourceDir, (VirtualFileFilter)filter2, virtualFile -> {
            if (virtualFile.isDirectory()) {
                return true;
            }
            PsiFile psiFile2 = manager.findFile(virtualFile);
            assert (psiFile2 != null);
            ResourceFolderType type = IdeResourcesUtil.getFolderType(virtualFile);
            assert (type != null);
            this.scan(psiFile2, type);
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(@NotNull PsiFile psiFile2, @NotNull ResourceFolderType folderType) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            ApplicationManager.getApplication().runReadAction(() -> this.scan(psiFile2, folderType));
            return;
        }
        if (psiFile2.getProject().isDisposed()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rescanning ", new Object[]{psiFile2});
        }
        HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
        PsiFile file2 = psiFile2;
        if (folderType == ResourceFolderType.VALUES) {
            ++ourFullRescans;
            ResourceItemSource<? extends ResourceItem> source = this.mySources.remove(file2.getVirtualFile());
            boolean removed = false;
            if (source != null) {
                removed = this.removeItemsFromSource(source);
            }
            file2 = this.ensureValid(file2);
            boolean added = false;
            if (file2 != null) {
                FolderConfiguration folderConfiguration;
                PsiDirectory parent = file2.getParent();
                assert (parent != null);
                PsiDirectory fileParent = psiFile2.getParent();
                if (fileParent != null && (folderConfiguration = FolderConfiguration.getConfigForFolder((String)fileParent.getName())) != null) {
                    added = this.scanValueFileAsPsi(result2, file2, folderConfiguration);
                }
            }
            if (added || removed) {
                this.setModificationCount(ourModificationCounter.incrementAndGet());
                this.invalidateParentCaches(this, ResourceType.values());
            }
        } else if (this.checkResourceFilename(file2, folderType)) {
            ResourceItemSource<? extends ResourceItem> source = this.mySources.get(file2.getVirtualFile());
            if (source instanceof PsiResourceFile && file2.getFileType() == XmlFileType.INSTANCE) {
                PsiResourceFile psiResourceFile = (PsiResourceFile)source;
                if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType)) {
                    ++ourFullRescans;
                    HashSet<String> idsBefore = new HashSet<String>();
                    Object parent = ITEM_MAP_LOCK;
                    synchronized (parent) {
                        ListMultimap<String, ResourceItem> idMultimap = this.myResourceTable.get(ResourceType.ID);
                        if (idMultimap != null) {
                            ArrayList<PsiResourceItem> idItems = new ArrayList<PsiResourceItem>();
                            for (PsiResourceItem item : psiResourceFile) {
                                if (item.getType() != ResourceType.ID) continue;
                                idsBefore.add(item.getName());
                                idItems.add(item);
                            }
                            for (String id : idsBefore) {
                                List mapItems = idMultimap.get((Object)id);
                                if (mapItems == null || mapItems.isEmpty()) continue;
                                ArrayList<ResourceItem> toDelete = new ArrayList<ResourceItem>(mapItems.size());
                                for (ResourceItem mapItem : mapItems) {
                                    if (!(mapItem instanceof PsiResourceItem) || ((PsiResourceItem)mapItem).getSourceFile() != psiResourceFile) continue;
                                    toDelete.add(mapItem);
                                }
                                for (ResourceItem delete : toDelete) {
                                    idMultimap.remove((Object)delete.getName(), (Object)delete);
                                }
                            }
                            for (PsiResourceItem item : idItems) {
                                psiResourceFile.removeItem(item);
                            }
                        }
                    }
                    ArrayList<PsiResourceItem> idItems = new ArrayList<PsiResourceItem>();
                    file2 = this.ensureValid(file2);
                    if (file2 != null) {
                        this.addIds(result2, idItems, file2);
                    }
                    if (!idItems.isEmpty()) {
                        for (PsiResourceItem item : idItems) {
                            psiResourceFile.addItem(item);
                        }
                    }
                    this.setModificationCount(ourModificationCounter.incrementAndGet());
                    this.invalidateParentCaches(this, ResourceType.ID);
                }
            } else {
                if (source != null) {
                    this.removeItemsFromSource(source);
                }
                ++ourFullRescans;
                PsiDirectory parent = file2.getParent();
                assert (parent != null);
                ResourceType type = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)folderType);
                boolean idGeneratingFolder = FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
                this.clearLayoutlibCaches(file2.getVirtualFile(), folderType);
                file2 = this.ensureValid(file2);
                if (file2 != null) {
                    FolderConfiguration folderConfiguration;
                    PsiDirectory fileParent = psiFile2.getParent();
                    if (fileParent != null && (folderConfiguration = FolderConfiguration.getConfigForFolder((String)fileParent.getName())) != null) {
                        boolean idGeneratingFile = idGeneratingFolder && file2.getFileType() == XmlFileType.INSTANCE;
                        this.scanFileResourceFileAsPsi(result2, folderType, folderConfiguration, type, idGeneratingFile, file2);
                    }
                    this.setModificationCount(ourModificationCounter.incrementAndGet());
                    this.invalidateParentCaches(this, ResourceType.values());
                }
            }
        }
        this.commitToRepository(result2);
    }

    private void scan(@NotNull VirtualFile file2) {
        PsiFile psiFile2;
        ResourceFolderType folderType = IdeResourcesUtil.getFolderType(file2);
        if (folderType == null) {
            return;
        }
        if (this.isResourceFile(file2) && AndroidFileChangeListener.isRelevantFile(file2) && (psiFile2 = this.myPsiManager.findFile(file2)) != null) {
            Document document = this.myPsiDocumentManager.getDocument(psiFile2);
            if (document != null && this.myPsiDocumentManager.isUncommited(document)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Committing ", new Object[]{document});
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    WriteAction.run(() -> this.myPsiDocumentManager.commitDocument(document));
                    ReadAction.run(() -> this.scan(psiFile2, folderType));
                });
                return;
            }
            this.scan(psiFile2, folderType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeItemsForTag(@NotNull ResourceItemSource<PsiResourceItem> source, @NotNull XmlTag xmlTag, @NotNull ResourceType resourceType) {
        boolean changed = false;
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            Iterator sourceIter = source.iterator();
            while (sourceIter.hasNext()) {
                PsiResourceItem item = (PsiResourceItem)sourceIter.next();
                if (!item.wasTag(xmlTag)) continue;
                ListMultimap<String, ResourceItem> map2 = this.myResourceTable.get(resourceType);
                List items2 = map2.get((Object)item.getName());
                Iterator iter = items2.iterator();
                while (iter.hasNext()) {
                    ResourceItem candidate = (ResourceItem)iter.next();
                    if (candidate != item) continue;
                    iter.remove();
                    changed = true;
                    break;
                }
                sourceIter.remove();
            }
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeItemsFromSource(@NotNull ResourceItemSource<? extends ResourceItem> source) {
        boolean changed = false;
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (ResourceItem resourceItem : source) {
                ListMultimap<String, ResourceItem> map2 = this.myResourceTable.get(resourceItem.getType());
                List items2 = map2.get((Object)resourceItem.getName());
                Iterator iter = items2.iterator();
                while (iter.hasNext()) {
                    ResourceItem candidate = (ResourceItem)iter.next();
                    if (candidate != resourceItem) continue;
                    iter.remove();
                    changed = true;
                    break;
                }
                if (!items2.isEmpty()) continue;
                map2.removeAll((Object)resourceItem.getName());
            }
        }
        return changed;
    }

    private void getAndroidTargetDataThenRun(@NotNull VirtualFile file2, @NotNull Consumer<AndroidTargetData> consumer) {
        Module module2 = this.myFacet.getModule();
        ConfigurationManager configurationManager = ConfigurationManager.findExistingInstance(module2);
        if (configurationManager == null) {
            return;
        }
        CompletableFuture.supplyAsync(() -> {
            IAndroidTarget target = configurationManager.getConfiguration(file2).getTarget();
            if (target != null) {
                return AndroidTargetData.getTargetData(target, module2);
            }
            return null;
        }, PooledThreadExecutor.INSTANCE).thenAcceptAsync(target -> {
            if (target != null) {
                consumer.accept((AndroidTargetData)target);
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    private void bitmapUpdated(@NotNull VirtualFile bitmap) {
        Module module2 = this.myFacet.getModule();
        this.getAndroidTargetDataThenRun(bitmap, targetData -> targetData.clearLayoutBitmapCache(module2));
    }

    void clearFontCache(@NotNull VirtualFile virtualFile) {
        this.getAndroidTargetDataThenRun(virtualFile, targetData -> targetData.clearFontCache(virtualFile.getPath()));
    }

    @NotNull
    public PsiTreeChangeListener getPsiListener() {
        return this.myPsiListener;
    }

    void onFileCreated(@NotNull VirtualFile file2) {
        this.scheduleScan(file2);
    }

    @NotNull
    private Project getProject() {
        return this.myFacet.getModule().getProject();
    }

    void onFileOrDirectoryRemoved(@NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            Iterator<Map.Entry<VirtualFile, ResourceItemSource<? extends ResourceItem>>> iterator = this.mySources.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<VirtualFile, ResourceItemSource<? extends ResourceItem>> entry = iterator.next();
                iterator.remove();
                VirtualFile sourceFile = entry.getKey();
                if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)sourceFile, (boolean)true)) continue;
                ResourceItemSource<? extends ResourceItem> source = entry.getValue();
                this.onSourceRemoved(sourceFile, source);
            }
        } else {
            ResourceItemSource<? extends ResourceItem> source = this.mySources.remove(file2);
            if (source != null) {
                this.onSourceRemoved(file2, source);
            }
            this.myWolfTheProblemSolver.clearProblemsFromExternalSource(file2, (Object)this);
        }
    }

    private void onSourceRemoved(@NotNull VirtualFile file2, @NotNull ResourceItemSource<? extends ResourceItem> source) {
        ResourceFolderType folderType;
        LOG.debug("Removing file from repository ", new Object[]{file2});
        boolean removed = this.removeItemsFromSource(source);
        if (removed) {
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.invalidateParentCaches(this, ResourceType.values());
        }
        if ((folderType = IdeResourcesUtil.getFolderType(file2)) != null) {
            this.clearLayoutlibCaches(file2, folderType);
        }
    }

    private void clearLayoutlibCaches(@NotNull VirtualFile file2, @NotNull ResourceFolderType folderType) {
        if ("xml".equals(file2.getExtension())) {
            return;
        }
        if (folderType == ResourceFolderType.DRAWABLE) {
            ++ourLayoutlibCacheFlushes;
            this.bitmapUpdated(file2);
        } else if (folderType == ResourceFolderType.FONT) {
            ++ourLayoutlibCacheFlushes;
            this.clearFontCache(file2);
        }
    }

    private static boolean isItemElement(@NotNull XmlTag xmlTag) {
        String tag = xmlTag.getName();
        if (tag.equals("resources")) {
            return false;
        }
        return tag.equals("item") || ResourceType.fromXmlTagName((String)tag) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ResourceItem findValueResourceItem(@NotNull XmlTag tag, @NotNull PsiFile file2) {
        if (!tag.isValid()) {
            ResourceItemSource<? extends ResourceItem> resFile = this.mySources.get(file2.getVirtualFile());
            if (resFile != null) {
                assert (resFile instanceof PsiResourceFile);
                PsiResourceFile resourceFile = (PsiResourceFile)resFile;
                for (ResourceItem item : resourceFile) {
                    PsiResourceItem pri = (PsiResourceItem)item;
                    if (!pri.wasTag(tag)) continue;
                    return item;
                }
            }
            return null;
        }
        String name = tag.getAttributeValue("name");
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return name != null ? this.findValueResourceItem(tag, file2, name) : null;
        }
    }

    @Nullable
    private ResourceItem findValueResourceItem(@NotNull XmlTag tag, @NotNull PsiFile file2, @NotNull String name) {
        ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(tag);
        return this.findResourceItem(type, file2, name, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ResourceItem findResourceItem(@Nullable ResourceType type, @NotNull PsiFile file2, @Nullable String name, @Nullable XmlTag tag) {
        if (type == null || name == null) {
            return null;
        }
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file2.getVirtualFile());
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map2 = this.myResourceTable.get(type);
            if (map2 == null) {
                return null;
            }
            List items2 = map2.get((Object)name);
            assert (items2 != null);
            if (tag != null) {
                for (ResourceItem resourceItem : items2) {
                    PsiResourceItem psiResourceItem;
                    if (!(resourceItem instanceof PsiResourceItem) || !(psiResourceItem = (PsiResourceItem)resourceItem).wasTag(tag)) continue;
                    return resourceItem;
                }
            } else {
                for (ResourceItem item : items2) {
                    if (item instanceof PsiResourceItem) {
                        if (!Objects.equals(((PsiResourceItem)item).getPsiFile(), file2)) continue;
                        return item;
                    }
                    ResourceFile resourceFile = (ResourceFile)((ResourceMergerItem)item).getSourceFile();
                    if (resourceFile == null || !FileUtil.filesEqual((File)resourceFile.getFile(), (File)ioFile)) continue;
                    return item;
                }
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.myResourceDir + ": @" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        return Collections.singleton(this.myResourceDir);
    }

    @Override
    @NotNull
    public VfsResourceFile deserializeResourceSourceFile(@NotNull Base128InputStream stream, @NotNull List<RepositoryConfiguration> configurations) throws IOException {
        String relativePath = stream.readString();
        if (relativePath == null) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        int configIndex = stream.readInt();
        RepositoryConfiguration configuration = configurations.get(configIndex);
        VirtualFile virtualFile = ((ResourceFolderRepository)configuration.getRepository()).getResourceDir().findFileByRelativePath(relativePath);
        if (!stream.validateContents(FileTimeStampLengthHasher.hash(virtualFile))) {
            virtualFile = null;
        }
        return new VfsResourceFile(virtualFile, configuration);
    }

    @Override
    @NotNull
    public BasicFileResourceItem deserializeFileResourceItem(@NotNull Base128InputStream stream, @NotNull ResourceType resourceType, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull List<RepositoryConfiguration> configurations) throws IOException {
        Density density;
        String relativePath = stream.readString();
        if (relativePath == null) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        int configIndex = stream.readInt();
        RepositoryConfiguration configuration = configurations.get(configIndex);
        int encodedDensity = stream.readInt();
        VirtualFile virtualFile = ((ResourceFolderRepository)configuration.getRepository()).getResourceDir().findFileByRelativePath(relativePath);
        boolean idGenerating = false;
        String folderName = new PathString(relativePath).getParentFileName();
        if (folderName != null) {
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folderName);
            boolean bl = idGenerating = folderType != null && FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
        }
        if (idGenerating) {
            if (!stream.validateContents(FileTimeStampLengthHasher.hash(virtualFile))) {
                virtualFile = null;
            }
            if (encodedDensity == 0) {
                return new VfsFileResourceItem(resourceType, name, configuration, visibility, relativePath, virtualFile);
            }
            density = Density.values()[encodedDensity - 1];
            return new VfsDensityBasedFileResourceItem(resourceType, name, configuration, visibility, relativePath, virtualFile, density);
        }
        if (encodedDensity == 0) {
            return new BasicFileResourceItem(resourceType, name, configuration, visibility, relativePath);
        }
        density = Density.values()[encodedDensity - 1];
        return new BasicDensityBasedFileResourceItem(resourceType, name, configuration, visibility, relativePath, density);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invalidateParentCaches() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            super.invalidateParentCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invalidateParentCaches(@NotNull SingleNamespaceResourceRepository repository, ResourceType ... types2) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            super.invalidateParentCaches(repository, types2);
        }
    }

    private static class ParsingException
    extends RuntimeException {
        ParsingException(Throwable cause) {
            super(cause);
        }
    }

    private static class Loader
    extends RepositoryLoader<ResourceFolderRepository> {
        @NotNull
        private final ResourceFolderRepository myRepository;
        @NotNull
        private final VirtualFile myResourceDir;
        @NotNull
        private final PsiManager myPsiManager;
        @Nullable
        private final ResourceFolderRepositoryCachingData myCachingData;
        @NotNull
        private final Map<ResourceType, ListMultimap<String, ResourceItem>> myResources = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);
        @NotNull
        private final Map<VirtualFile, ResourceItemSource<BasicResourceItem>> mySources = new HashMap<VirtualFile, ResourceItemSource<BasicResourceItem>>();
        @NotNull
        private final Map<VirtualFile, BasicFileResourceItem> myFileResources = new HashMap<VirtualFile, BasicFileResourceItem>();
        @Nullable
        private VirtualFile myLastVirtualFile;
        @Nullable
        private PathString myLastPathString;
        @NotNull
        Set<VirtualFile> myFilesToReparseAsPsi = new HashSet<VirtualFile>();
        private final FileDocumentManager myFileDocumentManager;

        Loader(@NotNull ResourceFolderRepository repository, @Nullable ResourceFolderRepositoryCachingData cachingData) {
            super(VfsUtilCore.virtualToIoFile((VirtualFile)repository.myResourceDir).toPath(), null, repository.getNamespace());
            this.myRepository = repository;
            this.myResourceDir = repository.myResourceDir;
            this.myPsiManager = repository.myPsiManager;
            this.myCachingData = cachingData;
            this.myDefaultVisibility = ResourceVisibility.UNDEFINED;
            this.myFileDocumentManager = FileDocumentManager.getInstance();
        }

        public void load() {
            Executor executor;
            if (!this.myResourceDir.isValid()) {
                return;
            }
            this.loadFromPersistentCache();
            ApplicationManager.getApplication().runReadAction(this::getPsiDirsForListener);
            this.scanResFolder();
            this.populateRepository();
            ApplicationManager.getApplication().runReadAction(() -> this.scanQueuedPsiResources());
            if (this.myCachingData != null && !this.myRepository.hasFreshFileCache() && (executor = this.myCachingData.getCacheCreationExecutor()) != null) {
                executor.execute(this::createCacheFile);
            }
        }

        private void loadFromPersistentCache() {
            if (this.myCachingData == null) {
                return;
            }
            byte[] fileHeader = this.getCacheFileHeader(this.myCachingData);
            try (Base128InputStream stream2 = new Base128InputStream(this.myCachingData.getCacheFile());){
                if (!stream2.validateContents(fileHeader)) {
                    return;
                }
                ResourceSerializationUtil.readResourcesFromStream(stream2, Maps.newHashMapWithExpectedSize((int)1000), null, this.myRepository, item -> this.addResourceItem((BasicResourceItem)item, this.myRepository));
            }
            catch (NoSuchFileException stream2) {
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                this.mySources.clear();
                this.myFileResources.clear();
                LOG.warn("Failed to load resources from cache file " + this.myCachingData.getCacheFile().toString(), e);
            }
        }

        @NotNull
        protected byte[] getCacheFileHeader(@NotNull ResourceFolderRepositoryCachingData cachingData) {
            return ResourceSerializationUtil.getCacheFileHeader(stream -> {
                stream.write(CACHE_FILE_HEADER);
                stream.writeString(ResourceFolderRepository.CACHE_FILE_FORMAT_VERSION);
                stream.writeString(this.myResourceDir.getPath());
                stream.writeString(cachingData.getCodeVersion());
            });
        }

        private void createCacheFile() {
            assert (this.myCachingData != null);
            byte[] header = this.getCacheFileHeader(this.myCachingData);
            try {
                ResourceSerializationUtil.createPersistentCache(this.myCachingData.getCacheFile(), header, stream -> ResourceSerializationUtil.writeResourcesToStream(this.myResources, stream, config -> true));
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void scanResFolder() {
            try {
                void var3_8;
                VirtualFile[] virtualFileArray = this.myResourceDir.getChildren();
                int n = virtualFileArray.length;
                boolean bl = false;
                while (var3_8 < n) {
                    String folderName;
                    RepositoryLoader.FolderInfo folderInfo;
                    VirtualFile subDir = virtualFileArray[var3_8];
                    if (subDir.isValid() && subDir.isDirectory() && (folderInfo = RepositoryLoader.FolderInfo.create(folderName = subDir.getName(), this.myFolderConfigCache)) != null) {
                        RepositoryConfiguration configuration = this.getConfiguration(this.myRepository, folderInfo.configuration);
                        for (VirtualFile file3 : subDir.getChildren()) {
                            if (file3.getName().startsWith(".")) continue;
                            if (this.myFileDocumentManager.isFileModified(file3)) {
                                this.myFilesToReparseAsPsi.add(file3);
                                continue;
                            }
                            if (folderInfo.folderType == ResourceFolderType.VALUES ? this.mySources.containsKey(file3) : this.myFileResources.containsKey(file3)) {
                                if (!Loader.isParsableFile(file3, folderInfo)) continue;
                                this.countCacheHit();
                                continue;
                            }
                            PathString pathString = FileExtensions.toPathString(file3);
                            this.myLastVirtualFile = file3;
                            this.myLastPathString = pathString;
                            try {
                                this.loadResourceFile(pathString, folderInfo, configuration);
                                if (!Loader.isParsableFile(file3, folderInfo)) continue;
                                this.countCacheMiss();
                            }
                            catch (ParsingException e) {
                                this.myFilesToReparseAsPsi.add(file3);
                            }
                        }
                    }
                    ++var3_8;
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Failed to load resources from " + this.myResourceDirectoryOrFile.toString(), (Throwable)e);
            }
            super.finishLoading(this.myRepository);
            for (Map.Entry<VirtualFile, BasicFileResourceItem> entry : this.myFileResources.entrySet()) {
                VirtualFile virtualFile = entry.getKey();
                BasicFileResourceItem item = entry.getValue();
                ResourceItemSource source = this.mySources.computeIfAbsent(virtualFile, file2 -> new VfsResourceFile((VirtualFile)file2, item.getRepositoryConfiguration()));
                source.addItem(item);
            }
            ArrayList<ResourceItemSource<BasicResourceItem>> sortedSources = new ArrayList<ResourceItemSource<BasicResourceItem>>(this.mySources.values());
            sortedSources.sort(SOURCE_COMPARATOR);
            for (ResourceItemSource resourceItemSource : sortedSources) {
                for (ResourceItem item : resourceItemSource) {
                    this.getOrCreateMap(item.getType()).put((Object)item.getName(), (Object)item);
                }
            }
        }

        private void loadResourceFile(@NotNull PathString file2, @NotNull RepositoryLoader.FolderInfo folderInfo, @NotNull RepositoryConfiguration configuration) {
            if (folderInfo.resourceType == null) {
                if (Loader.isXmlFile(file2)) {
                    this.parseValueResourceFile(file2, configuration);
                }
            } else if (this.myRepository.checkResourceFilename(file2, folderInfo.folderType)) {
                if (Loader.isXmlFile(file2) && folderInfo.isIdGenerating) {
                    this.parseIdGeneratingResourceFile(file2, configuration);
                }
                BasicFileResourceItem item = this.createFileResourceItem(file2, folderInfo.resourceType, configuration, folderInfo.isIdGenerating);
                this.addResourceItem((BasicResourceItem)item, (ResourceFolderRepository)item.getRepository());
            }
        }

        private static boolean isParsableFile(@NotNull VirtualFile file2, @NotNull RepositoryLoader.FolderInfo folderInfo) {
            return (folderInfo.folderType == ResourceFolderType.VALUES || folderInfo.isIdGenerating) && Loader.isXmlFile(file2.getName());
        }

        private void populateRepository() {
            this.myRepository.mySources.putAll(this.mySources);
            this.myRepository.commitToRepositoryWithoutLock(this.myResources);
        }

        @NotNull
        private ListMultimap<String, ResourceItem> getOrCreateMap(@NotNull ResourceType resourceType) {
            return this.myResources.computeIfAbsent(resourceType, type -> LinkedListMultimap.create());
        }

        @Override
        @NotNull
        protected InputStream getInputStream(@NotNull PathString file2) throws IOException {
            VirtualFile virtualFile = this.getVirtualFile(file2);
            if (virtualFile == null) {
                throw new NoSuchFileException(file2.getNativePath());
            }
            return virtualFile.getInputStream();
        }

        @Nullable
        private VirtualFile getVirtualFile(@NotNull PathString file2) {
            return file2.equals((Object)this.myLastPathString) ? this.myLastVirtualFile : FileExtensions.toVirtualFile(file2);
        }

        private void getPsiDirsForListener() {
            PsiDirectory resourceDirPsi = this.myPsiManager.findDirectory(this.myResourceDir);
            if (resourceDirPsi != null) {
                resourceDirPsi.getSubdirectories();
            }
        }

        @Override
        protected void addResourceItem(@NotNull BasicResourceItem item, @NotNull ResourceFolderRepository repository) {
            if (item instanceof BasicValueResourceItemBase) {
                VfsResourceFile sourceFile = (VfsResourceFile)((BasicValueResourceItemBase)item).getSourceFile();
                VirtualFile virtualFile = sourceFile.getVirtualFile();
                if (virtualFile != null && virtualFile.isValid() && !virtualFile.isDirectory()) {
                    sourceFile.addItem(item);
                    this.mySources.put(virtualFile, sourceFile);
                }
            } else if (item instanceof VfsFileResourceItem) {
                VfsFileResourceItem fileResourceItem = (VfsFileResourceItem)item;
                VirtualFile virtualFile = fileResourceItem.getVirtualFile();
                if (virtualFile != null && virtualFile.isValid() && !virtualFile.isDirectory()) {
                    this.myFileResources.put(virtualFile, fileResourceItem);
                }
            } else if (item instanceof BasicFileResourceItem) {
                BasicFileResourceItem fileResourceItem = (BasicFileResourceItem)item;
                VirtualFile virtualFile = this.getVirtualFile(fileResourceItem.getSource());
                if (virtualFile != null && virtualFile.isValid() && !virtualFile.isDirectory()) {
                    this.myFileResources.put(virtualFile, fileResourceItem);
                }
            } else {
                throw new IllegalArgumentException("Unexpected type: " + item.getClass().getName());
            }
        }

        @NotNull
        private BasicFileResourceItem createFileResourceItem(@NotNull PathString file2, @NotNull ResourceType resourceType, @NotNull RepositoryConfiguration configuration, boolean idGenerating) {
            DensityQualifier densityQualifier;
            String resourceName = SdkUtils.fileNameToResourceName((String)file2.getFileName());
            ResourceVisibility visibility = this.getVisibility(resourceType, resourceName);
            Density density = null;
            if (DensityBasedResourceValue.isDensityBasedResourceType((ResourceType)resourceType) && (densityQualifier = configuration.getFolderConfiguration().getDensityQualifier()) != null) {
                density = densityQualifier.getValue();
            }
            return this.createFileResourceItem(file2, resourceType, resourceName, configuration, visibility, density, idGenerating);
        }

        @Override
        @NotNull
        protected ResourceSourceFile createResourceSourceFile(@NotNull PathString file2, @NotNull RepositoryConfiguration configuration) {
            VirtualFile virtualFile = this.getVirtualFile(file2);
            return new VfsResourceFile(virtualFile, configuration);
        }

        @NotNull
        private BasicFileResourceItem createFileResourceItem(@NotNull PathString file2, @NotNull ResourceType type, @NotNull String name, @NotNull RepositoryConfiguration configuration, @NotNull ResourceVisibility visibility, @Nullable Density density, boolean idGenerating) {
            if (!idGenerating) {
                return super.createFileResourceItem(file2, type, name, configuration, visibility, density);
            }
            VirtualFile virtualFile = this.getVirtualFile(file2);
            String relativePath = this.getResRelativePath(file2);
            return density == null ? new VfsFileResourceItem(type, name, configuration, visibility, relativePath, virtualFile) : new VfsDensityBasedFileResourceItem(type, name, configuration, visibility, relativePath, virtualFile, density);
        }

        @Override
        protected void handleParsingError(@NotNull PathString file2, @NotNull Exception e) {
            throw new ParsingException(e);
        }

        private void scanQueuedPsiResources() {
            for (VirtualFile file2 : this.myFilesToReparseAsPsi) {
                this.myRepository.scan(file2);
            }
        }

        private void countCacheHit() {
            ++this.myRepository.myNumXmlFilesLoadedInitially;
        }

        private void countCacheMiss() {
            ++this.myRepository.myNumXmlFilesLoadedInitially;
            ++this.myRepository.myNumXmlFilesLoadedInitiallyFromSources;
        }
    }

    private final class IncrementalUpdatePsiListener
    extends PsiTreeChangeAdapter {
        private boolean myIgnoreChildrenChanged;

        private IncrementalUpdatePsiListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile2 = event.getFile();
            if (psiFile2 != null && AndroidFileChangeListener.isRelevantFile(psiFile2)) {
                VirtualFile virtualFile = psiFile2.getVirtualFile();
                if (ResourceFolderRepository.this.isScanPending(virtualFile)) {
                    return;
                }
                ResourceFolderType folderType = IdeResourcesUtil.getFolderType(psiFile2);
                if (folderType != null && ResourceFolderRepository.this.isResourceFile(psiFile2)) {
                    PsiElement child = event.getChild();
                    PsiElement parent = event.getParent();
                    if (folderType == ResourceFolderType.VALUES) {
                        if (child instanceof XmlTag) {
                            XmlTag parentTag;
                            XmlTag tag = (XmlTag)child;
                            if (ResourceFolderRepository.isItemElement(tag)) {
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                    return;
                                }
                                ResourceItemSource source = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(virtualFile);
                                if (source != null) {
                                    assert (source instanceof PsiResourceFile);
                                    PsiResourceFile psiResourceFile = (PsiResourceFile)source;
                                    String name = tag.getAttributeValue("name");
                                    if (ResourceFolderRepository.isValidValueResourceName(name)) {
                                        ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(tag);
                                        if (type == ResourceType.STYLEABLE) {
                                            ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                                            return;
                                        }
                                        if (type != null) {
                                            PsiResourceItem item = PsiResourceItem.forXmlTag(name, type, ResourceFolderRepository.this, tag, true);
                                            Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                            synchronized (object) {
                                                ResourceFolderRepository.this.getOrCreateMap(type).put((Object)name, (Object)item);
                                                psiResourceFile.addItem(item);
                                                ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this, type);
                                                return;
                                            }
                                        }
                                    }
                                }
                            }
                            if ((parentTag = tag.getParentTag()) != null && IdeResourcesUtil.getResourceTypeForResourceTag(parentTag) != null) {
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                    return;
                                }
                                ResourceItem parentItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile2);
                                if (parentItem instanceof PsiResourceItem) {
                                    if (((PsiResourceItem)parentItem).recomputeValue()) {
                                        ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                    }
                                    return;
                                }
                            }
                            ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                        } else {
                            if (parent instanceof XmlText) {
                                XmlText text2 = (XmlText)parent;
                                this.handleValueXmlTextEdit((PsiElement)text2.getParentTag(), psiFile2);
                                return;
                            }
                            if (child instanceof XmlText) {
                                this.handleValueXmlTextEdit(parent, psiFile2);
                                return;
                            }
                            if (parent instanceof XmlComment || child instanceof XmlComment) {
                                return;
                            }
                        }
                        ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                    } else if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile2.getFileType() == XmlFileType.INSTANCE) {
                        if (parent instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        if (parent instanceof XmlText || child instanceof XmlText && child.getText().trim().isEmpty()) {
                            return;
                        }
                        if (parent instanceof XmlElement && child instanceof XmlElement) {
                            XmlAttribute attribute;
                            PsiResourceItem newIdResource;
                            if (child instanceof XmlTag) {
                                ResourceItemSource resFile;
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                    return;
                                }
                                ArrayList ids2 = new ArrayList();
                                HashMap result2 = new HashMap();
                                ResourceFolderRepository.this.addIds((Map<ResourceType, ListMultimap<String, ResourceItem>>)result2, (List<PsiResourceItem>)ids2, child, true);
                                ResourceFolderRepository.this.commitToRepository(result2);
                                if (!ids2.isEmpty() && (resFile = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(psiFile2.getVirtualFile())) != null) {
                                    assert (resFile instanceof PsiResourceFile);
                                    PsiResourceFile psiResourceFile = (PsiResourceFile)resFile;
                                    for (PsiResourceItem id : ids2) {
                                        psiResourceFile.addItem(id);
                                    }
                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                    ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this, ResourceType.ID);
                                }
                                return;
                            }
                            if ((child instanceof XmlAttribute || parent instanceof XmlAttribute) && (newIdResource = ResourceFolderRepository.this.createIdFromAttribute(attribute = parent instanceof XmlAttribute ? (XmlAttribute)parent : (XmlAttribute)child, true)) != null) {
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                    return;
                                }
                                Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                synchronized (object) {
                                    ResourceItemSource resFile = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(psiFile2.getVirtualFile());
                                    if (resFile != null) {
                                        assert (resFile instanceof PsiResourceFile);
                                        PsiResourceFile psiResourceFile = (PsiResourceFile)resFile;
                                        psiResourceFile.addItem(newIdResource);
                                        ResourceFolderRepository.this.getOrCreateMap(ResourceType.ID).put((Object)newIdResource.getName(), (Object)newIdResource);
                                        ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                        ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this, ResourceType.ID);
                                        return;
                                    }
                                }
                            }
                        }
                    } else if (folderType == ResourceFolderType.FONT) {
                        ResourceFolderRepository.this.clearFontCache(psiFile2.getVirtualFile());
                    }
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            block24: {
                ResourceFolderType folderType;
                VirtualFile virtualFile;
                PsiFile psiFile2;
                block25: {
                    PsiElement parent;
                    PsiElement child;
                    block26: {
                        XmlTag parentTag;
                        psiFile2 = event.getFile();
                        if (psiFile2 == null || !AndroidFileChangeListener.isRelevantFile(psiFile2)) break block24;
                        virtualFile = psiFile2.getVirtualFile();
                        if (ResourceFolderRepository.this.isScanPending(virtualFile)) {
                            return;
                        }
                        folderType = IdeResourcesUtil.getFolderType(virtualFile);
                        if (folderType == null || !ResourceFolderRepository.this.isResourceFile(virtualFile)) break block24;
                        child = event.getChild();
                        parent = event.getParent();
                        if (folderType != ResourceFolderType.VALUES) break block25;
                        if (!(child instanceof XmlTag)) break block26;
                        XmlTag tag = (XmlTag)child;
                        if (parent instanceof XmlTag && IdeResourcesUtil.getResourceTypeForResourceTag(parentTag = (XmlTag)parent) != null) {
                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                return;
                            }
                            ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile2);
                            if (resourceItem instanceof PsiResourceItem) {
                                ResourceItem declareStyleable;
                                if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                }
                                if (resourceItem.getType() == ResourceType.ATTR && (parentTag = parentTag.getParentTag()) != null && IdeResourcesUtil.getResourceTypeForResourceTag(parentTag) == ResourceType.STYLEABLE && (declareStyleable = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile2)) instanceof PsiResourceItem && ((PsiResourceItem)declareStyleable).recomputeValue()) {
                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                }
                                return;
                            }
                        }
                        if (ResourceFolderRepository.isItemElement(tag)) {
                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                return;
                            }
                            ResourceItemSource source = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(virtualFile);
                            if (source != null) {
                                ResourceType type;
                                String name;
                                PsiResourceFile resourceFile = (PsiResourceFile)source;
                                if (!tag.isValid()) {
                                    ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(tag, psiFile2);
                                    if (item == null) {
                                        ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                                        return;
                                    }
                                    name = item.getName();
                                } else {
                                    name = tag.getAttributeValue("name");
                                }
                                if (name != null && (type = IdeResourcesUtil.getResourceTypeForResourceTag(tag)) != null) {
                                    Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                    synchronized (object) {
                                        boolean removed = ResourceFolderRepository.this.removeItemsForTag(resourceFile, tag, type);
                                        if (removed) {
                                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                            ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this, type);
                                        }
                                    }
                                }
                                return;
                            }
                        }
                        ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                        break block24;
                    }
                    if (parent instanceof XmlText) {
                        XmlText text2 = (XmlText)parent;
                        this.handleValueXmlTextEdit((PsiElement)text2.getParentTag(), psiFile2);
                        break block24;
                    } else if (child instanceof XmlText) {
                        this.handleValueXmlTextEdit(parent, psiFile2);
                        break block24;
                    } else {
                        if (parent instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                    }
                    break block24;
                }
                if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile2.getFileType() == XmlFileType.INSTANCE) {
                    ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                } else if (folderType == ResourceFolderType.FONT) {
                    ResourceFolderRepository.this.clearFontCache(virtualFile);
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile2 = event.getFile();
            if (psiFile2 != null) {
                VirtualFile virtualFile = psiFile2.getVirtualFile();
                if (ResourceFolderRepository.this.isScanPending(virtualFile)) {
                    return;
                }
                if (AndroidFileChangeListener.isRelevantFile(virtualFile)) {
                    PsiElement parent;
                    ResourceFolderType folderType = IdeResourcesUtil.getFolderType(virtualFile);
                    if (folderType != null && FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile2.getFileType() == XmlFileType.INSTANCE) {
                        PsiElement parent2 = event.getParent();
                        PsiElement child = event.getChild();
                        if (parent2 instanceof XmlText || child instanceof XmlText || parent2 instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        if (parent2 instanceof XmlElement && child instanceof XmlElement) {
                            if (event.getOldChild() == event.getNewChild()) {
                                ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                                return;
                            }
                            if (child instanceof XmlAttributeValue) {
                                assert (parent2 instanceof XmlAttribute) : parent2;
                                XmlAttribute attribute = (XmlAttribute)parent2;
                                PsiElement oldChild = event.getOldChild();
                                PsiElement newChild = event.getNewChild();
                                if (oldChild instanceof XmlAttributeValue && newChild instanceof XmlAttributeValue) {
                                    String oldText = ((XmlAttributeValue)oldChild).getValue().trim();
                                    String newText = ((XmlAttributeValue)newChild).getValue().trim();
                                    if (oldText.startsWith("@+id/") || newText.startsWith("@+id/")) {
                                        ResourceItemSource source = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(psiFile2.getVirtualFile());
                                        if (source != null) {
                                            ResourceUrl newResourceUrl;
                                            ResourceUrl oldResourceUrl = ResourceUrl.parse((String)oldText);
                                            if (Objects.equals(oldResourceUrl, newResourceUrl = ResourceUrl.parse((String)newText))) {
                                                return;
                                            }
                                            if (this.handleIdsChange(source, attribute.getParent())) {
                                                return;
                                            }
                                        }
                                        ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                                        return;
                                    }
                                }
                            } else if (parent2 instanceof XmlAttributeValue) {
                                PsiElement grandParent = parent2.getParent();
                                if (grandParent instanceof XmlProcessingInstruction) {
                                    return;
                                }
                                assert (grandParent instanceof XmlAttribute) : parent2;
                                XmlAttribute attribute = (XmlAttribute)grandParent;
                                XmlTag xmlTag = attribute.getParent();
                                String oldText = StringUtil.notNullize((String)event.getOldChild().getText()).trim();
                                String newText = StringUtil.notNullize((String)event.getNewChild().getText()).trim();
                                if (oldText.startsWith("@+id/") || newText.startsWith("@+id/")) {
                                    ResourceItemSource resFile = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(psiFile2.getVirtualFile());
                                    if (resFile != null) {
                                        ResourceUrl newResourceUrl;
                                        ResourceUrl oldResourceUrl = ResourceUrl.parse((String)oldText);
                                        if (Objects.equals(oldResourceUrl, newResourceUrl = ResourceUrl.parse((String)newText))) {
                                            return;
                                        }
                                        if (this.handleIdsChange(resFile, xmlTag)) {
                                            return;
                                        }
                                    }
                                    ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                                    return;
                                }
                            }
                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                            return;
                        }
                        ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                    } else if (folderType == ResourceFolderType.VALUES) {
                        PsiElement parent3 = event.getParent();
                        if (parent3 instanceof XmlElement) {
                            if (parent3 instanceof XmlComment) {
                                return;
                            }
                            if (parent3 instanceof XmlTag) {
                                XmlTag parentTag = (XmlTag)parent3;
                                if (IdeResourcesUtil.getResourceTypeForResourceTag(parentTag) != null) {
                                    if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                        return;
                                    }
                                    ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile2);
                                    if (resourceItem instanceof PsiResourceItem) {
                                        if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                        }
                                        return;
                                    }
                                }
                                if (parentTag.getName().equals("resources") && event.getOldChild() instanceof XmlText && event.getNewChild() instanceof XmlText) {
                                    return;
                                }
                            }
                            if (parent3 instanceof XmlText) {
                                XmlText text2 = (XmlText)parent3;
                                this.handleValueXmlTextEdit((PsiElement)text2.getParentTag(), psiFile2);
                                return;
                            }
                            if (parent3 instanceof XmlAttributeValue) {
                                PsiElement attribute = parent3.getParent();
                                if (attribute instanceof XmlProcessingInstruction) {
                                    return;
                                }
                                PsiElement tag = attribute.getParent();
                                assert (attribute instanceof XmlAttribute) : attribute;
                                XmlAttribute xmlAttribute = (XmlAttribute)attribute;
                                assert (tag instanceof XmlTag) : tag;
                                XmlTag xmlTag = (XmlTag)tag;
                                String attributeName = xmlAttribute.getName();
                                if (ResourceFolderRepository.isItemElement(xmlTag) && attributeName.equals("name")) {
                                    ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(xmlTag);
                                    if (type != null) {
                                        String newName2;
                                        String oldName = event.getOldChild().getText();
                                        if (oldName.equals(newName2 = event.getNewChild().getText())) {
                                            return;
                                        }
                                        if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                            return;
                                        }
                                        ResourceItem item = ResourceFolderRepository.this.findResourceItem(type, psiFile2, oldName, xmlTag);
                                        if (item != null) {
                                            ResourceItem style;
                                            XmlTag parentTag;
                                            Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                            synchronized (object) {
                                                ListMultimap map2 = (ListMultimap)ResourceFolderRepository.this.myResourceTable.get(item.getType());
                                                if (map2 != null) {
                                                    map2.remove((Object)oldName, (Object)item);
                                                    if (ResourceFolderRepository.isValidValueResourceName(newName2)) {
                                                        PsiResourceItem newItem = PsiResourceItem.forXmlTag(newName2, type, ResourceFolderRepository.this, xmlTag, true);
                                                        map2.put((Object)newName2, (Object)newItem);
                                                        ResourceItemSource resFile = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(psiFile2.getVirtualFile());
                                                        if (resFile != null) {
                                                            PsiResourceFile resourceFile = (PsiResourceFile)resFile;
                                                            resourceFile.removeItem((PsiResourceItem)item);
                                                            resourceFile.addItem(newItem);
                                                        } else assert (false) : item;
                                                    }
                                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                    ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this, type);
                                                }
                                            }
                                            if (type == ResourceType.ATTR && (parentTag = xmlTag.getParentTag()) != null && IdeResourcesUtil.getResourceTypeForResourceTag(parentTag) == ResourceType.STYLEABLE && (style = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile2)) instanceof PsiResourceItem) {
                                                ((PsiResourceItem)style).recomputeValue();
                                            }
                                            return;
                                        }
                                    } else {
                                        XmlTag parentTag = xmlTag.getParentTag();
                                        if (parentTag != null && IdeResourcesUtil.getResourceTypeForResourceTag(parentTag) != null) {
                                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                                                return;
                                            }
                                            ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile2);
                                            if (resourceItem instanceof PsiResourceItem) {
                                                if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                }
                                                return;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                    } else if (folderType == ResourceFolderType.COLOR) {
                        PsiElement parent4 = event.getParent();
                        if (parent4 instanceof XmlElement) {
                            PsiElement attribute;
                            if (parent4 instanceof XmlComment) {
                                return;
                            }
                            if (parent4 instanceof XmlAttributeValue && (attribute = parent4.getParent()) instanceof XmlProcessingInstruction) {
                                return;
                            }
                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                            return;
                        }
                    } else if (folderType == ResourceFolderType.FONT) {
                        ResourceFolderRepository.this.clearFontCache(psiFile2.getVirtualFile());
                    } else if (folderType != null && (parent = event.getParent()) instanceof XmlElement) {
                        if (parent instanceof XmlComment) {
                            return;
                        }
                        ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                    }
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean handleIdsChange(@NotNull ResourceItemSource<? extends ResourceItem> resFile, @NotNull XmlTag xmlTag) {
            if (!(resFile instanceof PsiResourceFile)) {
                return false;
            }
            PsiResourceFile psiResourceFile = (PsiResourceFile)resFile;
            Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
            synchronized (object) {
                ResourceFolderRepository.this.removeItemsForTag(psiResourceFile, xmlTag, ResourceType.ID);
                HashMap result2 = new HashMap();
                ArrayList<PsiResourceItem> ids2 = new ArrayList<PsiResourceItem>();
                ResourceFolderRepository.this.addIds((Map<ResourceType, ListMultimap<String, ResourceItem>>)result2, (List<PsiResourceItem>)ids2, xmlTag, true);
                ResourceFolderRepository.this.commitToRepository(result2);
                ids2.forEach(psiResourceFile::addItem);
                ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this, ResourceType.ID);
                return true;
            }
        }

        private void handleValueXmlTextEdit(@Nullable PsiElement parent, @NotNull PsiFile psiFile2) {
            XmlTag style;
            if (!(parent instanceof XmlTag)) {
                return;
            }
            XmlTag parentTag = (XmlTag)parent;
            String parentTagName = parentTag.getName();
            if (parentTagName.equals("resources")) {
                return;
            }
            if (parentTagName.equals("item") && (style = parentTag.getParentTag()) != null && ResourceType.fromXmlTagName((String)style.getName()) != null) {
                boolean cleared;
                ResourceFolderType folderType = IdeResourcesUtil.getFolderType(psiFile2);
                assert (folderType != null);
                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                    return;
                }
                ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(style, psiFile2);
                if (item instanceof PsiResourceItem && (cleared = ((PsiResourceItem)item).recomputeValue())) {
                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                }
                return;
            }
            while (parentTag != null) {
                if (ResourceFolderRepository.isItemElement(parentTag)) {
                    boolean cleared;
                    ResourceFolderType folderType = IdeResourcesUtil.getFolderType(psiFile2);
                    assert (folderType != null);
                    if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile2, folderType)) {
                        return;
                    }
                    ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile2);
                    if (!(item instanceof PsiResourceItem) || !(cleared = ((PsiResourceItem)item).recomputeValue())) break;
                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                    break;
                }
                parentTag = parentTag.getParentTag();
            }
        }

        public final void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
            this.myIgnoreChildrenChanged = false;
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            PsiElement parent = event.getParent();
            if (this.myIgnoreChildrenChanged ? parent != event.getChild() : event instanceof PsiTreeChangeEventImpl && ((PsiTreeChangeEventImpl)event).isGenericChange()) {
                return;
            }
            if (parent != null && parent.getChildren().length == 1 && parent.getChildren()[0] instanceof PsiWhiteSpace) {
                return;
            }
            PsiFile psiFile2 = event.getFile();
            if (psiFile2 != null && AndroidFileChangeListener.isRelevantFile(psiFile2)) {
                ResourceFolderType folderType;
                VirtualFile virtualFile = psiFile2.getVirtualFile();
                if (virtualFile != null && (folderType = IdeResourcesUtil.getFolderType(psiFile2)) != null && ResourceFolderRepository.this.isResourceFile(psiFile2)) {
                    ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                }
            } else {
                Throwable throwable = new Throwable();
                throwable.fillInStackTrace();
                LOG.debug("Received unexpected childrenChanged event for inter-file operations", throwable);
            }
        }
    }

    private final class SimplePsiListener
    extends PsiTreeAnyChangeAbstractAdapter {
        private SimplePsiListener() {
        }

        protected void onChange(@Nullable PsiFile psiFile2) {
            ResourceFolderType folderType = IdeResourcesUtil.getFolderType(psiFile2);
            if (folderType != null && psiFile2 != null && ResourceFolderRepository.this.isResourceFile(psiFile2)) {
                ResourceFolderRepository.this.scheduleScan(psiFile2.getVirtualFile(), folderType);
            }
        }
    }
}

