/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.tools.idea.res.ResourceClassGenerator;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceClassRegistry {
    private final Map<ResourceRepository, ResourceClassGenerator> myGeneratorMap = new HashMap<ResourceRepository, ResourceClassGenerator>();
    private Set<String> myPackages;

    public void addLibrary(@NotNull ResourceRepository repo, @NotNull ResourceIdManager idManager, @Nullable String packageName, @NotNull ResourceNamespace namespace) {
        if (StringUtil.isNotEmpty((String)packageName)) {
            if (this.myPackages == null) {
                this.myPackages = new HashSet<String>();
            }
            this.myPackages.add(packageName);
            if (!this.myGeneratorMap.containsKey(repo)) {
                ResourceClassGenerator generator2 = ResourceClassGenerator.create(idManager, repo, namespace);
                this.myGeneratorMap.put(repo, generator2);
            }
        }
    }

    @Nullable
    public byte[] findClassDefinition(@NotNull String className2, @NotNull ResourceRepositoryManager repositoryManager) {
        int index2 = className2.lastIndexOf(46);
        if (index2 > 1 && className2.charAt(index2 + 1) == 'R' && (index2 == className2.length() - 2 || className2.charAt(index2 + 2) == '$')) {
            ResourceNamespace namespace;
            List<ResourceRepository> repositories;
            ResourceClassGenerator generator2;
            String pkg = className2.substring(0, index2);
            if (this.myPackages != null && this.myPackages.contains(pkg) && (generator2 = this.findClassGenerator(repositories = repositoryManager.getAppResourcesForNamespace(namespace = ResourceNamespace.fromPackageName((String)pkg)), className2)) != null) {
                return generator2.generate(className2);
            }
        }
        return null;
    }

    @Nullable
    private ResourceClassGenerator findClassGenerator(@NotNull List<ResourceRepository> repositories, @NotNull String className2) {
        ResourceClassGenerator foundGenerator = null;
        for (int i2 = 0; i2 < repositories.size(); ++i2) {
            ResourceClassGenerator generator2 = this.myGeneratorMap.get(repositories.get(i2));
            if (generator2 == null) continue;
            if (foundGenerator == null) {
                foundGenerator = generator2;
                continue;
            }
            throw new NoClassDefFoundError(className2 + " class could not be loaded because of package name collision between libraries");
        }
        return foundGenerator;
    }

    public void clearCache() {
        this.myGeneratorMap.clear();
    }

    @NotNull
    public static ResourceClassRegistry get(@NotNull Project project) {
        return (ResourceClassRegistry)project.getService(ResourceClassRegistry.class);
    }

    @VisibleForTesting
    @NotNull
    Collection<String> getPackages() {
        return this.myPackages == null ? Collections.emptySet() : this.myPackages;
    }

    @VisibleForTesting
    @NotNull
    Map<ResourceRepository, ResourceClassGenerator> getGeneratorMap() {
        return this.myGeneratorMap;
    }
}

