/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.resources.ResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

final class ProjectResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;

    private ProjectResourceRepository(@NotNull AndroidFacet facet2, @NotNull List<LocalResourceRepository> localResources) {
        super(facet2.getModule().getName() + " with modules");
        this.myFacet = facet2;
        this.setChildren(localResources, (Collection<? extends AarResourceRepository>)ImmutableList.of(), (Collection<? extends ResourceRepository>)ImmutableList.of());
    }

    @NotNull
    public static ProjectResourceRepository create(@NotNull AndroidFacet facet2) {
        List<LocalResourceRepository> resources = ProjectResourceRepository.computeRepositories(facet2);
        return new ProjectResourceRepository(facet2, resources);
    }

    @NotNull
    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet2) {
        LocalResourceRepository main = ResourceRepositoryManager.getModuleResources(facet2);
        List<AndroidFacet> dependencies2 = AndroidUtils.getAndroidResourceDependencies(facet2.getModule());
        if (dependencies2.isEmpty()) {
            return Collections.singletonList(main);
        }
        ArrayList<LocalResourceRepository> resources = new ArrayList<LocalResourceRepository>(dependencies2.size() + 1);
        resources.add(main);
        for (AndroidFacet dependency : dependencies2) {
            resources.add(ResourceRepositoryManager.getModuleResources(dependency));
        }
        return resources;
    }

    void updateRoots() {
        List<LocalResourceRepository> repositories = ProjectResourceRepository.computeRepositories(this.myFacet);
        this.invalidateResourceDirs();
        this.setChildren(repositories, (Collection<? extends AarResourceRepository>)ImmutableList.of(), (Collection<? extends ResourceRepository>)ImmutableList.of());
    }

    @VisibleForTesting
    @NotNull
    static ProjectResourceRepository createForTest(@NotNull AndroidFacet facet2, @NotNull List<LocalResourceRepository> modules) {
        ProjectResourceRepository repository = new ProjectResourceRepository(facet2, modules);
        Disposer.register((Disposable)facet2, (Disposable)repository);
        return repository;
    }
}

