/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.gradle.model.IdeLibrary;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.projectmodel.ExternalLibrary;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.fonts.DownloadableFontCacheService;
import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.FileResourceReader;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.sampledata.datasource.ResourceContent;
import com.google.common.collect.Streams;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssetRepositoryImpl
extends AssetRepository {
    private static File myFrameworkResDirOrJar;
    private AndroidFacet myFacet;

    public AssetRepositoryImpl(@NotNull AndroidFacet facet2) {
        this.myFacet = facet2;
    }

    public boolean isSupported() {
        return true;
    }

    @Nullable
    public InputStream openAsset(@NotNull String path2, int mode) throws IOException {
        assert (this.myFacet != null);
        return AssetRepositoryImpl.getDirectories(this.myFacet, IdeaSourceProvider::getAssetsDirectories, IdeLibrary::getAssetsFolder).map(assetDir -> assetDir.findFileByRelativePath(path2)).map(assetDir -> {
            if (assetDir == null) {
                return null;
            }
            try {
                return assetDir.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).findAny().orElse(null);
    }

    private static boolean isCachedFontFile(@NotNull VirtualFile file2) {
        File fontCachePathFile = DownloadableFontCacheService.getInstance().getFontPath();
        if (fontCachePathFile == null) {
            return false;
        }
        VirtualFile fontCachePath = VirtualFileManager.getInstance().findFileByUrl("file://" + fontCachePathFile.getAbsolutePath());
        if (fontCachePath == null) {
            return false;
        }
        return VfsUtilCore.isAncestor((VirtualFile)fontCachePath, (VirtualFile)file2, (boolean)true);
    }

    @Nullable
    public InputStream openNonAsset(int cookie, @NotNull String path2, int mode) throws IOException {
        String url;
        assert (this.myFacet != null);
        if (path2.startsWith("apk:") || path2.startsWith("jar:")) {
            return new ByteArrayInputStream(FileResourceReader.readBytes(path2));
        }
        if (path2.startsWith("file://")) {
            url = path2;
        } else {
            if (path2.startsWith("file:")) {
                path2 = path2.substring("file:".length());
            }
            url = "file://" + path2;
        }
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file2 == null) {
            return null;
        }
        return AssetRepositoryImpl.getDirectories(this.myFacet, IdeaSourceProvider::getResDirectories, IdeLibrary::getResFolder).filter(resDir -> VfsUtilCore.isAncestor((VirtualFile)resDir, (VirtualFile)file2, (boolean)true)).map(resDir -> {
            try {
                return file2.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }).findAny().orElseGet(() -> {
            if (AssetRepositoryImpl.isCachedFontFile(file2)) {
                try {
                    return file2.getInputStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        });
    }

    public boolean isFileResource(@NotNull String path2) {
        return IdeResourcesUtil.isFileResource(path2);
    }

    @NotNull
    private static Stream<VirtualFile> getDirectories(@NotNull AndroidFacet facet2, @NotNull Function<IdeaSourceProvider, Iterable<VirtualFile>> sourceMapper, @NotNull Function<IdeLibrary, String> aarMapper) {
        Stream dirsFromSources = Stream.concat(Stream.of(facet2), AndroidUtils.getAllAndroidDependencies(facet2.getModule(), true).stream()).flatMap(f -> SourceProviderManager.getInstance(f).getCurrentAndSomeFrequentlyUsedInactiveSourceProviders().stream()).distinct().map(sourceMapper).flatMap(Streams::stream);
        VirtualFileManager manager = VirtualFileManager.getInstance();
        Stream<VirtualFile> dirsFromAars = ResourceRepositoryManager.findAarLibraries(facet2).stream().map(aarMapper).map(path2 -> manager.findFileByUrl("file://" + path2)).filter(Objects::nonNull);
        Stream<Object> libraryDepAars = Stream.empty();
        if (((Boolean)StudioFlags.NELE_ASSET_REPOSITORY_INCLUDE_AARS_THROUGH_PROJECT_SYSTEM.get()).booleanValue()) {
            libraryDepAars = ProjectSystemUtil.getModuleSystem(facet2.getModule()).getResolvedLibraryDependencies().stream().map(ExternalLibrary::getLocation).filter(location -> location != null && location.getFileName().endsWith(".aar")).map(path2 -> manager.findFileByUrl("file://" + path2.getPortablePath())).filter(Objects::nonNull);
        }
        Stream<VirtualFile> frameworkDirs = Stream.of(AssetRepositoryImpl.getSdkResDirOrJar(facet2)).filter(Objects::nonNull).map(path2 -> manager.findFileByUrl("file://" + path2)).filter(Objects::nonNull);
        Stream<VirtualFile> sampleDataDirs = Stream.of(ResourceContent.getSampleDataBaseDir(), ResourceContent.getSampleDataUserDir(facet2)).filter(Objects::nonNull).map(dir -> manager.findFileByUrl("file://" + dir.getAbsolutePath())).filter(Objects::nonNull);
        return Stream.of(dirsFromSources, dirsFromAars, frameworkDirs, sampleDataDirs, libraryDepAars).flatMap(stream -> stream);
    }

    @Nullable
    private static File getSdkResDirOrJar(@NotNull AndroidFacet facet2) {
        if (myFrameworkResDirOrJar == null) {
            ConfigurationManager manager = ConfigurationManager.getOrCreateInstance(facet2);
            IAndroidTarget target = manager.getHighestApiTarget();
            if (target == null) {
                return null;
            }
            CompatibilityRenderTarget compatibilityTarget = StudioEmbeddedRenderTarget.getCompatibilityTarget(target);
            myFrameworkResDirOrJar = compatibilityTarget.getFile(11);
        }
        return myFrameworkResDirOrJar;
    }
}

