/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.parsers;

import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.ide.common.resources.sampledata.SampleDataManager;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.support.FragmentTagUtil;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.parsers.AaptAttrAttributeSnapshot;
import com.android.tools.idea.rendering.parsers.AaptAttrParser;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.rendering.parsers.LayoutPullParser;
import com.android.tools.idea.rendering.parsers.MenuPsiPullParser;
import com.android.tools.idea.rendering.parsers.PaddingLayoutPsiPullParser;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.android.dom.navigation.NavXmlHelperKt;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutPsiPullParser
extends LayoutPullParser
implements AaptAttrParser {
    final ResourceResolver myResourceResolver;
    private static final ImmutableSet<String> TAGS_SUPPORTING_SRC_COMPAT = ImmutableSet.of((Object)"ImageButton", (Object)"ImageView");
    private static final TagSnapshot EMPTY_LAYOUT = TagSnapshot.createSyntheticTag(null, "LinearLayout", "android", "http://schemas.android.com/apk/res/android", (List<AttributeSnapshot>)ImmutableList.of((Object)new AttributeSnapshot("http://schemas.android.com/apk/res/android", "android", "layout_width", "match_parent"), (Object)new AttributeSnapshot("http://schemas.android.com/apk/res/android", "android", "layout_height", "match_parent")), (List<TagSnapshot>)ImmutableList.of(), null);
    private static final Consumer<TagSnapshot> TAG_SNAPSHOT_DECORATOR = tagSnapshot -> {
        if ("com.google.android.gms.ads.AdView".equals(tagSnapshot.tagName) || "com.google.android.gms.maps.MapView".equals(tagSnapshot.tagName)) {
            tagSnapshot.setAttribute("minWidth", "http://schemas.android.com/tools", "tools", "50dp", false);
            tagSnapshot.setAttribute("minHeight", "http://schemas.android.com/tools", "tools", "50dp", false);
            tagSnapshot.setAttribute("background", "http://schemas.android.com/tools", "tools", "#AAA", false);
        } else if ((tagSnapshot.tagName.equals("ListView") || tagSnapshot.tagName.equals("ExpandableListView") || tagSnapshot.tagName.equals("GridView") || tagSnapshot.tagName.equals("Spinner")) && tagSnapshot.getAttribute("id", "http://schemas.android.com/apk/res/android") == null) {
            String prefix;
            String string = prefix = tagSnapshot.tag != null ? tagSnapshot.tag.getPrefixByNamespace("http://schemas.android.com/apk/res/android") : null;
            if (prefix != null) {
                tagSnapshot.setAttribute("id", "http://schemas.android.com/apk/res/android", prefix, "@+id/_dynamic");
            }
        }
    };
    @NotNull
    private final ILayoutLog myLogger;
    @NotNull
    private final List<TagSnapshot> myNodeStack = new ArrayList<TagSnapshot>();
    protected final TagSnapshot myRoot;
    @NotNull
    protected final ImmutableMap<String, String> myNamespacePrefixes;
    private final ResourceNamespace myLayoutNamespace;
    protected boolean myProvideViewCookies = true;
    private boolean myUseSrcCompat;
    private boolean myUseToolsPositionAndVisibility;
    private HashSet<String> myToolsPositionAndVisibilityAttributes = new HashSet<String>(Arrays.asList("layout_editor_absoluteX", "layout_editor_absoluteY", "visibility"));
    private final ImmutableMap<String, TagSnapshot> myDeclaredAaptAttrs;
    private int mySampleDataCounter;
    private final Map<String, AtomicInteger> mySampleDataCounterMap = new HashMap<String, AtomicInteger>();
    private final Consumer<TagSnapshot> mySampleDataProcessing = tagSnapshot -> {
        for (AttributeSnapshot attributeSnapshot : tagSnapshot.attributes) {
            String resourceUrl = attributeSnapshot.value;
            if (resourceUrl == null || !resourceUrl.startsWith("@sample/") && !resourceUrl.startsWith("@tools:sample/")) continue;
            String resourceName = SampleDataManager.getResourceNameFromSampleReference((String)resourceUrl);
            AtomicInteger position = this.mySampleDataCounterMap.get(resourceName);
            if (position == null) {
                position = new AtomicInteger(this.mySampleDataCounter);
                this.mySampleDataCounterMap.put(resourceName, position);
            }
            attributeSnapshot.value = LayoutPsiPullParser.getSampleDataResourceUrl(resourceUrl, position);
        }
    };

    @NotNull
    public static LayoutPsiPullParser create(@NotNull XmlFile file2, @NotNull IRenderLogger logger2, boolean honorMergeParentTag, ResourceResolver resolver, int sampleDataCounter) {
        if (IdeResourcesUtil.getFolderType((PsiFile)file2) == ResourceFolderType.MENU) {
            return new MenuPsiPullParser(file2, logger2);
        }
        return new LayoutPsiPullParser(file2, (ILayoutLog)logger2, honorMergeParentTag, resolver, sampleDataCounter);
    }

    @NotNull
    public static LayoutPsiPullParser create(@NotNull XmlFile file2, @NotNull IRenderLogger logger2) {
        return LayoutPsiPullParser.create(file2, logger2, true, null, 0);
    }

    @NotNull
    public static LayoutPsiPullParser create(@NotNull XmlFile file2, @NotNull IRenderLogger logger2, Set<XmlTag> explodeNodes, @NotNull Density density, ResourceResolver resourceResolver2, @NotNull Boolean useToolsPositionAndVisibility) {
        if (explodeNodes != null && !explodeNodes.isEmpty()) {
            return new PaddingLayoutPsiPullParser(file2, logger2, explodeNodes, density);
        }
        return new LayoutPsiPullParser(file2, (ILayoutLog)logger2, true, resourceResolver2, useToolsPositionAndVisibility);
    }

    @NotNull
    public static LayoutPsiPullParser create(RenderTask.AttributeFilter filter2, @NotNull XmlTag root2, @NotNull IRenderLogger logger2) {
        return new AttributeFilteredLayoutParser(root2, (ILayoutLog)logger2, filter2);
    }

    @NotNull
    public static LayoutPsiPullParser create(@NotNull TagSnapshot root2, @NotNull ResourceNamespace layoutNamespace, @NotNull ILayoutLog log) {
        return new LayoutPsiPullParser(root2, layoutNamespace, log);
    }

    protected LayoutPsiPullParser(@NotNull XmlFile file2, @NotNull ILayoutLog logger2, boolean honorMergeParentTag) {
        this(file2, logger2, honorMergeParentTag, null, 0);
    }

    protected LayoutPsiPullParser(@NotNull XmlFile file2, @NotNull ILayoutLog logger2, boolean honorMergeParentTag, ResourceResolver resolver, int sampleDataCounter) {
        this(AndroidPsiUtils.getRootTagSafely((XmlFile)file2), logger2, honorMergeParentTag, resolver, sampleDataCounter, true);
    }

    protected LayoutPsiPullParser(@NotNull XmlFile file2, @NotNull ILayoutLog logger2, boolean honorMergeParentTag, ResourceResolver resourceResolver2, boolean useToolsPositionAndVisibility) {
        this(AndroidPsiUtils.getRootTagSafely((XmlFile)file2), logger2, honorMergeParentTag, resourceResolver2, 0, useToolsPositionAndVisibility);
    }

    @NotNull
    private static ImmutableMap<String, String> buildNamespacesMap(TagSnapshot root2) {
        XmlTag rootTag;
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (ImmutableMap)ApplicationManager.getApplication().runReadAction(() -> LayoutPsiPullParser.buildNamespacesMap(root2));
        }
        XmlTag xmlTag = rootTag = root2 != null ? root2.tag : null;
        if (rootTag == null || !rootTag.isValid()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder prefixesBuilder = ImmutableMap.builder();
        for (String uri : new String[]{"http://schemas.android.com/apk/res/android", "http://schemas.android.com/tools", "http://schemas.android.com/apk/res-auto"}) {
            String prefix = rootTag.getPrefixByNamespace(uri);
            if (prefix == null) continue;
            prefixesBuilder.put((Object)uri, (Object)prefix);
        }
        return prefixesBuilder.build();
    }

    protected LayoutPsiPullParser(XmlTag root2, @NotNull ILayoutLog logger2, boolean honorMergeParentTag, ResourceResolver resourceResolver2) {
        this(root2, logger2, honorMergeParentTag, resourceResolver2, 0, true);
    }

    protected LayoutPsiPullParser(XmlTag root2, @NotNull ILayoutLog logger2, boolean honorMergeParentTag, ResourceResolver resourceResolver2, int sampleDataCounter, boolean useToolsPositionAndVisibility) {
        this.myResourceResolver = resourceResolver2;
        this.myLogger = logger2;
        this.mySampleDataCounter = sampleDataCounter;
        this.myUseToolsPositionAndVisibility = useToolsPositionAndVisibility;
        Ref myRootRef = new Ref((Object)EMPTY_LAYOUT);
        Ref myLayoutNamespaceRef = new Ref((Object)ResourceNamespace.RES_AUTO);
        ReadAction.run(() -> {
            if (root2 != null && root2.isValid()) {
                myRootRef.set((Object)LayoutPsiPullParser.createSnapshot(root2, honorMergeParentTag, this.mySampleDataProcessing));
                ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance((PsiElement)root2);
                if (repositoryManager != null) {
                    myLayoutNamespaceRef.set((Object)repositoryManager.getNamespace());
                }
            }
        });
        this.myRoot = (TagSnapshot)myRootRef.get();
        this.myLayoutNamespace = (ResourceNamespace)myLayoutNamespaceRef.get();
        this.myNamespacePrefixes = LayoutPsiPullParser.buildNamespacesMap(this.myRoot);
        this.myDeclaredAaptAttrs = LayoutPsiPullParser.findDeclaredAaptAttrs(this.myRoot);
    }

    protected LayoutPsiPullParser(@NotNull TagSnapshot root2, @NotNull ResourceNamespace layoutNamespace, @NotNull ILayoutLog log) {
        this.myResourceResolver = null;
        this.myLogger = log;
        this.myDeclaredAaptAttrs = ImmutableMap.of();
        this.myRoot = (TagSnapshot)ApplicationManager.getApplication().runReadAction(() -> {
            if (root2.tag != null && root2.tag.isValid()) {
                return root2;
            }
            return null;
        });
        this.myNamespacePrefixes = LayoutPsiPullParser.buildNamespacesMap(this.myRoot);
        this.myLayoutNamespace = layoutNamespace;
    }

    @NotNull
    private static String getSampleDataResourceUrl(@NotNull String resourceUrl, @NotNull AtomicInteger offset2) {
        int start2 = resourceUrl.indexOf(91);
        if (start2 != -1) {
            int separator = resourceUrl.indexOf(":", start2);
            if (separator != -1) {
                int end = resourceUrl.indexOf(93);
                List indices = Splitter.on((String)":").limit(2).splitToList((CharSequence)resourceUrl.substring(start2 + 1, end));
                String bottom2 = (String)indices.get(0);
                String top = (String)indices.get(1);
                try {
                    int low = bottom2.isEmpty() ? 0 : Integer.parseUnsignedInt(bottom2);
                    int positionIndex = offset2.getAndIncrement();
                    if (!top.isEmpty()) {
                        positionIndex %= Integer.parseUnsignedInt(top) + 1 - low;
                    }
                    return resourceUrl.substring(0, start2 + 1) + (positionIndex += low) + "]";
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return resourceUrl;
        }
        return resourceUrl + "[" + offset2.getAndIncrement() + "]";
    }

    @Override
    @NotNull
    public ImmutableMap<String, TagSnapshot> getAaptDeclaredAttrs() {
        return this.myDeclaredAaptAttrs;
    }

    public ResourceNamespace getLayoutNamespace() {
        return this.myLayoutNamespace;
    }

    @NotNull
    private static ImmutableMap<String, TagSnapshot> findDeclaredAaptAttrs(TagSnapshot tag) {
        if (tag == null || !tag.hasDeclaredAaptAttrs) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        tag.attributes.stream().filter(attr -> attr instanceof AaptAttrAttributeSnapshot).map(attr -> (AaptAttrAttributeSnapshot)attr).forEach(attr -> {
            TagSnapshot bundledTag = attr.getBundledTag();
            builder2.put((Object)attr.getId(), (Object)bundledTag);
            for (TagSnapshot child : bundledTag.children) {
                builder2.putAll(LayoutPsiPullParser.findDeclaredAaptAttrs(child));
            }
        });
        for (TagSnapshot child : tag.children) {
            builder2.putAll(LayoutPsiPullParser.findDeclaredAaptAttrs(child));
        }
        return builder2.build();
    }

    protected final TagSnapshot getCurrentNode() {
        if (!this.myNodeStack.isEmpty()) {
            return this.myNodeStack.get(this.myNodeStack.size() - 1);
        }
        return null;
    }

    protected final TagSnapshot getPreviousNode() {
        if (this.myNodeStack.size() > 1) {
            return this.myNodeStack.get(this.myNodeStack.size() - 2);
        }
        return null;
    }

    protected final AttributeSnapshot getAttribute(int i2) {
        if (this.myParsingState != 2) {
            throw new IndexOutOfBoundsException();
        }
        TagSnapshot uiNode = this.getCurrentNode();
        if (uiNode != null) {
            return uiNode.attributes.get(i2);
        }
        return null;
    }

    protected void push(@NotNull TagSnapshot node2) {
        this.myNodeStack.add(node2);
    }

    @NotNull
    protected TagSnapshot pop() {
        return this.myNodeStack.remove(this.myNodeStack.size() - 1);
    }

    public Object getViewCookie() {
        if (this.myProvideViewCookies) {
            return this.getCurrentNode();
        }
        return null;
    }

    public String getPositionDescription() {
        return "XML DOM element depth:" + this.myNodeStack.size();
    }

    public int getAttributeCount() {
        TagSnapshot node2 = this.getCurrentNode();
        if (node2 != null) {
            return node2.attributes.size();
        }
        return 0;
    }

    public String getAttributeName(int i2) {
        AttributeSnapshot attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.name;
        }
        return null;
    }

    public String getAttributeNamespace(int i2) {
        AttributeSnapshot attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.namespace;
        }
        return "";
    }

    public String getAttributePrefix(int i2) {
        AttributeSnapshot attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.prefix;
        }
        return null;
    }

    public String getAttributeValue(int i2) {
        AttributeSnapshot attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.value;
        }
        return null;
    }

    public String getAttributeValue(String namespace, String localName) {
        int n;
        String srcCompatValue;
        TagSnapshot tag = this.getCurrentNode();
        if (tag == null) {
            return null;
        }
        if ("layout".equals(localName) && FragmentTagUtil.isFragmentTag((String)tag.tagName)) {
            String layout2 = tag.getAttribute("layout", "http://schemas.android.com/tools");
            if (layout2 != null) {
                return layout2;
            }
            String navGraph = tag.getAttribute("navGraph", "http://schemas.android.com/apk/res-auto");
            if (navGraph != null) {
                return NavXmlHelperKt.getStartDestLayoutId(navGraph, this.myRoot.tag.getProject(), this.myResourceResolver);
            }
        } else if (this.myUseSrcCompat && "src".equals(localName) && TAGS_SUPPORTING_SRC_COMPAT.contains((Object)tag.tagName) && (srcCompatValue = this.getAttributeValue("http://schemas.android.com/apk/res-auto", "srcCompat")) != null) {
            return srcCompatValue;
        }
        String value2 = null;
        if (namespace == null) {
            value2 = tag.getAttribute(localName);
        } else if (!this.myUseToolsPositionAndVisibility && namespace.equals("http://schemas.android.com/tools")) {
            value2 = null;
        } else if (namespace.equals("http://schemas.android.com/apk/res/android") || namespace.equals("http://schemas.android.com/apk/res-auto")) {
            String toolsPrefix = (String)this.myNamespacePrefixes.get((Object)"http://schemas.android.com/tools");
            if (toolsPrefix == null || !this.myUseToolsPositionAndVisibility && this.myToolsPositionAndVisibilityAttributes.contains(localName)) {
                value2 = tag.getAttribute(localName, namespace);
            } else {
                int n2 = tag.attributes.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    AttributeSnapshot attribute = tag.attributes.get(i2);
                    if (!localName.equals(attribute.name)) continue;
                    if (toolsPrefix.equals(attribute.prefix)) {
                        value2 = attribute.value;
                        if (value2 != null && value2.isEmpty()) {
                            value2 = tag.getAttribute(localName, "http://schemas.android.com/apk/res/android") != null ? null : value2;
                        }
                        break;
                    }
                    if (!namespace.equals(attribute.namespace)) continue;
                    value2 = attribute.value;
                }
            }
        } else if (!"http://schemas.android.com/tools".equals(namespace)) {
            n = tag.attributes.size();
            for (int i3 = 0; i3 < n; ++i3) {
                AttributeSnapshot attribute = tag.attributes.get(i3);
                if (!localName.equals(attribute.name) || !namespace.equals(attribute.namespace) && !"http://schemas.android.com/apk/res-auto".equals(attribute.namespace)) continue;
                value2 = attribute.value;
                break;
            }
        } else {
            value2 = tag.getAttribute(localName, namespace);
        }
        if (value2 != null) {
            if ("match_parent".equals(value2) && ("layout_width".equals(localName) || "layout_height".equals(localName)) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                return "fill_parent";
            }
            value2 = value2.replaceAll("\\s", " ");
            n = value2.length();
            for (int i4 = 0; i4 < n; ++i4) {
                char c = value2.charAt(i4);
                if (c != '&' && c != '\\') continue;
                value2 = ValueXmlHelper.unescapeResourceString((String)value2, (boolean)true, (boolean)false);
                break;
            }
        }
        return value2;
    }

    public int getDepth() {
        return this.myNodeStack.size();
    }

    public String getName() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            String name = currentNode.tagName;
            String viewHandlerTag = currentNode.getAttribute("useHandler", "http://schemas.android.com/tools");
            if (StringUtil.isNotEmpty((String)viewHandlerTag)) {
                name = viewHandlerTag;
            }
            if (FragmentTagUtil.isFragmentTag((String)name)) {
                String navGraph;
                String layout2 = currentNode.getAttribute("layout", "http://schemas.android.com/tools");
                if (layout2 == null && (navGraph = currentNode.getAttribute("navGraph", "http://schemas.android.com/apk/res-auto")) != null && this.myResourceResolver != null) {
                    layout2 = NavXmlHelperKt.getStartDestLayoutId(navGraph, this.myRoot.tag.getProject(), this.myResourceResolver);
                }
                if (layout2 != null) {
                    return "include";
                }
                String fragmentId = currentNode.getAttribute("class");
                if ((fragmentId == null || fragmentId.isEmpty()) && ((fragmentId = currentNode.getAttribute("name", "http://schemas.android.com/apk/res/android")) == null || fragmentId.isEmpty())) {
                    fragmentId = currentNode.getAttribute("id", "http://schemas.android.com/apk/res/android");
                }
                this.myLogger.warning("missing.fragment", "Missing fragment association", null, (Object)fragmentId);
            } else if (name.endsWith("Compat") && name.indexOf(46) == -1) {
                return name.substring(0, name.length() - "Compat".length());
            }
            return name;
        }
        return null;
    }

    public String getNamespace() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.namespace;
        }
        return null;
    }

    public String getPrefix() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.prefix;
        }
        return null;
    }

    public String getNamespace(String prefix) {
        for (int i2 = this.myNodeStack.size() - 1; i2 >= 0; --i2) {
            String uri = this.myNodeStack.get((int)i2).namespaceDeclarations.get(prefix);
            if (uri == null) continue;
            return uri;
        }
        return null;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.myParsingState == 2) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.children.isEmpty();
        }
        throw new XmlPullParserException("Call to isEmptyElementTag while not in START_TAG", (XmlPullParser)this, null);
    }

    @Override
    protected void onNextFromStartDocument() {
        if (this.myRoot != null) {
            this.push(this.myRoot);
            this.myParsingState = 2;
        } else {
            this.myParsingState = 1;
        }
    }

    @Override
    protected void onNextFromStartTag() {
        TagSnapshot node2 = this.getCurrentNode();
        assert (node2 != null);
        List<TagSnapshot> children = node2.children;
        if (!children.isEmpty()) {
            this.push(children.get(0));
            this.myParsingState = 2;
        } else {
            this.myParsingState = this.myParsingState == 0 ? 1 : 3;
        }
    }

    @Override
    protected void onNextFromEndTag() {
        TagSnapshot node2 = this.getCurrentNode();
        assert (node2 != null);
        TagSnapshot sibling = node2.getNextSibling();
        if (sibling != null) {
            node2 = sibling;
            this.pop();
            this.push(node2);
            this.myParsingState = 2;
        } else {
            this.pop();
            this.myParsingState = this.myNodeStack.isEmpty() ? 1 : 3;
        }
    }

    public void setProvideViewCookies(boolean provideViewCookies) {
        this.myProvideViewCookies = provideViewCookies;
    }

    private static int distanceToLayoutTag(@NotNull XmlTag tag) {
        int distance = 0;
        while ((tag = tag.getParentTag()) != null) {
            String tagName = tag.getName();
            if (!"merge".equals(tagName)) {
                ++distance;
            }
            if (!"layout".equals(tagName)) continue;
            break;
        }
        return tag != null ? distance : -1;
    }

    private static TagSnapshot createSnapshot(@NotNull XmlTag tag, boolean honorMergeParentTag, @NotNull Consumer<TagSnapshot> tagPostProcessor) {
        String rootTag;
        Consumer<TagSnapshot> tagDecorator = TAG_SNAPSHOT_DECORATOR.andThen(tagPostProcessor);
        if (tag.getName().equals("layout")) {
            final String layoutRootName = tag.getContainingFile().getVirtualFile().getNameWithoutExtension();
            tagDecorator = tagDecorator.andThen(new Consumer<TagSnapshot>(){
                int counter = 0;

                @Override
                public void accept(TagSnapshot snapshot) {
                    if (snapshot.tag == null) {
                        return;
                    }
                    if (LayoutPsiPullParser.distanceToLayoutTag(snapshot.tag) == 1) {
                        snapshot.setAttribute("tag", "http://schemas.android.com/apk/res/android", "android", "layout/" + layoutRootName + "_" + this.counter++, false);
                    }
                }
            });
        }
        if ((tag = LayoutPsiPullParser.getRootTag(tag)) == null || tag.isEmpty() && tag.getName().isEmpty()) {
            return EMPTY_LAYOUT;
        }
        switch (rootTag = tag.getName()) {
            case "androidx.fragment.app.FragmentContainerView": 
            case "fragment": {
                return LayoutPsiPullParser.createSnapshotForViewFragment(rootTag, tag, tagPostProcessor);
            }
            case "FrameLayout": {
                return LayoutPsiPullParser.createSnapshotForFrameLayout(tag, tagDecorator);
            }
            case "merge": {
                return LayoutPsiPullParser.createSnapshotForMerge(tag, honorMergeParentTag, tagDecorator);
            }
        }
        return TagSnapshot.createTagSnapshot(tag, tagDecorator);
    }

    @NotNull
    private static TagSnapshot createSnapshotForViewFragment(@NotNull String rootTagName, @NotNull XmlTag rootTag, @NotNull Consumer<TagSnapshot> tagPostProcessor) {
        XmlAttribute[] psiAttributes = rootTag.getAttributes();
        ArrayList attributes = Lists.newArrayListWithCapacity((int)psiAttributes.length);
        for (XmlAttribute psiAttribute : psiAttributes) {
            AttributeSnapshot attribute = AttributeSnapshot.createAttributeSnapshot(psiAttribute);
            if (attribute == null) continue;
            attributes.add(attribute);
        }
        ArrayList includeAttributes = Lists.newArrayListWithCapacity((int)psiAttributes.length);
        for (XmlAttribute psiAttribute : psiAttributes) {
            AttributeSnapshot attribute;
            String localName;
            String name = psiAttribute.getName();
            if (name.startsWith("xmlns:") || (localName = psiAttribute.getLocalName()).startsWith("layout_margin") || localName.startsWith("padding") || localName.equals("id") || (attribute = AttributeSnapshot.createAttributeSnapshot(psiAttribute)) == null) continue;
            includeAttributes.add(attribute);
        }
        TagSnapshot include = TagSnapshot.createSyntheticTag(null, rootTagName, "", "", includeAttributes, Collections.emptyList(), null);
        return TagSnapshot.createSyntheticTag(rootTag, "FrameLayout", "", "", attributes, Collections.singletonList(include), tagPostProcessor);
    }

    @NotNull
    private static TagSnapshot createSnapshotForFrameLayout(@NotNull XmlTag rootTag, @NotNull Consumer<TagSnapshot> tagDecorator) {
        String visibleChild;
        String prefix;
        TagSnapshot root2 = TagSnapshot.createTagSnapshot(rootTag, tagDecorator);
        String layout2 = rootTag.getAttributeValue("layout", "http://schemas.android.com/tools");
        if (layout2 != null && root2.children.isEmpty() && (prefix = rootTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android")) != null) {
            ArrayList children;
            root2.children = children = Lists.newArrayList();
            ArrayList attributes = Lists.newArrayListWithExpectedSize((int)3);
            attributes.add(new AttributeSnapshot("", "", "layout", layout2));
            attributes.add(new AttributeSnapshot("http://schemas.android.com/apk/res/android", prefix, "layout_width", "fill_parent"));
            attributes.add(new AttributeSnapshot("http://schemas.android.com/apk/res/android", prefix, "layout_height", "fill_parent"));
            TagSnapshot element2 = TagSnapshot.createSyntheticTag(null, "include", "", "", attributes, Collections.emptyList(), null);
            children.add(element2);
        }
        if ((visibleChild = rootTag.getAttributeValue("visibleChildren", "http://schemas.android.com/tools")) != null) {
            HashSet indices = Sets.newHashSet();
            for (String s : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)visibleChild)) {
                try {
                    indices.add(Integer.parseInt(s));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            String prefix2 = rootTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
            if (prefix2 != null) {
                int n = root2.children.size();
                for (int i2 = 0; i2 < n; ++i2) {
                    TagSnapshot child = root2.children.get(i2);
                    boolean visible = indices.contains(i2);
                    child.setAttribute("visibility", "http://schemas.android.com/apk/res/android", prefix2, visible ? "visible" : "gone");
                }
            }
        }
        return root2;
    }

    @NotNull
    private static TagSnapshot createSnapshotForMerge(@NotNull XmlTag rootTag, boolean honorMergeParentTag, @NotNull Consumer<TagSnapshot> tagDecorator) {
        String parentTag;
        TagSnapshot root2 = TagSnapshot.createTagSnapshot(rootTag, tagDecorator);
        String string = parentTag = honorMergeParentTag ? rootTag.getAttributeValue("parentTag", "http://schemas.android.com/tools") : null;
        if (parentTag == null) {
            return root2;
        }
        List<AttributeSnapshot> attributes = AttributeSnapshot.createAttributesForTag(rootTag);
        LayoutPsiPullParser.addAttributeIfMissing(rootTag, "layout_width", attributes);
        LayoutPsiPullParser.addAttributeIfMissing(rootTag, "layout_height", attributes);
        return TagSnapshot.createSyntheticTag(rootTag, parentTag, "", "", attributes, root2.children, null);
    }

    private static void addAttributeIfMissing(@NotNull XmlTag tag, @NotNull String attrName, @NotNull List<AttributeSnapshot> attributes) {
        String value2 = tag.getAttributeValue(attrName, "http://schemas.android.com/apk/res/android");
        if (value2 == null) {
            value2 = tag.getAttributeValue(attrName, "http://schemas.android.com/tools");
        }
        if (value2 == null) {
            attributes.add(new AttributeSnapshot("http://schemas.android.com/apk/res/android", tag.getPrefixByNamespace("http://schemas.android.com/apk/res/android"), attrName, "match_parent"));
        }
    }

    public static XmlTag getRootTag(@NotNull XmlTag tag) {
        if (tag.getName().equals("layout")) {
            for (XmlTag subTag : tag.getSubTags()) {
                String subTagName = subTag.getName();
                if (subTagName.equals("data")) continue;
                return subTag;
            }
            return null;
        }
        return tag;
    }

    public void setUseSrcCompat(boolean useSrcCompat) {
        this.myUseSrcCompat = useSrcCompat;
    }

    static class AttributeFilteredLayoutParser
    extends LayoutPsiPullParser {
        private final RenderTask.AttributeFilter myFilter;

        public AttributeFilteredLayoutParser(@NotNull XmlTag root2, @NotNull ILayoutLog logger2, RenderTask.AttributeFilter filter2) {
            super(root2, logger2, true, null);
            this.myFilter = filter2;
        }

        public AttributeFilteredLayoutParser(@NotNull XmlFile file2, @NotNull ILayoutLog logger2, RenderTask.AttributeFilter filter2) {
            super(file2, logger2, true);
            this.myFilter = filter2;
        }

        @Override
        public String getAttributeValue(String namespace, String localName) {
            String value2;
            XmlTag tag;
            TagSnapshot element2;
            if (this.myFilter != null && (element2 = this.getCurrentNode()) != null && (tag = element2.tag) != null && (value2 = ApplicationManager.getApplication().isReadAccessAllowed() ? this.myFilter.getAttribute(tag, namespace, localName) : (String)ApplicationManager.getApplication().runReadAction(() -> this.myFilter.getAttribute(tag, namespace, localName))) != null) {
                if (value2.isEmpty()) {
                    return null;
                }
                return value2;
            }
            return super.getAttributeValue(namespace, localName);
        }
    }
}

