/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.errors.ui;

import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.HtmlBuilder;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Objects;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderErrorModel {
    public static final RenderErrorModel STILL_BUILDING_ERROR_MODEL = new RenderErrorModel((Collection<Issue>)ImmutableList.of((Object)Issue.builder().setSeverity(HighlightSeverity.INFORMATION).setSummary("The project is still building").setHtmlContent(new HtmlBuilder().add("The project is still building and the current preview might be inaccurate.").newline().add("The preview will automatically refresh once the build finishes.")).build()));
    private ImmutableList<Issue> myIssues = ImmutableList.of();

    public RenderErrorModel(@NotNull Collection<Issue> issues) {
        this.myIssues = ImmutableList.copyOf(issues);
    }

    @NotNull
    public ImmutableList<Issue> getIssues() {
        return this.myIssues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderErrorModel that = (RenderErrorModel)o;
        return Objects.equals(this.myIssues, that.myIssues);
    }

    public int hashCode() {
        return Objects.hash(this.myIssues);
    }

    public static class Issue
    implements Comparable<Issue> {
        private HighlightSeverity mySeverity = HighlightSeverity.INFORMATION;
        private String mySummary;
        private String myHtmlContent;
        private HyperlinkListener myHyperlinkListener;
        private String myCachedPlainContent;

        private Issue() {
        }

        @NotNull
        public static Builder builder() {
            return new Builder();
        }

        @NotNull
        public HighlightSeverity getSeverity() {
            return this.mySeverity;
        }

        @NotNull
        public String getSummary() {
            return StringUtil.notNullize((String)this.mySummary);
        }

        @NotNull
        public String getHtmlContent() {
            return StringUtil.notNullize((String)this.myHtmlContent);
        }

        @NotNull
        private String getPlainContent() {
            if (this.myCachedPlainContent == null) {
                this.myCachedPlainContent = TextFormat.HTML.toText(this.myHtmlContent);
            }
            return this.myCachedPlainContent;
        }

        @Nullable
        public HyperlinkListener getHyperlinkListener() {
            return this.myHyperlinkListener;
        }

        @Override
        public int compareTo(@NotNull Issue o) {
            return ComparisonChain.start().compare((Comparable)o.getSeverity(), (Comparable)this.getSeverity()).compare((Comparable)((Object)this.mySummary), (Comparable)((Object)o.mySummary)).result();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Issue issue2 = (Issue)o;
            return Objects.equals(this.mySeverity, issue2.mySeverity) && Objects.equals(this.mySummary, issue2.mySummary) && Objects.equals(this.getPlainContent(), issue2.getPlainContent());
        }

        public int hashCode() {
            return Objects.hash(this.mySeverity, this.mySummary, this.myHtmlContent);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("severity", (Object)this.mySeverity).add("summary", (Object)this.mySummary).add("htmlContent", (Object)this.myHtmlContent).add("hasHyperlinkListener", this.myHyperlinkListener != null).toString();
        }

        public static class Builder {
            private final Issue myIssue = new Issue();

            @NotNull
            private Builder setHtmlContent(@NotNull String htmlContent) {
                this.myIssue.myHtmlContent = htmlContent;
                this.myIssue.myCachedPlainContent = null;
                return this;
            }

            @NotNull
            public Builder setHtmlContent(@NotNull HtmlBuilder htmlBuilder) {
                return this.setHtmlContent(htmlBuilder.getStringBuilder().toString());
            }

            @NotNull
            public Builder setSeverity(@NotNull HighlightSeverity severity) {
                this.myIssue.mySeverity = severity;
                return this;
            }

            @NotNull
            public Builder setSeverity(@NotNull HighlightSeverity severity, int priority) {
                this.myIssue.mySeverity = new HighlightSeverity(severity.myName, severity.myVal + priority);
                return this;
            }

            @NotNull
            public Builder setSummary(@NotNull String summary) {
                this.myIssue.mySummary = summary;
                return this;
            }

            @NotNull
            public Builder setLinkHandler(@NotNull HyperlinkListener listener2) {
                this.myIssue.myHyperlinkListener = listener2;
                return this;
            }

            @NotNull
            public Issue build() {
                if (this.myIssue.mySummary == null) {
                    this.myIssue.mySummary = "";
                }
                if (this.myIssue.mySeverity == null) {
                    this.myIssue.mySeverity = HighlightSeverity.INFORMATION;
                }
                if (this.myIssue.myHtmlContent == null) {
                    this.myIssue.myHtmlContent = "";
                }
                return this.myIssue;
            }
        }
    }
}

