/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.classloading;

import com.android.tools.idea.rendering.classloading.ClassConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InconvertibleClassError
extends UnsupportedClassVersionError {
    private final String myFqcn;
    private final int myMinor;
    private final int myMajor;

    public InconvertibleClassError(@Nullable Throwable cause, @NotNull String fqcn, int major, int minor) {
        super(fqcn);
        this.myFqcn = fqcn;
        this.myMajor = major;
        this.myMinor = minor;
        if (cause != null) {
            this.initCause(cause);
        }
    }

    @NotNull
    public String getClassName() {
        return this.myFqcn;
    }

    public int getMinor() {
        return this.myMinor;
    }

    public int getMajor() {
        return this.myMajor;
    }

    @NotNull
    public static UnsupportedClassVersionError wrap(@NotNull UnsupportedClassVersionError error, @NotNull String fqcn, byte[] data) {
        if (!ClassConverter.isValidClassFile(data)) {
            return error;
        }
        short minor = ClassConverter.getMinorVersion(data);
        short major = ClassConverter.getMajorVersion(data);
        return new InconvertibleClassError(error, fqcn, major, minor);
    }
}

