/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.resources.ResourceResolver;
import com.android.layoutlib.bridge.impl.RenderSessionImpl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.psi.TagToClassMapper;
import com.android.tools.idea.rendering.AddMissingAttributesFix;
import com.android.tools.idea.rendering.HtmlBuilderHelper;
import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.RenderTaskContext;
import com.android.tools.idea.rendering.SetAttributeFix;
import com.android.tools.idea.rendering.ShowExceptionFix;
import com.android.tools.idea.rendering.classloading.ClassConverter;
import com.android.tools.idea.rendering.classloading.InconvertibleClassError;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.HtmlBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

public class RenderErrorContributor {
    private static final String RENDER_SESSION_IMPL_FQCN = RenderSessionImpl.class.getCanonicalName();
    private static final Key<CachedValue<Set<String>>> VIEWS_CACHE_KEY = new Key(RenderErrorContributor.class.getName() + ".VIEWS_CACHE");
    protected static final int HIGH_PRIORITY = 100;
    protected static final int MEDIUM_PRIORITY = 10;
    protected static final int LOW_PRIORITY = 10;
    protected static final Logger LOG = Logger.getInstance(RenderErrorContributor.class);
    private static final String APP_COMPAT_REQUIRED_MSG = "You need to use a Theme.AppCompat";
    private final List<RenderErrorModel.Issue> myIssues = new ArrayList<RenderErrorModel.Issue>();
    private final HtmlLinkManager myLinkManager;
    private final HyperlinkListener myLinkHandler;
    private final RenderResult myResult;
    private final DataContext myDataContext;
    private final EditorDesignSurface myDesignSurface;

    protected RenderErrorContributor(@Nullable EditorDesignSurface surface2, @NotNull RenderResult result2, @Nullable DataContext dataContext) {
        this.myResult = result2;
        this.myDesignSurface = surface2;
        this.myLinkManager = this.myResult.getLogger().getLinkManager();
        this.myLinkHandler = e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                    return;
                }
                this.performClick(this.myResult, e.getDescription());
            }
        };
        this.myDataContext = dataContext;
    }

    private static boolean isHiddenFrame(@NotNull StackTraceElement frame) {
        String className2 = frame.getClassName();
        return className2.startsWith("sun.reflect.") || className2.equals("android.view.BridgeInflater") || className2.startsWith("com.android.tools.") || className2.startsWith("org.jetbrains.");
    }

    private static boolean isInterestingFrame(@NotNull StackTraceElement frame) {
        String className2 = frame.getClassName();
        return !className2.startsWith("android.") && !className2.startsWith("org.jetbrains.") && !className2.startsWith("com.android.") && !className2.startsWith("java.") && !className2.startsWith("javax.") && !className2.startsWith("sun.");
    }

    private static boolean isFramework(@NotNull StackTraceElement frame) {
        String className2 = frame.getClassName();
        return className2.startsWith("android.") || className2.startsWith("java.") || className2.startsWith("javax.") || className2.startsWith("sun.");
    }

    private static boolean isVisible(@NotNull StackTraceElement frame) {
        String className2 = frame.getClassName();
        return !RenderErrorContributor.isFramework(frame) && !className2.startsWith("sun.");
    }

    @NotNull
    private static Collection<String> getAllViews(@Nullable Module module2) {
        if (module2 == null) {
            return Collections.emptyList();
        }
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (Collection)ReadAction.compute(() -> RenderErrorContributor.getAllViews(module2));
        }
        if (DumbService.getInstance((Project)module2.getProject()).isDumb()) {
            LOG.warn("getAllViews called in Dumb mode, no views will be returned");
            return Collections.emptyList();
        }
        return TagToClassMapper.getInstance(module2).getClassMap("android.view.View").values().stream().map(PsiClass::getQualifiedName).collect(Collectors.toSet());
    }

    static boolean isBuiltByJdk7OrHigher(@NotNull Module module2) {
        Sdk jdk;
        AndroidSdkAdditionalData data;
        Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
        if (sdk == null) {
            return false;
        }
        AndroidSdks androidSdks = AndroidSdks.getInstance();
        if (androidSdks.isAndroidSdk(sdk) && (data = androidSdks.getAndroidSdkAdditionalData(sdk)) != null && (jdk = data.getJavaSdk()) != null) {
            sdk = jdk;
        }
        return sdk.getSdkType() instanceof JavaSdk && JavaSdk.getInstance().isOfVersionOrHigher(sdk, JavaSdkVersion.JDK_1_7);
    }

    private static void collectProblemModules(@NotNull Module module2, @NotNull Set<Module> visited, @NotNull Collection<Module> result2) {
        if (!visited.add(module2)) {
            return;
        }
        if (RenderErrorContributor.isBuiltByJdk7OrHigher(module2)) {
            result2.add(module2);
        }
        for (Module depModule : ModuleRootManager.getInstance((Module)module2).getDependencies(false)) {
            RenderErrorContributor.collectProblemModules(depModule, visited, result2);
        }
    }

    @NotNull
    private static Set<String> getSdkNamesFromModules(@NotNull Collection<Module> modules) {
        HashSet<String> result2 = new HashSet<String>();
        for (Module module2 : modules) {
            Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
            if (sdk == null) continue;
            result2.add(sdk.getName());
        }
        return result2;
    }

    @NotNull
    private static List<Module> getProblemModules(@NotNull Module root2) {
        ArrayList<Module> result2 = new ArrayList<Module>();
        RenderErrorContributor.collectProblemModules(root2, new HashSet<Module>(), result2);
        return result2;
    }

    private static void askAndRebuild(Project project) {
        int r = Messages.showYesNoDialog((Project)project, (String)"You have to rebuild project to see the fixed preview. Would you like to do it?", (String)"Rebuild Project", (Icon)Messages.getQuestionIcon());
        if (r == 0) {
            CompilerManager.getInstance((Project)project).rebuild(null);
        }
    }

    protected RenderErrorModel.Issue.Builder addIssue() {
        return new RenderErrorModel.Issue.Builder(){

            @Override
            @NotNull
            public RenderErrorModel.Issue build() {
                RenderErrorModel.Issue built = super.build();
                RenderErrorContributor.this.myIssues.add(built);
                return built;
            }
        }.setLinkHandler(this.myLinkHandler);
    }

    private void reportMissingStyles(@NotNull RenderLogger logger2) {
        if (logger2.seenTagPrefix("project.building")) {
            this.addIssue().setSummary("Project Still Building: May cause rendering errors until the build is done").build();
        } else if (logger2.seenTagPrefix("resources.resolve.theme")) {
            this.addIssue().setSummary("Missing styles").setHtmlContent(new HtmlBuilder().addBold("Missing styles. Is the correct theme chosen for this layout?").newline().addIcon(HtmlBuilderHelper.getTipIconPath()).add("Use the Theme combo box above the layout to choose a different layout, or fix the theme style references.")).build();
        }
    }

    private void reportMissingSize(@NotNull HtmlBuilder builder2, @NotNull RenderLogger logger2, @NotNull String fill2, @NotNull XmlTag tag, @NotNull String id, @NotNull String attribute) {
        Module module2 = logger2.getModule();
        if (module2 == null) {
            return;
        }
        Project project = module2.getProject();
        String wrapUrl = this.myLinkManager.createCommandLink(new SetAttributeFix(project, tag, attribute, "http://schemas.android.com/apk/res/android", "wrap_content"));
        String fillUrl = this.myLinkManager.createCommandLink(new SetAttributeFix(project, tag, attribute, "http://schemas.android.com/apk/res/android", fill2));
        builder2.add(String.format("%1$s does not set the required %2$s attribute: ", id, attribute)).newline().addNbsps(4).addLink("Set to wrap_content", wrapUrl).add(", ").addLink("Set to " + fill2, fillUrl).newline();
    }

    private void reportMissingSizeAttributes(@NotNull RenderLogger logger2, @NotNull RenderTaskContext renderTaskContext, @Nullable XmlFile psiFile2) {
        Module module2 = logger2.getModule();
        if (module2 == null) {
            return;
        }
        Project project = module2.getProject();
        if (logger2.isMissingSize()) {
            HtmlBuilder builder2 = new HtmlBuilder();
            builder2.addBold("NOTE: One or more layouts are missing the layout_width or layout_height attributes. These are required in most layouts.").newline();
            ResourceResolver resourceResolver2 = renderTaskContext.getConfiguration().getResourceResolver();
            if (psiFile2 == null) {
                LOG.error("PsiFile is missing in RenderTask used in RenderErrorPanel!");
                return;
            }
            AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(module2);
            String fill2 = moduleInfo == null || moduleInfo.getBuildSdkVersion() == null || moduleInfo.getBuildSdkVersion().getApiLevel() >= 8 ? "match_parent" : "fill_parent";
            ApplicationManager.getApplication().runReadAction(() -> AddMissingAttributesFix.findViewsMissingSizes(psiFile2, resourceResolver2).stream().map(SmartPsiElementPointer::getElement).filter(Objects::nonNull).filter(PsiElement::isValid).forEach(tag -> {
                boolean missingHeight;
                boolean missingWidth = !AddMissingAttributesFix.definesWidth(tag, resourceResolver2);
                boolean bl = missingHeight = !AddMissingAttributesFix.definesHeight(tag, resourceResolver2);
                assert (missingWidth || missingHeight);
                String id = tag.getAttributeValue("id");
                id = id == null || id.isEmpty() ? '<' + tag.getName() + '>' : '\"' + Lint.stripIdPrefix((String)id) + '\"';
                if (missingWidth) {
                    this.reportMissingSize(builder2, logger2, fill2, (XmlTag)tag, id, "layout_width");
                }
                if (missingHeight) {
                    this.reportMissingSize(builder2, logger2, fill2, (XmlTag)tag, id, "layout_height");
                }
            }));
            builder2.newline().add("Or: ").addLink("Automatically add all missing attributes", this.myLinkManager.createCommandLink(new AddMissingAttributesFix(project, psiFile2, resourceResolver2))).newline().newline().newline();
            this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("One or more layouts are missing the layout_width or layout_height attributes").setHtmlContent(builder2).build();
        }
    }

    private static void addHtmlForIssue164378(@NotNull Throwable throwable, Module module2, HtmlLinkManager linkManager, HtmlBuilder builder2, boolean addShowExceptionLink) {
        builder2.add("Rendering failed with a known bug. ");
        if (module2 == null) {
            builder2.add("Please rebuild the project and then clear the cache by clicking the refresh icon above the preview.").newline();
            return;
        }
        builder2.addLink("Please try a ", "rebuild", ".", linkManager.createBuildProjectUrl());
        builder2.newline().newline();
        if (!addShowExceptionLink) {
            return;
        }
        ShowExceptionFix showExceptionFix = new ShowExceptionFix(module2.getProject(), throwable);
        builder2.addLink("Show Exception", linkManager.createRunnableLink(showExceptionFix));
    }

    @VisibleForTesting
    public void performClick(@NotNull RenderResult result2, @NotNull String url) {
        Module module2 = result2.getModule();
        PsiFile file2 = result2.getFile();
        this.myLinkManager.handleUrl(url, module2, file2, this.myDataContext, result2, this.myDesignSurface);
    }

    private void reportRelevantCompilationErrors(@NotNull RenderLogger logger2, @NotNull RenderTask renderTask) {
        boolean hasJavaErrors;
        Module module2 = logger2.getModule();
        if (module2 == null) {
            return;
        }
        Project project = module2.getProject();
        WolfTheProblemSolver wolfgang = WolfTheProblemSolver.getInstance((Project)project);
        if (!wolfgang.hasProblemFilesBeneath(module2)) {
            return;
        }
        HtmlBuilder builder2 = new HtmlBuilder();
        String summary = null;
        if (logger2.seenTagPrefix("resources.")) {
            boolean haveResourceErrors = wolfgang.hasProblemFilesBeneath(virtualFile -> virtualFile.getFileType() == XmlFileType.INSTANCE);
            if (haveResourceErrors) {
                summary = "Resource errors";
                builder2.addBold("This project contains resource errors, so aapt did not succeed, which can cause rendering failures. Fix resource problems first.").newline().newline();
            }
        } else if (renderTask.getLayoutlibCallback().isUsed() && (hasJavaErrors = wolfgang.hasProblemFilesBeneath(virtualFile -> virtualFile.getFileType() == JavaFileType.INSTANCE))) {
            summary = "Compilation errors";
            builder2.addBold("This project contains Java compilation errors, which can cause rendering failures for custom views. Fix compilation problems first.").newline().newline();
        }
        if (summary == null) {
            return;
        }
        this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary(summary).setHtmlContent(builder2).build();
    }

    private boolean reportSandboxError(@NotNull Throwable throwable, boolean newlineBefore, boolean newlineAfter) {
        if (!(throwable instanceof SecurityException)) {
            return false;
        }
        HtmlBuilder builder2 = new HtmlBuilder();
        if (newlineBefore) {
            builder2.newline();
        }
        builder2.addLink("Turn off custom view rendering sandbox", this.myLinkManager.createDisableSandboxUrl());
        String lastFailedPath = RenderSecurityManager.getLastFailedPath();
        if (lastFailedPath != null) {
            builder2.newline().newline().add("Diagnostic info for Studio bug report:").newline().add("Failed path: ").add(lastFailedPath).newline();
            String tempDir = System.getProperty("java.io.tmpdir");
            builder2.add("Normal temp dir: ").add(tempDir).newline();
            File normalized = new File(tempDir);
            builder2.add("Normalized temp dir: ").add(normalized.getPath()).newline();
            try {
                builder2.add("Canonical temp dir: ").add(normalized.getCanonicalPath()).newline();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            builder2.add("os.name: ").add(SystemInfo.OS_NAME).newline().add("os.version: ").add(SystemInfo.OS_VERSION).newline().add("java.runtime.version: ").add(SystemInfo.JAVA_RUNTIME_VERSION);
        }
        if (newlineAfter) {
            builder2.newline().newline();
        }
        this.reportThrowable(builder2, throwable, false);
        this.addRefreshAction(builder2);
        this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("Rendering sandbox error").setHtmlContent(builder2).build();
        return true;
    }

    private boolean reportThrowable(@NotNull HtmlBuilder builder2, @NotNull Throwable throwable, boolean hideIfIrrelevant) {
        StackTraceElement frame;
        int i2;
        StackTraceElement[] frames = throwable.getStackTrace();
        int end = -1;
        boolean haveInterestingFrame = false;
        for (i2 = 0; i2 < frames.length; ++i2) {
            String className2;
            frame = frames[i2];
            if (RenderErrorContributor.isInterestingFrame(frame)) {
                haveInterestingFrame = true;
            }
            if (!(className2 = frame.getClassName()).equals(RENDER_SESSION_IMPL_FQCN)) continue;
            end = i2;
            break;
        }
        if (end == -1 || !haveInterestingFrame) {
            if (hideIfIrrelevant) {
                return true;
            }
            block1: for (i2 = 0; i2 < frames.length; ++i2) {
                frame = frames[i2];
                if (RenderErrorContributor.isVisible(frame)) continue;
                end = i2;
                if (end != 0) break;
                for (int j = 0; j < frames.length; ++j) {
                    frame = frames[j];
                    String className3 = frame.getClassName();
                    if (!className3.equals(RENDER_SESSION_IMPL_FQCN)) continue;
                    end = j;
                    break block1;
                }
                break;
            }
        }
        builder2.addHtml(StringUtil.replace((String)throwable.toString(), (String)"\n", (String)"<BR/>")).newline();
        boolean wasHidden = false;
        int indent = 2;
        File platformSource = null;
        boolean platformSourceExists = true;
        for (int i3 = 0; i3 < end; ++i3) {
            String url;
            StackTraceElement frame2 = frames[i3];
            if (RenderErrorContributor.isHiddenFrame(frame2)) {
                wasHidden = true;
                continue;
            }
            String className4 = frame2.getClassName();
            String methodName = frame2.getMethodName();
            builder2.addNbsps(indent);
            builder2.add("at ").add(className4).add(".").add(methodName);
            String fileName = frame2.getFileName();
            if (fileName == null || fileName.isEmpty()) continue;
            int lineNumber = frame2.getLineNumber();
            String location = fileName + ':' + lineNumber;
            if (RenderErrorContributor.isInterestingFrame(frame2)) {
                if (wasHidden) {
                    builder2.addNbsps(indent).add("    ...").newline();
                    wasHidden = false;
                }
                url = this.myLinkManager.createOpenStackUrl(className4, methodName, fileName, lineNumber);
                builder2.add("(").addLink(location, url).add(")");
            } else {
                url = null;
                if (RenderErrorContributor.isFramework(frame2) && platformSourceExists) {
                    if (platformSource == null) {
                        IAndroidTarget target = this.myResult.getRenderTask() != null ? this.myResult.getRenderTask().getContext().getConfiguration().getRealTarget() : null;
                        platformSource = target != null ? AndroidSdks.getInstance().findPlatformSources(target) : null;
                        boolean bl = platformSourceExists = platformSource != null;
                    }
                    if (platformSourceExists) {
                        File parentFile;
                        File classFile = new File(platformSource, frame2.getClassName().replace('.', File.separatorChar) + ".java");
                        if (!classFile.exists() && !(classFile = new File((parentFile = classFile.getParentFile()).getParentFile(), parentFile.getName() + ".java")).exists()) {
                            classFile = null;
                        }
                        if (classFile != null) {
                            url = HtmlLinkManager.createFilePositionUrl(classFile, lineNumber, 0);
                        }
                    }
                }
                if (url != null) {
                    builder2.add("(").addLink(location, url).add(")");
                } else {
                    builder2.add("(").add(location).add(")");
                }
            }
            builder2.newline();
        }
        builder2.addLink("Copy stack to clipboard", this.myLinkManager.createRunnableLink(() -> {
            String text2 = Throwables.getStackTraceAsString((Throwable)throwable);
            try {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text2));
                HtmlLinkManager.showNotification("Stack trace copied to clipboard");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        return false;
    }

    private void addRefreshAction(@NotNull HtmlBuilder builder2) {
        builder2.newlineIfNecessary().newline().addIcon(HtmlBuilderHelper.getRefreshIconPath()).addLink("Tip: Try to ", "refresh", " the layout.", this.myLinkManager.createRefreshRenderUrl()).newline();
    }

    private void reportRtlNotEnabled(@NotNull RenderLogger logger2, @Nullable RenderTask task2) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Application application;
            Project project = logger2.getProject();
            if (project == null || project.isDisposed()) {
                return;
            }
            Module module2 = logger2.getModule();
            if (module2 == null) {
                return;
            }
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
            Manifest manifest = facet2 != null ? Manifest.getMainManifest(facet2) : null;
            Application application2 = application = manifest != null ? manifest.getApplication() : null;
            if (application == null) {
                return;
            }
            XmlTag applicationTag = application.getXmlTag();
            if (applicationTag == null) {
                return;
            }
            HtmlBuilder builder2 = new HtmlBuilder();
            builder2.add("(").addLink("Add android:supportsRtl=\"true\" to the manifest", logger2.getLinkManager().createRunnableLink(() -> {
                new SetAttributeFix(project, applicationTag, "supportsRtl", "http://schemas.android.com/apk/res/android", "true").execute();
                if (this.myDesignSurface != null) {
                    this.myDesignSurface.forceUserRequestedRefresh();
                }
            })).add(")");
            this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("RTL support requires android:supportsRtl=\"true\" in the manifest").setHtmlContent(builder2).build();
        });
    }

    private void reportTagResourceFormat(@NotNull RenderResult result2, @NotNull RenderProblem message2) {
        String[] values2;
        Object clientData = message2.getClientData();
        if (!(clientData instanceof String[])) {
            return;
        }
        String[] strings = (String[])clientData;
        if (strings.length != 2) {
            return;
        }
        RenderTask renderTask = result2.getRenderTask();
        if (renderTask == null) {
            return;
        }
        IAndroidTarget target = renderTask.getContext().getConfiguration().getRealTarget();
        if (target == null) {
            return;
        }
        AndroidPlatform platform = renderTask.getContext().getPlatform();
        if (platform == null) {
            return;
        }
        AndroidTargetData targetData = platform.getSdkData().getTargetData(target);
        AttributeDefinitions definitionLookup = targetData.getPublicAttrDefs(result2.getFile().getProject());
        String attributeName = strings[0];
        String currentValue = strings[1];
        AttributeDefinition definition = definitionLookup.getAttrDefByName(attributeName);
        if (definition == null) {
            return;
        }
        Set<AttributeFormat> formats = definition.getFormats();
        if ((formats.contains(AttributeFormat.FLAGS) || formats.contains(AttributeFormat.ENUM)) && (values2 = definition.getValues()).length > 0) {
            HtmlBuilder builder2 = new HtmlBuilder();
            builder2.add("Change ").add(currentValue).add(" to: ");
            boolean first = true;
            for (String value2 : values2) {
                if (first) {
                    first = false;
                } else {
                    builder2.add(", ");
                }
                builder2.addLink(value2, this.myLinkManager.createReplaceAttributeValueUrl(attributeName, currentValue, value2));
            }
            this.addRefreshAction(builder2);
            this.addIssue().setSummary("Incorrect resource value format").setHtmlContent(builder2).build();
        }
    }

    private void reportOtherProblems(@NotNull RenderLogger logger2, RenderTask task2) {
        List<RenderProblem> messages = logger2.getMessages();
        if (messages.isEmpty()) {
            return;
        }
        HashSet seenTags = Sets.newHashSet();
        for (RenderProblem message2 : messages) {
            String tag = message2.getTag();
            if (tag != null && seenTags.contains(tag)) continue;
            seenTags.add(tag);
            if (tag != null) {
                if ("resources.format".equals(tag)) {
                    this.reportTagResourceFormat(this.myResult, message2);
                    continue;
                }
                if ("rtl-not-enabled".equals(tag)) {
                    this.reportRtlNotEnabled(logger2, task2);
                    continue;
                }
                if ("rtl-not-supported".equals(tag)) {
                    this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("RTL support requires API level >= 17").setHtmlContent(new HtmlBuilder().addHtml(message2.getHtml())).build();
                    continue;
                }
            }
            HtmlBuilder builder2 = new HtmlBuilder();
            String html = message2.getHtml();
            Throwable throwable = message2.getThrowable();
            String summary = "Render problem";
            if (throwable != null) {
                if (this.reportSandboxError(throwable, false, true)) continue;
                if (this.reportThrowable(builder2, throwable, !html.isEmpty() || !message2.isDefaultHtml())) {
                    if (!html.isEmpty()) {
                        builder2.getStringBuilder().append(html);
                        builder2.newlineIfNecessary();
                    }
                    summary = throwable.getLocalizedMessage() != null ? throwable.getLocalizedMessage() : summary;
                }
            } else {
                if (html.contains("has been edited more recently")) {
                    summary = "Build out-of-date";
                }
                builder2.getStringBuilder().append(html);
                builder2.newlineIfNecessary();
            }
            this.addRefreshAction(builder2);
            this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary(summary).setHtmlContent(builder2).build();
        }
    }

    private boolean addTypoSuggestions(@NotNull HtmlBuilder builder2, @NotNull String actual, @Nullable Collection<String> views2, boolean compareWithPackage) {
        if (views2 == null || views2.isEmpty()) {
            return false;
        }
        String actualBase = actual.substring(actual.lastIndexOf(46) + 1);
        String match2 = compareWithPackage ? actual : actualBase;
        int maxDistance = actualBase.length() >= 4 ? 2 : 1;
        for (String suggested : views2) {
            String matchWith;
            String suggestedBase = suggested.substring(suggested.lastIndexOf(46) + 1);
            String string = matchWith = compareWithPackage ? suggested : suggestedBase;
            if (Math.abs(actualBase.length() - suggestedBase.length()) > maxDistance) continue;
            boolean sameBase = actualBase.equals(suggestedBase);
            if (!compareWithPackage && sameBase) continue;
            if (compareWithPackage) {
                if (!sameBase) continue;
                if (actualBase.equals(actual) && !actualBase.equals(suggested) && IdeResourcesUtil.isViewPackageNeeded(suggested, -1)) {
                    builder2.addLink(String.format("Change to %1$s", suggested), this.myLinkManager.createReplaceTagsUrl(actual, suggested));
                    builder2.add(", ");
                    continue;
                }
            }
            if (compareWithPackage && Math.abs(match2.length() - matchWith.length()) > maxDistance) continue;
            if (match2.equals(matchWith)) {
                return true;
            }
            if (Lint.editDistance((String)match2, (String)matchWith, (int)(maxDistance + 1)) > maxDistance) continue;
            String labelClass = suggestedBase.equals(actual) || actual.indexOf(46) != -1 ? suggested : suggestedBase;
            builder2.addLink(String.format("Change to %1$s", labelClass), this.myLinkManager.createReplaceTagsUrl(actual, IdeResourcesUtil.isViewPackageNeeded(suggested, -1) ? suggested : suggestedBase));
            builder2.add(", ");
        }
        return false;
    }

    private void reportRenderingFidelityProblems(@NotNull RenderLogger logger2) {
        List<RenderProblem> fidelityWarnings = logger2.getFidelityWarnings();
        if (fidelityWarnings.isEmpty()) {
            return;
        }
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.add("The graphics preview in the layout editor may not be accurate:").newline();
        builder2.beginList();
        int count = 0;
        for (RenderProblem warning : fidelityWarnings) {
            int remaining;
            builder2.listItem();
            warning.appendHtml(builder2.getStringBuilder());
            Object clientData = warning.getClientData();
            if (clientData != null) {
                builder2.addLink(" (Ignore for this session)", this.myLinkManager.createRunnableLink(() -> {
                    RenderLogger.ignoreFidelityWarning(clientData);
                    if (this.myDesignSurface != null) {
                        this.myDesignSurface.forceUserRequestedRefresh();
                    }
                }));
            }
            builder2.newline();
            if (++count != 3 || (remaining = fidelityWarnings.size() - count) <= 0) continue;
            builder2.add("(").addHtml(Integer.toString(remaining)).add(" additional render fidelity issues hidden)");
            break;
        }
        builder2.endList();
        builder2.addLink("Ignore all fidelity warnings for this session", this.myLinkManager.createRunnableLink(() -> {
            RenderLogger.ignoreAllFidelityWarnings();
            if (this.myDesignSurface != null) {
                this.myDesignSurface.forceUserRequestedRefresh();
            }
        }));
        builder2.newline();
        this.addIssue().setSeverity(HighlightSeverity.WEAK_WARNING).setSummary("Layout fidelity warning").setHtmlContent(builder2).build();
    }

    private void reportMissingClasses(@NotNull RenderLogger logger2) {
        Set<String> missingClasses = logger2.getMissingClasses();
        if (missingClasses.isEmpty()) {
            return;
        }
        HtmlBuilder builder2 = new HtmlBuilder();
        if (missingClasses.contains("CalendarView")) {
            builder2.add("The ").addBold("CalendarView").add(" widget does not work correctly with this render target. As a workaround, try using the API 15 (Android 4.0.3) render target library by selecting it from the toolbar menu above.");
            if (missingClasses.size() == 1) {
                this.addIssue().setSeverity(HighlightSeverity.WARNING).setSummary("CalendarView does not work correctly with this render target").setHtmlContent(builder2).build();
                return;
            }
        }
        boolean missingResourceClass = logger2.isMissingResourceClass() && logger2.getResourceClass() != null && logger2.hasLoadedClasses();
        builder2.add("The following classes could not be found:");
        builder2.beginList();
        ArrayList customViews = null;
        ArrayList androidViewClassNames = null;
        Module module2 = logger2.getModule();
        if (module2 != null) {
            Ref viewsRef = new Ref(Collections.emptyList());
            ProgressIndicatorUtils.runWithWriteActionPriority(() -> viewsRef.set(RenderErrorContributor.getAllViews(module2)), (ProgressIndicator)new EmptyProgressIndicator());
            Collection views2 = (Collection)viewsRef.get();
            if (!views2.isEmpty()) {
                customViews = Lists.newArrayListWithExpectedSize((int)Math.max(10, views2.size() - 80));
                androidViewClassNames = Lists.newArrayListWithExpectedSize((int)views2.size());
                for (String fqcn : views2) {
                    if (fqcn.startsWith("android.") && !IdeResourcesUtil.isViewPackageNeeded(fqcn, -1)) {
                        androidViewClassNames.add(fqcn);
                        continue;
                    }
                    customViews.add(fqcn);
                }
            }
        }
        if (missingResourceClass) {
            builder2.listItem();
            builder2.add(logger2.getResourceClass());
        }
        boolean foundCustomView = false;
        for (String className2 : missingClasses) {
            builder2.listItem();
            builder2.add(className2);
            builder2.add(" (");
            foundCustomView |= this.addTypoSuggestions(builder2, className2, customViews, false);
            this.addTypoSuggestions(builder2, className2, customViews, true);
            this.addTypoSuggestions(builder2, className2, androidViewClassNames, false);
            if (this.myLinkManager == null) {
                return;
            }
            if (SdkConstants.CLASS_CONSTRAINT_LAYOUT.isEquals(className2)) {
                builder2.newline().addNbsps(3);
                Project project = logger2.getProject();
                boolean useAndroidX = project == null || MigrateToAndroidxUtil.isAndroidx(project);
                GoogleMavenArtifactId artifact = useAndroidX ? GoogleMavenArtifactId.ANDROIDX_CONSTRAINT_LAYOUT : GoogleMavenArtifactId.CONSTRAINT_LAYOUT;
                builder2.addLink("Add constraint-layout library dependency to the project", this.myLinkManager.createAddDependencyUrl(artifact));
                builder2.add(", ");
            }
            if ("com.google.android.flexbox.FlexboxLayout".equals(className2)) {
                builder2.newline().addNbsps(3);
                builder2.addLink("Add flexbox layout library dependency to the project", this.myLinkManager.createAddDependencyUrl(GoogleMavenArtifactId.FLEXBOX_LAYOUT));
                builder2.add(", ");
            }
            builder2.addLink("Fix Build Path", this.myLinkManager.createEditClassPathUrl());
            builder2.add(", ");
            builder2.addLink("Edit XML", this.myLinkManager.createShowTagUrl(className2));
            if (className2.indexOf(46) != -1) {
                builder2.add(", ");
                builder2.addLink("Create Class", this.myLinkManager.createNewClassUrl(className2));
            }
            builder2.add(")");
        }
        builder2.endList();
        builder2.addIcon(HtmlBuilderHelper.getTipIconPath());
        builder2.addLink("Tip: Try to ", "build", " the project.", this.myLinkManager.createBuildProjectUrl());
        this.addRefreshAction(builder2);
        if (foundCustomView) {
            builder2.newline().add("One or more missing custom views were found in the project, but does not appear to have been compiled yet.");
        }
        builder2.newline().newline();
        this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("Missing classes").setHtmlContent(builder2).build();
    }

    private void reportBrokenClasses(@NotNull RenderLogger logger2) {
        Map<String, Throwable> brokenClasses = logger2.getBrokenClasses();
        if (brokenClasses.isEmpty()) {
            return;
        }
        HtmlBuilder builder2 = new HtmlBuilder();
        Module module2 = logger2.getModule();
        for (Throwable throwable : brokenClasses.values()) {
            if (!RenderLogger.isIssue164378(throwable)) continue;
            RenderErrorContributor.addHtmlForIssue164378(throwable, module2, this.myLinkManager, builder2, false);
            break;
        }
        builder2.add("The following classes could not be instantiated:");
        boolean listContainsElements = false;
        Throwable firstThrowable = null;
        builder2.beginList();
        for (Map.Entry<String, Throwable> entry : brokenClasses.entrySet()) {
            String className2 = entry.getKey();
            Throwable throwable = entry.getValue();
            if (throwable != null && throwable.getMessage() != null && throwable.getMessage().startsWith(APP_COMPAT_REQUIRED_MSG)) continue;
            listContainsElements = true;
            builder2.listItem().add(className2).add(" (").addLink("Open Class", this.myLinkManager.createOpenClassUrl(className2));
            if (throwable != null && module2 != null) {
                builder2.add(", ");
                ShowExceptionFix detailsFix = new ShowExceptionFix(module2.getProject(), throwable);
                builder2.addLink("Show Exception", this.myLinkManager.createRunnableLink(detailsFix));
            }
            builder2.add(", ").addLink("Clear Cache", this.myLinkManager.createClearCacheUrl()).add(")");
            if (firstThrowable != null || throwable == null) continue;
            firstThrowable = throwable;
        }
        if (!listContainsElements) {
            return;
        }
        builder2.endList().addIcon(HtmlBuilderHelper.getTipIconPath()).addLink("Tip: Use ", "View.isInEditMode()", " in your custom views to skip code or show sample data when shown in the IDE.", "http://developer.android.com/reference/android/view/View.html#isInEditMode()").newline().newline().add("If this is an unexpected error you can also try to ").addLink("", "build the project", ", then ", this.myLinkManager.createBuildProjectUrl()).addLink("manually ", "refresh the layout", ".", this.myLinkManager.createRefreshRenderUrl());
        if (firstThrowable != null) {
            builder2.newline().newline().addHeading("Exception Details", HtmlBuilderHelper.getHeaderFontColor()).newline();
            this.reportThrowable(builder2, firstThrowable, false);
            this.reportSandboxError(firstThrowable, true, false);
        }
        builder2.newline().newline();
        this.addIssue().setSeverity(HighlightSeverity.ERROR, 100).setSummary("Failed to instantiate one or more classes").setHtmlContent(builder2).build();
    }

    private void reportInstantiationProblems(@NotNull RenderLogger logger2) {
        AndroidFacet facet2;
        Map<String, Throwable> classesWithIncorrectFormat = logger2.getClassesWithIncorrectFormat();
        if (classesWithIncorrectFormat.isEmpty()) {
            return;
        }
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.add("Preview might be incorrect: unsupported class version.").newline().addIcon(HtmlBuilderHelper.getTipIconPath()).add("Tip: ");
        builder2.add("You need to run the IDE with the highest JDK version that you are compiling custom views with. ");
        int highest = ClassConverter.findHighestMajorVersion(classesWithIncorrectFormat.values());
        if (highest > 0 && highest > ClassConverter.getCurrentClassVersion()) {
            String required = ClassConverter.classVersionToJdk(highest);
            builder2.add("One or more views have been compiled with JDK ").add(required).add(", but you are running the IDE on JDK ").add(ClassConverter.getCurrentJdkVersion()).add(". ");
        } else {
            builder2.add("For example, if you are compiling with sourceCompatibility 1.7, you must run the IDE with JDK 1.7. ");
        }
        builder2.add("Running on a higher JDK is necessary such that these classes can be run in the layout renderer. (Or, extract your custom views into a library which you compile with a lower JDK version.)").newline().newline().addLink("If you have just accidentally built your code with a later JDK, try to ", "build", " the project.", this.myLinkManager.createBuildProjectUrl()).newline().newline().add("Classes with incompatible format:");
        builder2.beginList();
        ArrayList names = Lists.newArrayList(classesWithIncorrectFormat.keySet());
        Collections.sort(names);
        for (String className2 : names) {
            builder2.listItem();
            builder2.add(className2);
            Throwable throwable = classesWithIncorrectFormat.get(className2);
            if (!(throwable instanceof InconvertibleClassError)) continue;
            InconvertibleClassError error = (InconvertibleClassError)throwable;
            builder2.add(" (Compiled with ").add(ClassConverter.classVersionToJdk(error.getMajor())).add(")");
        }
        builder2.endList();
        Module module2 = logger2.getModule();
        if (module2 == null) {
            return;
        }
        List<Module> problemModules = RenderErrorContributor.getProblemModules(module2);
        if (!problemModules.isEmpty()) {
            builder2.add("The following modules are built with incompatible JDK:").newline();
            Iterator<Module> it = problemModules.iterator();
            while (it.hasNext()) {
                Module problemModule = it.next();
                builder2.add(problemModule.getName());
                if (!it.hasNext()) continue;
                builder2.add(", ");
            }
            builder2.newline();
        }
        if ((facet2 = AndroidFacet.getInstance((Module)logger2.getModule())) != null && !AndroidModel.isRequired(facet2)) {
            Project project = logger2.getModule().getProject();
            builder2.addLink("Rebuild project with '-target 1.6'", this.myLinkManager.createRunnableLink(new RebuildWith16Fix(project))).newline();
            if (!problemModules.isEmpty()) {
                builder2.addLink("Change Java SDK to 1.6", this.myLinkManager.createRunnableLink(new SwitchTo16Fix(project, problemModules))).newline();
            }
        }
        this.addIssue().setSeverity(HighlightSeverity.WARNING).setSummary("Some classes have an unsupported version").setHtmlContent(builder2).build();
    }

    private void reportUnknownFragments(@NotNull RenderLogger logger2) {
        List<String> fragmentNames = logger2.getMissingFragments();
        if (fragmentNames == null || fragmentNames.isEmpty()) {
            return;
        }
        String fragmentTagName = MigrateToAndroidxUtil.isAndroidx(logger2.getProject()) ? "androidx.fragment.app.FragmentContainerView" : "fragment";
        String fragmentTagDisplayName = "<" + fragmentTagName + ">";
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.add("A ").addHtml("<code>").add(fragmentTagDisplayName).addHtml("</code>").add(" tag allows a layout file to dynamically include different layouts at runtime. ").add("At layout editing time the specific layout to be used is not known. You can choose which layout you would like previewed while editing the layout.");
        builder2.beginList();
        for (String className2 : fragmentNames) {
            boolean isActivityKnown;
            builder2.listItem();
            boolean isIdentified = className2 != null && !className2.isEmpty();
            boolean bl = isActivityKnown = isIdentified && !className2.startsWith("@");
            if (isIdentified) {
                builder2.add("<").add(fragmentTagName).add(" ").addBold(className2).add(" ...>");
            } else {
                builder2.add(fragmentTagDisplayName);
            }
            builder2.add(" (");
            if (isActivityKnown) {
                Module module2 = logger2.getModule();
                ApplicationManager.getApplication().runReadAction(() -> {
                    assert (module2 != null);
                    Project project = module2.getProject();
                    GlobalSearchScope scope2 = GlobalSearchScope.allScope((Project)project);
                    PsiClass clz = DumbService.getInstance((Project)project).isDumb() ? null : JavaPsiFacade.getInstance((Project)project).findClass(className2, scope2);
                    String layoutName = this.myResult.getFile().getName();
                    boolean separate = false;
                    if (clz != null) {
                        String matchText = clz.getText();
                        Pattern LAYOUT_FIELD_PATTERN = Pattern.compile("R\\.layout\\.([a-z0-9_]+)");
                        Matcher matcher = LAYOUT_FIELD_PATTERN.matcher(matchText);
                        TreeSet layouts = Sets.newTreeSet();
                        int index2 = 0;
                        while (matcher.find(index2)) {
                            layouts.add(matcher.group(1));
                            index2 = matcher.end();
                        }
                        for (String layout2 : layouts) {
                            if (layout2.equals(layoutName)) continue;
                            if (separate) {
                                builder2.add(", ");
                            }
                            builder2.addLink("Use @layout/" + layout2, this.myLinkManager.createAssignLayoutUrl(className2, layout2));
                            separate = true;
                        }
                    }
                    if (separate) {
                        builder2.add(", ");
                    }
                    builder2.addLink("Pick Layout...", this.myLinkManager.createPickLayoutUrl(className2));
                });
            } else {
                builder2.addLink("Choose Fragment Class...", this.myLinkManager.createAssignFragmentUrl(className2));
            }
            builder2.add(")");
        }
        builder2.endList().newline().addLink("Do not warn about " + fragmentTagDisplayName + " tags in this session", this.myLinkManager.createIgnoreFragmentsUrl()).newline();
        this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("Unknown fragments").setHtmlContent(builder2).build();
    }

    private void reportAppCompatRequired(@NotNull RenderLogger logger2) {
        Map<String, Throwable> brokenClasses = logger2.getBrokenClasses();
        if (brokenClasses.isEmpty()) {
            return;
        }
        brokenClasses.values().stream().filter(Objects::nonNull).filter(t -> t.getMessage() != null && t.getMessage().startsWith(APP_COMPAT_REQUIRED_MSG)).findAny().ifPresent(t -> this.addIssue().setSeverity(HighlightSeverity.ERROR, 101).setSummary("Using the design library requires using Theme.AppCompat or a descendant").setHtmlContent(new HtmlBuilder().add("Select ").addItalic("Theme.AppCompat").add(" or a descendant in the theme selector.")).build());
    }

    public Collection<RenderErrorModel.Issue> reportIssues() {
        RenderLogger logger2 = this.myResult.getLogger();
        RenderTask renderTask = this.myResult.getRenderTask();
        this.reportMissingStyles(logger2);
        this.reportAppCompatRequired(logger2);
        if (renderTask != null) {
            this.reportRelevantCompilationErrors(logger2, renderTask);
            this.reportMissingSizeAttributes(logger2, renderTask.getContext(), renderTask.getXmlFile());
            this.reportMissingClasses(logger2);
        }
        this.reportBrokenClasses(logger2);
        this.reportInstantiationProblems(logger2);
        this.reportOtherProblems(logger2, renderTask);
        this.reportUnknownFragments(logger2);
        this.reportRenderingFidelityProblems(logger2);
        return this.getIssues();
    }

    protected RenderResult getResult() {
        return this.myResult;
    }

    protected HtmlLinkManager getLinkManager() {
        return this.myLinkManager;
    }

    protected Collection<RenderErrorModel.Issue> getIssues() {
        return Collections.unmodifiableCollection(this.myIssues);
    }

    public static class Provider {
        public static final ExtensionPointName<Provider> EP_NAME = new ExtensionPointName("com.android.rendering.renderErrorContributor");

        public boolean isApplicable(Project project) {
            return true;
        }

        public RenderErrorContributor getContributor(@Nullable EditorDesignSurface surface2, @NotNull RenderResult result2, @Nullable DataContext dataContext) {
            return new RenderErrorContributor(surface2, result2, dataContext);
        }
    }

    private static class SwitchTo16Fix
    implements Runnable {
        final List<Module> myProblemModules;
        private final Project myProject;

        private SwitchTo16Fix(Project project, List<Module> problemModules) {
            this.myProject = project;
            this.myProblemModules = problemModules;
        }

        @Override
        public void run() {
            String moduleToSelect;
            Sdk sdk;
            Set sdkNames = RenderErrorContributor.getSdkNamesFromModules(this.myProblemModules);
            if (sdkNames.size() == 1 && (sdk = ProjectJdkTable.getInstance().findJdk((String)sdkNames.iterator().next())) != null && sdk.getSdkType() instanceof AndroidSdkType) {
                ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance((Project)this.myProject);
                if (ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, () -> config.select(sdk, true))) {
                    RenderErrorContributor.askAndRebuild(this.myProject);
                }
                return;
            }
            String string = moduleToSelect = !this.myProblemModules.isEmpty() ? this.myProblemModules.iterator().next().getName() : null;
            if (ModulesConfigurator.showDialog((Project)this.myProject, (String)moduleToSelect, (String)ClasspathEditor.getName())) {
                RenderErrorContributor.askAndRebuild(this.myProject);
            }
        }
    }

    private static class RebuildWith16Fix
    implements Runnable {
        private final Project myProject;

        private RebuildWith16Fix(Project project) {
            this.myProject = project;
        }

        @Override
        public void run() {
            JpsJavaCompilerOptions settings = JavacConfiguration.getOptions((Project)this.myProject, JavacConfiguration.class);
            if (!settings.ADDITIONAL_OPTIONS_STRING.isEmpty()) {
                settings.ADDITIONAL_OPTIONS_STRING = settings.ADDITIONAL_OPTIONS_STRING + ' ';
            }
            settings.ADDITIONAL_OPTIONS_STRING = settings.ADDITIONAL_OPTIONS_STRING + "-target 1.6";
            CompilerManager.getInstance((Project)this.myProject).rebuild(null);
        }
    }
}

