/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.capture;

import com.android.ddmlib.Client;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.profiling.capture.AsyncWriterDelegate;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureHandle;
import com.android.tools.idea.profiling.capture.CaptureType;
import com.android.tools.idea.profiling.capture.CaptureTypeService;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.EdtExecutorService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureService {
    public static final String FD_CAPTURES = "captures";
    private static final String TEMP_FILE_EXTENSION = ".temp";
    @NotNull
    private final Project myProject;
    @NotNull
    private Multimap<CaptureType, Capture> myCaptures;
    private List<CaptureListener> myListeners;
    @Nullable
    private AsyncWriterDelegate myAsyncWriterDelegate;
    @NotNull
    private Set<CaptureHandle> myOpenCaptureHandles;

    public CaptureService(@NotNull Project project) {
        this.myProject = project;
        this.myCaptures = LinkedListMultimap.create();
        this.myListeners = new LinkedList<CaptureListener>();
        this.myOpenCaptureHandles = new HashSet<CaptureHandle>();
        this.update();
    }

    @NotNull
    public static CaptureService getInstance(@NotNull Project project) {
        return (CaptureService)ServiceManager.getService((Project)project, CaptureService.class);
    }

    private static Set<VirtualFile> findCaptureFiles(@NotNull VirtualFile[] files2, @NotNull CaptureType type) {
        HashSet<VirtualFile> set = new HashSet<VirtualFile>();
        for (VirtualFile file2 : files2) {
            if (!type.isValidCapture(file2)) continue;
            set.add(file2);
        }
        return set;
    }

    @NotNull
    public String getSuggestedName(@Nullable Client client) {
        return this.getSuggestedName(client, "yyyy.MM.dd_HH.mm");
    }

    public String getSuggestedName(@Nullable Client client, @NotNull String format2) {
        String name;
        String timestamp = new SimpleDateFormat(format2).format(new Date());
        String suggestedName = null;
        if (client != null && (name = client.getClientData().getClientDescription()) != null && !name.isEmpty()) {
            suggestedName = name + "_" + timestamp;
        }
        if (suggestedName == null) {
            suggestedName = this.myProject.getName() + "_" + timestamp;
        }
        return suggestedName.replaceAll("[^._A-Za-z0-9]", "");
    }

    public void update() {
        CaptureTypeService service = CaptureTypeService.getInstance();
        VirtualFile dir = this.getCapturesDirectory();
        LinkedListMultimap updated = LinkedListMultimap.create();
        if (dir != null) {
            VirtualFile[] children = VfsUtil.getChildren((VirtualFile)dir);
            for (CaptureType type : service.getCaptureTypes()) {
                Set<VirtualFile> files2 = CaptureService.findCaptureFiles(children, type);
                for (Capture capture2 : this.myCaptures.get((Object)type)) {
                    if (!files2.remove(capture2.getFile())) continue;
                    updated.put((Object)type, (Object)capture2);
                }
                for (VirtualFile newFile : files2) {
                    updated.put((Object)type, (Object)type.createCapture(newFile));
                }
            }
        }
        this.myCaptures = updated;
    }

    @NotNull
    public VirtualFile createCapturesDirectory() throws IOException {
        assert (this.myProject.getBasePath() != null);
        VirtualFile projectDir = LocalFileSystem.getInstance().findFileByPath(this.myProject.getBasePath());
        if (projectDir != null) {
            VirtualFile dir = projectDir.findChild(FD_CAPTURES);
            if (dir == null) {
                dir = projectDir.createChildDirectory(null, FD_CAPTURES);
            }
            return dir;
        }
        throw new IOException("Unable to create the captures directory: Project directory not found.");
    }

    @Nullable
    public VirtualFile getCapturesDirectory() {
        assert (this.myProject.getBasePath() != null);
        VirtualFile projectDir = LocalFileSystem.getInstance().findFileByPath(this.myProject.getBasePath());
        return projectDir != null ? projectDir.findChild(FD_CAPTURES) : null;
    }

    @NotNull
    public Multimap<CaptureType, Capture> getCapturesByType() {
        return this.myCaptures;
    }

    @NotNull
    public Collection<Capture> getCaptures() {
        return this.myCaptures.values();
    }

    @NotNull
    public Collection<CaptureType> getTypes() {
        return this.myCaptures.keySet();
    }

    public CaptureHandle startCaptureFile(@NotNull Class<? extends CaptureType> clazz, @NotNull String name, boolean hideFileUntilFinalized) throws IOException {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myAsyncWriterDelegate == null) {
            this.myAsyncWriterDelegate = new AsyncWriterDelegate();
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)this.myAsyncWriterDelegate);
        }
        CaptureHandle handle = this.startCaptureFileSynchronous(clazz, name, hideFileUntilFinalized);
        this.myOpenCaptureHandles.add(handle);
        return handle;
    }

    public void appendDataCopy(@NotNull CaptureHandle captureHandle, @NotNull byte[] data) throws IOException {
        try {
            assert (this.myAsyncWriterDelegate != null);
            this.myAsyncWriterDelegate.queueWrite(captureHandle, Arrays.copyOf(data, data.length));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void appendData(@NotNull CaptureHandle captureHandle, @NotNull byte[] data) throws IOException {
        try {
            assert (this.myAsyncWriterDelegate != null);
            this.myAsyncWriterDelegate.queueWrite(captureHandle, data);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void cancelCaptureFile(final @NotNull CaptureHandle captureHandle) {
        this.finalizeCaptureFileAsynchronous(captureHandle, new FutureCallback<Capture>(){

            public void onSuccess(@Nullable Capture result2) {
                CaptureService.this.deleteBackingFile(captureHandle, result2);
            }

            public void onFailure(@NotNull Throwable ignored) {
                captureHandle.getFile().delete();
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    @VisibleForTesting
    void cancelCaptureFileSynchronous(@NotNull CaptureHandle captureHandle) throws InterruptedException, IOException {
        Capture capture2 = this.finalizeCaptureFileSynchronous(captureHandle);
        this.deleteBackingFile(captureHandle, capture2);
    }

    @VisibleForTesting
    @NotNull
    Capture finalizeCaptureFileSynchronous(@NotNull CaptureHandle captureHandle) throws InterruptedException, IOException {
        final CountDownLatch latch = new CountDownLatch(1);
        this.closeCaptureFileInternal(captureHandle, new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        latch.await();
        return this.createCapture(captureHandle);
    }

    public void finalizeCaptureFileAsynchronous(final @NotNull CaptureHandle captureHandle, @Nullable FutureCallback<Capture> onCompletion, @Nullable Executor executor) {
        final ListenableFutureTask postCloseTask = ListenableFutureTask.create((Callable)new Callable<Capture>(){

            @Override
            public Capture call() throws Exception {
                ApplicationManager.getApplication().assertIsDispatchThread();
                if (captureHandle.getWriteToTempFile()) {
                    ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<Object, IOException>(){

                        public Object compute() throws IOException {
                            String tempFilePath = captureHandle.getFile().getCanonicalPath();
                            assert (tempFilePath.endsWith(CaptureService.TEMP_FILE_EXTENSION));
                            String originalFilePath = tempFilePath.substring(0, tempFilePath.length() - CaptureService.TEMP_FILE_EXTENSION.length());
                            captureHandle.move(new File(originalFilePath));
                            return null;
                        }
                    });
                }
                return CaptureService.this.createCapture(captureHandle);
            }
        });
        if (onCompletion != null) {
            assert (executor != null);
            Futures.addCallback((ListenableFuture)postCloseTask, onCompletion, (Executor)executor);
        }
        this.closeCaptureFileInternal(captureHandle, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater((Runnable)postCloseTask);
            }
        });
    }

    public boolean captureExists(String name) throws IOException {
        VirtualFile dir = this.createCapturesDirectory();
        return dir.findChild(name) != null;
    }

    private void deleteBackingFile(@NotNull CaptureHandle captureHandle, @Nullable Capture capture2) {
        boolean deleted = false;
        if (capture2 != null) {
            deleted = (Boolean)WriteAction.compute(() -> {
                try {
                    capture2.getFile().delete((Object)this);
                    return true;
                }
                catch (Exception ignored) {
                    return false;
                }
            });
        }
        if (!deleted) {
            captureHandle.getFile().delete();
        }
    }

    private void closeCaptureFileInternal(@NotNull CaptureHandle captureHandle, @NotNull Runnable postCloseTask) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (this.myOpenCaptureHandles.contains(captureHandle));
        assert (captureHandle.isWritable());
        assert (this.myAsyncWriterDelegate != null);
        try {
            this.myAsyncWriterDelegate.closeFileAndRunTaskAsynchronously(captureHandle, postCloseTask);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.myOpenCaptureHandles.remove(captureHandle);
        if (this.myOpenCaptureHandles.isEmpty()) {
            try {
                assert (this.myAsyncWriterDelegate != null);
                this.myAsyncWriterDelegate.queueExit();
                this.myAsyncWriterDelegate = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Capture createCapture(Class<? extends CaptureType> clazz, byte[] data, @NotNull String name) throws IOException {
        CaptureHandle captureHandle = this.startCaptureFileSynchronous(clazz, name, false);
        try {
            CaptureService.appendDataSynchronous(captureHandle, data);
        }
        finally {
            captureHandle.closeFileOutputStream();
        }
        return this.createCapture(captureHandle);
    }

    public void addListener(@NotNull CaptureListener listener2) {
        this.myListeners.add(listener2);
    }

    public void notifyCaptureReady(@NotNull Capture capture2) {
        for (CaptureListener listener2 : this.myListeners) {
            listener2.onReady(capture2);
        }
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(this.myProject, capture2.getFile());
        FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor2, true);
    }

    @NotNull
    private CaptureHandle startCaptureFileSynchronous(@NotNull Class<? extends CaptureType> clazz, final @Nullable String name, final boolean writeToTempFile) throws IOException {
        ApplicationManager.getApplication().assertIsDispatchThread();
        final CaptureType type = CaptureTypeService.getInstance().getType(clazz);
        assert (type != null);
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROFILING).setKind(AndroidStudioEvent.EventKind.PROFILING_CAPTURE).setProfilerCaptureType(type.getCaptureType()), this.myProject));
        File file2 = (File)ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<File, IOException>(){

            public File compute() throws IOException {
                VirtualFile dir = CaptureService.this.createCapturesDirectory();
                String captureFileName = CaptureService.this.getCaptureFileName(name, type.getCaptureExtension(), writeToTempFile);
                File captureFile = new File(dir.createChildData(null, captureFileName).getPath());
                if (writeToTempFile) {
                    captureFile.deleteOnExit();
                }
                return captureFile;
            }
        });
        return new CaptureHandle(file2, type, writeToTempFile);
    }

    @NotNull
    private String getCaptureFileName(@Nullable String name, @NotNull String extension, boolean writeToTempFile) throws IOException {
        String filename = name + extension;
        int i2 = 1;
        while (this.captureExists(filename) || writeToTempFile && this.captureExists(filename + TEMP_FILE_EXTENSION)) {
            filename = String.format(Locale.US, "%s-%d%s", name, i2++, extension);
        }
        return writeToTempFile ? filename + TEMP_FILE_EXTENSION : filename;
    }

    static void appendDataSynchronous(@NotNull CaptureHandle captureHandle, @NotNull byte[] data) throws IOException {
        CaptureService.appendDataSynchronous(captureHandle, data, 0, data.length);
    }

    public static void appendDataSynchronous(@NotNull CaptureHandle captureHandle, @NotNull byte[] data, int offset2, int length) throws IOException {
        FileOutputStream localFileOutputStream = captureHandle.getFileOutputStream();
        assert (localFileOutputStream != null);
        localFileOutputStream.write(data, offset2, length);
    }

    @NotNull
    private Capture createCapture(@NotNull CaptureHandle captureHandle) throws IOException {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!captureHandle.isWritable());
        final File file2 = captureHandle.getFile();
        VirtualFile vf = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return VfsUtil.findFileByIoFile((File)file2, (boolean)true);
            }
        });
        if (vf == null) {
            throw new IOException("Cannot find virtual file for capture file \"" + file2.getPath() + "\"");
        }
        CaptureType type = captureHandle.getCaptureType();
        for (Capture capture2 : this.myCaptures.get((Object)type)) {
            if (!vf.equals(capture2.getFile())) continue;
            return capture2;
        }
        Capture capture3 = type.createCapture(vf);
        this.myCaptures.put((Object)type, (Object)capture3);
        return capture3;
    }

    public static interface CaptureListener {
        public void onReady(Capture var1);
    }
}

