/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.profilingconfig;

import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.profiler.proto.Cpu;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

public class CpuProfilerConfigConverter {
    private CpuProfilerConfigConverter() {
    }

    public static List<Cpu.CpuTraceConfiguration.UserOptions> toProto(List<CpuProfilerConfig> configs, int deviceApi) {
        return ContainerUtil.map(configs, config -> CpuProfilerConfigConverter.toProto(config, deviceApi));
    }

    public static Cpu.CpuTraceConfiguration.UserOptions toProto(CpuProfilerConfig config, int deviceApi) {
        Cpu.CpuTraceConfiguration.UserOptions.Builder protoBuilder = Cpu.CpuTraceConfiguration.UserOptions.newBuilder().setName(config.getName()).setBufferSizeInMb(config.getBufferSizeMb()).setSamplingIntervalUs(config.getSamplingIntervalUs()).setDisableLiveAllocation(config.isDisableLiveAllocation());
        switch (config.getTechnology()) {
            case SAMPLED_JAVA: {
                protoBuilder.setTraceType(Cpu.CpuTraceType.ART);
                protoBuilder.setTraceMode(Cpu.CpuTraceMode.SAMPLED);
                break;
            }
            case INSTRUMENTED_JAVA: {
                protoBuilder.setTraceType(Cpu.CpuTraceType.ART);
                protoBuilder.setTraceMode(Cpu.CpuTraceMode.INSTRUMENTED);
                break;
            }
            case SAMPLED_NATIVE: {
                protoBuilder.setTraceType(Cpu.CpuTraceType.SIMPLEPERF);
                protoBuilder.setTraceMode(Cpu.CpuTraceMode.SAMPLED);
                break;
            }
            case SYSTEM_TRACE: {
                if (deviceApi >= 28) {
                    protoBuilder.setTraceType(Cpu.CpuTraceType.PERFETTO);
                } else {
                    protoBuilder.setTraceType(Cpu.CpuTraceType.ATRACE);
                }
                protoBuilder.setTraceMode(Cpu.CpuTraceMode.INSTRUMENTED);
            }
        }
        return protoBuilder.build();
    }

    public static CpuProfilerConfig fromProto(Cpu.CpuTraceConfiguration.UserOptions proto) {
        CpuProfilerConfig config = new CpuProfilerConfig().setName(proto.getName()).setSamplingIntervalUs(proto.getSamplingIntervalUs()).setBufferSizeMb(proto.getBufferSizeInMb()).setDisableLiveAllocation(proto.getDisableLiveAllocation());
        switch (proto.getTraceType()) {
            case ART: {
                if (proto.getTraceMode() == Cpu.CpuTraceMode.SAMPLED) {
                    config.setTechnology(CpuProfilerConfig.Technology.SAMPLED_JAVA);
                    break;
                }
                config.setTechnology(CpuProfilerConfig.Technology.INSTRUMENTED_JAVA);
                break;
            }
            case SIMPLEPERF: {
                config.setTechnology(CpuProfilerConfig.Technology.SAMPLED_NATIVE);
                break;
            }
            case ATRACE: 
            case PERFETTO: {
                config.setTechnology(CpuProfilerConfig.Technology.SYSTEM_TRACE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported trace type: " + proto.getTraceType());
            }
        }
        return config;
    }
}

