/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.eventpreprocessor;

import com.android.tools.datastore.LogService;
import com.android.tools.datastore.energy.BatteryModel;
import com.android.tools.datastore.energy.CpuConfig;
import com.android.tools.datastore.energy.PowerProfile;
import com.android.tools.idea.transport.TransportEventPreprocessor;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.Network;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyUsagePreprocessor
implements TransportEventPreprocessor {
    private static final long DEFAULT_SAMPLE_INTERVAL_NS = TimeUnit.MILLISECONDS.toNanos(200L);
    @NotNull
    private final LogService myLogService;
    @NotNull
    private final BatteryModel myBatteryModel;
    private long mySampleInterval;
    private long myDataStartTimestampNs = Long.MIN_VALUE;
    @Nullable
    private CpuConfig myCpuConfig = null;
    @Nullable
    private Cpu.CpuUsageData myLastCpuUsageData = null;
    @NotNull
    private PowerProfile.NetworkType myLastNetworkType = PowerProfile.NetworkType.NONE;

    public EnergyUsagePreprocessor(@NotNull LogService logService) {
        this(logService, new BatteryModel(), DEFAULT_SAMPLE_INTERVAL_NS);
    }

    @VisibleForTesting
    public EnergyUsagePreprocessor(@NotNull LogService logService, @NotNull BatteryModel batteryModel, long sampleInterval) {
        this.myLogService = logService;
        this.myBatteryModel = batteryModel;
        this.mySampleInterval = sampleInterval;
    }

    @Override
    public boolean shouldPreprocess(Common.Event event) {
        switch (event.getKind()) {
            case CPU_CORE_CONFIG: 
            case CPU_USAGE: 
            case NETWORK_TYPE: 
            case NETWORK_SPEED: {
                return true;
            }
            case ENERGY_EVENT: {
                switch (event.getEnergyEvent().getMetadataCase()) {
                    case LOCATION_UPDATE_REQUESTED: 
                    case LOCATION_CHANGED: 
                    case LOCATION_UPDATE_REMOVED: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Iterable<Common.Event> preprocessEvent(Common.Event event) {
        switch (event.getKind()) {
            case CPU_CORE_CONFIG: {
                this.myCpuConfig = new CpuConfig(event.getCpuCoreConfig(), this.myLogService);
                break;
            }
            case CPU_USAGE: {
                if (this.myCpuConfig == null) {
                    this.myCpuConfig = new CpuConfig(Cpu.CpuCoreConfigData.getDefaultInstance(), this.myLogService);
                }
                if (this.myLastCpuUsageData != null) {
                    this.myBatteryModel.handleEvent(event.getTimestamp(), BatteryModel.Event.CPU_USAGE, (Object)this.myCpuConfig.getCpuCoreUsages(this.myLastCpuUsageData, event.getCpuUsage()));
                }
                this.myLastCpuUsageData = event.getCpuUsage();
                return this.generateEnergyUsageEvents(event);
            }
            case NETWORK_TYPE: {
                this.myLastNetworkType = PowerProfile.NetworkType.from((Network.NetworkTypeData.NetworkType)event.getNetworkType().getNetworkType());
                break;
            }
            case NETWORK_SPEED: {
                Network.NetworkSpeedData speedData = event.getNetworkSpeed();
                long rxSpeed = 0L;
                long txSpeed = 0L;
                if (event.getGroupId() == 102L) {
                    rxSpeed = speedData.getThroughput();
                } else if (event.getGroupId() == 101L) {
                    txSpeed = speedData.getThroughput();
                }
                this.myBatteryModel.handleEvent(event.getTimestamp(), BatteryModel.Event.NETWORK_USAGE, (Object)new PowerProfile.NetworkStats(this.myLastNetworkType, rxSpeed, txSpeed));
                return this.generateEnergyUsageEvents(event);
            }
            case ENERGY_EVENT: {
                switch (event.getEnergyEvent().getMetadataCase()) {
                    case LOCATION_UPDATE_REQUESTED: {
                        this.myBatteryModel.handleEvent(event.getTimestamp(), BatteryModel.Event.LOCATION_REGISTER, (Object)new PowerProfile.LocationEvent(event.getGroupId(), PowerProfile.LocationType.from((String)event.getEnergyEvent().getLocationUpdateRequested().getRequest().getProvider())));
                        break;
                    }
                    case LOCATION_CHANGED: {
                        this.myBatteryModel.handleEvent(event.getTimestamp(), BatteryModel.Event.LOCATION_UPDATE, (Object)new PowerProfile.LocationEvent(event.getGroupId(), PowerProfile.LocationType.from((String)event.getEnergyEvent().getLocationChanged().getLocation().getProvider())));
                        break;
                    }
                    case LOCATION_UPDATE_REMOVED: {
                        this.myBatteryModel.handleEvent(event.getTimestamp(), BatteryModel.Event.LOCATION_UNREGISTER, (Object)new PowerProfile.LocationEvent(event.getGroupId(), PowerProfile.LocationType.NONE));
                        break;
                    }
                }
                return this.generateEnergyUsageEvents(event);
            }
        }
        return Collections.emptyList();
    }

    private List<Common.Event> generateEnergyUsageEvents(Common.Event event) {
        if (this.myDataStartTimestampNs == Long.MIN_VALUE) {
            this.myDataStartTimestampNs = event.getTimestamp();
        }
        if (event.getTimestamp() - this.myDataStartTimestampNs > this.mySampleInterval) {
            ArrayList<Common.Event> result2 = new ArrayList<Common.Event>();
            this.myBatteryModel.getSamplesBetween(this.myDataStartTimestampNs, event.getTimestamp()).forEach(sample -> result2.add(Common.Event.newBuilder().setPid(event.getPid()).setTimestamp(sample.getTimestamp()).setKind(Common.Event.Kind.ENERGY_USAGE).setEnergyUsage(sample.getEnergyUsage()).build()));
            this.myDataStartTimestampNs = event.getTimestamp();
            return result2;
        }
        return Collections.emptyList();
    }
}

