/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.profilers.ProfilerPreferences;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class TemporaryProfilerPreferences
implements ProfilerPreferences {
    @NotNull
    private static final Map<String, String> ourPreferenceMap = new HashMap<String, String>();

    @NotNull
    public String getValue(@NotNull String name, @NotNull String defaultValue2) {
        if (ourPreferenceMap.containsKey(name)) {
            return ourPreferenceMap.get(name);
        }
        return defaultValue2;
    }

    public float getFloat(@NotNull String name, float defaultValue2) {
        if (ourPreferenceMap.containsKey(name)) {
            try {
                return Float.parseFloat(ourPreferenceMap.get(name));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue2;
    }

    public int getInt(@NotNull String name, int defaultValue2) {
        if (ourPreferenceMap.containsKey(name)) {
            try {
                return Integer.parseInt(ourPreferenceMap.get(name));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue2;
    }

    public boolean getBoolean(@NotNull String name, boolean defaultValue2) {
        if (ourPreferenceMap.containsKey(name)) {
            return Boolean.parseBoolean(ourPreferenceMap.get(name));
        }
        return defaultValue2;
    }

    public void setValue(@NotNull String name, @NotNull String value2) {
        ourPreferenceMap.put(name, value2);
    }

    public void setFloat(@NotNull String name, float value2) {
        this.setFloat(name, value2, 0.0f);
    }

    public void setFloat(@NotNull String name, float value2, float defaultValue2) {
        if (Float.compare(value2, defaultValue2) == 0) {
            ourPreferenceMap.remove(name);
        } else {
            ourPreferenceMap.put(name, Float.toString(value2));
        }
    }

    public void setInt(@NotNull String name, int value2) {
        this.setInt(name, value2, 0);
    }

    public void setInt(@NotNull String name, int value2, int defaultValue2) {
        if (value2 == defaultValue2) {
            ourPreferenceMap.remove(name);
        } else {
            ourPreferenceMap.put(name, Integer.toString(value2));
        }
    }

    public void setBoolean(@NotNull String name, boolean value2) {
        ourPreferenceMap.put(name, Boolean.toString(value2));
    }
}

