/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.profilers.IntellijContextMenuInstaller;
import com.android.tools.idea.profilers.IntellijExportDialog;
import com.android.tools.idea.profilers.IntellijImportDialog;
import com.android.tools.idea.profilers.IntellijUiMessageHandler;
import com.android.tools.idea.profilers.ResizableImage;
import com.android.tools.idea.profilers.dataviewer.IntellijDataViewer;
import com.android.tools.idea.profilers.dataviewer.IntellijImageDataViewer;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilingConfigurationsDialog;
import com.android.tools.idea.profilers.stacktrace.IntelliJStackTraceGroup;
import com.android.tools.profilers.ContentType;
import com.android.tools.profilers.ContextMenuInstaller;
import com.android.tools.profilers.ExportDialog;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ImportDialog;
import com.android.tools.profilers.UiMessageHandler;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.config.CpuProfilerConfigModel;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.dataviewer.DataViewer;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.android.tools.profilers.stacktrace.StackTraceGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLoadingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijProfilerComponents
implements IdeProfilerComponents {
    @NotNull
    private final Project myProject;
    @NotNull
    private final FeatureTracker myFeatureTracker;

    public IntellijProfilerComponents(@NotNull Project project, @NotNull FeatureTracker featureTracker) {
        this.myProject = project;
        this.myFeatureTracker = featureTracker;
    }

    @NotNull
    public LoadingPanel createLoadingPanel(final int delayMs) {
        return new LoadingPanel(){
            private final JBLoadingPanel myLoadingPanel;
            {
                this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)IntellijProfilerComponents.this.myProject, delayMs);
            }

            @NotNull
            public JComponent getComponent() {
                return this.myLoadingPanel;
            }

            public void setChildComponent(@Nullable Component comp) {
                this.myLoadingPanel.getContentPanel().removeAll();
                if (comp != null) {
                    this.myLoadingPanel.add(comp);
                }
            }

            public void setLoadingText(@NotNull String loadingText) {
                this.myLoadingPanel.setLoadingText(loadingText);
            }

            public void startLoading() {
                this.myLoadingPanel.startLoading();
            }

            public void stopLoading() {
                this.myLoadingPanel.stopLoading();
            }
        };
    }

    @NotNull
    public StackTraceGroup createStackGroup() {
        return new IntelliJStackTraceGroup(this.myProject);
    }

    @NotNull
    public ContextMenuInstaller createContextMenuInstaller() {
        return new IntellijContextMenuInstaller();
    }

    @NotNull
    public ExportDialog createExportDialog() {
        return new IntellijExportDialog(this.myProject);
    }

    @NotNull
    public ImportDialog createImportDialog() {
        return new IntellijImportDialog(this.myProject);
    }

    @NotNull
    public DataViewer createDataViewer(@NotNull byte[] content2, @NotNull ContentType contentType, @NotNull DataViewer.Style styleHint) {
        assert (styleHint != DataViewer.Style.INVALID);
        if (contentType.isSupportedImageType()) {
            Object viewer = IntellijImageDataViewer.createImageViewer(content2);
            if (viewer == null) {
                viewer = IntellijDataViewer.createInvalidViewer();
            }
            return viewer;
        }
        if (styleHint == DataViewer.Style.RAW) {
            return contentType.isSupportedTextType() ? IntellijDataViewer.createRawTextViewer(content2) : IntellijDataViewer.createInvalidViewer();
        }
        assert (styleHint == DataViewer.Style.PRETTY);
        return IntellijDataViewer.createPrettyViewerIfPossible(this.myProject, content2, contentType.getFileType());
    }

    @NotNull
    public JComponent createResizableImageComponent(@NotNull BufferedImage image) {
        return new ResizableImage(image);
    }

    @NotNull
    public UiMessageHandler createUiMessageHandler() {
        return new IntellijUiMessageHandler();
    }

    public void openCpuProfilingConfigurationsDialog(@NotNull CpuProfilerConfigModel model2, int deviceLevel, @NotNull Consumer<ProfilingConfiguration> dialogCallback) {
        CpuProfilingConfigurationsDialog dialog2 = new CpuProfilingConfigurationsDialog(this.myProject, deviceLevel, model2, dialogCallback, this.myFeatureTracker);
        dialog2.show();
    }
}

