/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.TvBannerGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureIconView;
import com.android.tools.idea.npw.assetstudio.ui.ImageAssetBrowser;
import com.android.tools.idea.npw.assetstudio.ui.MultiLineTextAssetEditor;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentStateUtil;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.expressions.optional.AsOptionalExpression;
import com.android.tools.idea.observable.expressions.string.FormatExpression;
import com.android.tools.idea.observable.ui.ColorProperty;
import com.android.tools.idea.observable.ui.EnabledProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.SelectedRadioButtonProperty;
import com.android.tools.idea.observable.ui.SliderValueProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureTvBannerPanel
extends JPanel
implements Disposable,
ConfigureIconView,
PersistentStateComponent<PersistentState> {
    private static final boolean HIDE_INAPPLICABLE_CONTROLS = false;
    private static final Color DEFAULT_FOREGROUND_COLOR = Color.BLACK;
    private static final File DEFAULT_FOREGROUND_IMAGE = AssetStudioUtils.getBundledImage("asset_studio", "ic_banner_image.xml");
    private static final BackgroundAssetType DEFAULT_BACKGROUND_ASSET_TYPE = BackgroundAssetType.COLOR;
    private static final String DEFAULT_OUTPUT_NAME = AndroidIconType.TV_BANNER.toOutputName("");
    private static final String BACKGROUND_ASSET_TYPE_PROPERTY = "backgroundAssetType";
    private static final String BACKGROUND_COLOR_PROPERTY = "backgroundColor";
    private static final String GENERATE_LEGACY_ICON_PROPERTY = "generateLegacyIcon";
    private static final String OUTPUT_NAME_PROPERTY = "outputName";
    private static final String FOREGROUND_LAYER_NAME_PROPERTY = "foregroundLayerName";
    private static final String BACKGROUND_LAYER_NAME_PROPERTY = "backgroundLayerName";
    private static final String FOREGROUND_IMAGE_PROPERTY = "foregroundImage";
    private static final String FOREGROUND_TEXT_PROPERTY = "foregroundText";
    private static final String BACKGROUND_IMAGE_PROPERTY = "backgroundImage";
    private JPanel myRootPanel;
    private JPanel myOutputNamePanelRow;
    private JBLabel myOutputNameLabel;
    private JTextField myOutputNameTextField;
    private JPanel myForegroundImageSourcePanel;
    private JPanel myForegroundTextAssetRowPanel;
    private JPanel myForegroundColorRowPanel;
    private JPanel myForegroundAllOptionsPanel;
    private JPanel myForegroundImageResizeSliderPanel;
    private JSlider myForegroundImageResizeSlider;
    private JLabel myForegroundImageResizeValueLabel;
    private JPanel myForegroundTextResizeSliderPanel;
    private JSlider myForegroundTextResizeSlider;
    private JLabel myForegroundTextResizeValueLabel;
    private JTextField myForegroundLayerNameTextField;
    private ColorPanel myForegroundColorPanel;
    private JBScrollPane myForegroundScrollPane;
    private ImageAssetBrowser myForegroundImageAssetBrowser;
    private JBLabel myForegroundLayerNameLabel;
    private JBLabel myForegroundImagePathLabel;
    private JBLabel myForegroundTextResizeLabel;
    private JBLabel myForegroundColorLabel;
    private JBLabel myForegroundTextLabel;
    private JPanel myForegroundImageResizePanel;
    private JBLabel myForegroundImageResizeLabel;
    private MultiLineTextAssetEditor myForegroundTextAssetEditor;
    private JPanel myForegroundLayerNamePanel;
    private JPanel myForegroundImageAssetPanel;
    private JPanel myForegroundTextOptionsPanel;
    private TitledSeparator myForegroundTextTitleSeparator;
    private TitledSeparator myForegroundImageTitleSeparator;
    private JPanel myForegroundTextResizePanel;
    private JPanel myBackgroundAllOptionsPanel;
    private JRadioButton myBackgroundImageRadioButton;
    private JRadioButton myBackgroundColorRadioButton;
    private JSlider myBackgroundResizeSlider;
    private JLabel myBackgroundResizeValueLabel;
    private JPanel myBackgroundAssetRadioButtonsPanel;
    private JPanel myBackgroundResizeSliderPanel;
    private JTextField myBackgroundLayerNameTextField;
    private JPanel myBackgroundResizeRowPanel;
    private JPanel myBackgroundColorRowPanel;
    private ColorPanel myBackgroundColorPanel;
    private JBScrollPane myBackgroundScrollPane;
    private JPanel myBackgroundImageAssetRowPanel;
    private ImageAssetBrowser myBackgroundImageAssetBrowser;
    private JBLabel myBackgroundLayerNameLabel;
    private JLabel myBackgroundAssetTypeLabel;
    private JBLabel myBackgroundImagePathLabel;
    private JBLabel myBackgroundResizeLabel;
    private JBLabel myBackgroundColorLabel;
    private JPanel myBackgroundLayerNamePanel;
    private JPanel myBackgroundAssetTypePanel;
    private JPanel myBackgroundAssetTypeSourcePanel;
    private JPanel myBackgroundImageOptionsPanel;
    private TitledSeparator myBackgroundScalingTitleSeparator;
    private TitledSeparator myBackgroundSourceAssetTitleSeparator;
    private JBScrollPane myOtherIconsScrollPane;
    private JPanel myOtherIconsAllOptionsPanel;
    private JPanel mGenerateLegacyIconRadioButtonsPanel;
    private JRadioButton myGenerateLegacyIconYesRadioButton;
    private JBLabel myGenerateLegacyIconLabel;
    private JPanel myGenerateLegacyIconRowPanel;
    @NotNull
    private final AndroidVersion myBuildSdkVersion;
    @NotNull
    private final TvBannerGenerator myIconGenerator;
    @NotNull
    private final ValidatorPanel myValidatorPanel;
    @NotNull
    private final BindingsManager myGeneralBindings;
    @NotNull
    private final BindingsManager myForegroundActiveAssetBindings;
    @NotNull
    private final BindingsManager myBackgroundActiveAssetBindings;
    @NotNull
    private final ListenerManager myListeners;
    @NotNull
    private final List<ActionListener> myAssetListeners;
    @NotNull
    private final StringProperty myOutputName;
    @NotNull
    private final StringProperty myForegroundLayerName;
    @NotNull
    private final StringProperty myBackgroundLayerName;
    @NotNull
    private final ObjectProperty<BaseAsset> myForegroundActiveAsset;
    @NotNull
    private final OptionalProperty<ImageAsset> myBackgroundImageAsset;
    @NotNull
    private final ObjectProperty<Validator.Result> myForegroundAssetValidityState;
    @NotNull
    private final ObjectProperty<Validator.Result> myBackgroundAssetValidityState;
    @NotNull
    private final AbstractProperty<BackgroundAssetType> myBackgroundAssetType;
    private ColorProperty myForegroundTextColor;
    private AbstractProperty<Color> myBackgroundColor;
    private IntProperty myForegroundImageResizePercent;
    private IntProperty myForegroundTextResizePercent;
    private IntProperty myBackgroundResizePercent;
    private BoolProperty myGenerateLegacyIcon;
    private AndroidFacet myFacet;

    public ConfigureTvBannerPanel(@NotNull Disposable disposableParent, @NotNull AndroidFacet facet2, @NotNull ValidatorPanel validatorPanel2, @Nullable DrawableRenderer renderer2) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myGeneralBindings = new BindingsManager();
        this.myForegroundActiveAssetBindings = new BindingsManager();
        this.myBackgroundActiveAssetBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myAssetListeners = new ArrayList<ActionListener>(1);
        this.myForegroundAssetValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
        this.myBackgroundAssetValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
        this.myFacet = facet2;
        AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance(facet2);
        AndroidVersion buildSdkVersion = androidModuleInfo.getBuildSdkVersion();
        this.myBuildSdkVersion = buildSdkVersion != null ? buildSdkVersion : new AndroidVersion(26);
        this.myForegroundImageAssetBrowser.getAsset().setDefaultImagePath(DEFAULT_FOREGROUND_IMAGE);
        this.myIconGenerator = new TvBannerGenerator(facet2.getModule().getProject(), androidModuleInfo.getMinSdkVersion().getApiLevel(), renderer2);
        this.myValidatorPanel = validatorPanel2;
        this.myForegroundScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myForegroundScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myBackgroundScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myBackgroundScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myOtherIconsScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myOtherIconsScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myOutputName = new TextProperty(this.myOutputNameTextField);
        this.myForegroundLayerName = new TextProperty(this.myForegroundLayerNameTextField);
        this.myBackgroundLayerName = new TextProperty(this.myBackgroundLayerNameTextField);
        this.myListeners.listen(this.myForegroundLayerName, name -> {
            if (name.equals(this.defaultForegroundLayerName())) {
                this.myGeneralBindings.bind(this.myForegroundLayerName, Expression.create(() -> this.defaultForegroundLayerName(), this.myOutputName));
            } else {
                this.myGeneralBindings.release(this.myForegroundLayerName);
            }
        });
        this.myListeners.listen(this.myBackgroundLayerName, name -> {
            if (name.equals(this.defaultBackgroundLayerName())) {
                this.myGeneralBindings.bind(this.myBackgroundLayerName, Expression.create(() -> this.defaultBackgroundLayerName(), this.myOutputName));
            } else {
                this.myGeneralBindings.release(this.myBackgroundLayerName);
            }
        });
        this.myForegroundImageAssetBrowser.getAsset().imagePath().setValue(DEFAULT_FOREGROUND_IMAGE);
        this.myOutputNameLabel.setLabelFor((Component)this.myOutputNameTextField);
        this.myForegroundLayerNameLabel.setLabelFor((Component)this.myForegroundLayerNameTextField);
        this.myForegroundImagePathLabel.setLabelFor((Component)((Object)this.myForegroundImageAssetBrowser));
        this.myForegroundTextResizeLabel.setLabelFor((Component)this.myForegroundTextResizeSliderPanel);
        this.myForegroundColorLabel.setLabelFor((Component)this.myForegroundColorPanel);
        this.myGenerateLegacyIconLabel.setLabelFor((Component)this.mGenerateLegacyIconRadioButtonsPanel);
        this.myBackgroundLayerNameLabel.setLabelFor((Component)this.myBackgroundLayerNameTextField);
        this.myBackgroundAssetTypeLabel.setLabelFor(this.myBackgroundAssetRadioButtonsPanel);
        this.myBackgroundImagePathLabel.setLabelFor((Component)((Object)this.myBackgroundImageAssetBrowser));
        this.myBackgroundResizeLabel.setLabelFor((Component)this.myBackgroundResizeSliderPanel);
        this.myBackgroundColorLabel.setLabelFor((Component)this.myBackgroundColorPanel);
        this.myForegroundActiveAsset = new ObjectValueProperty<ImageAsset>(this.myForegroundImageAssetBrowser.getAsset());
        this.myForegroundImageAssetBrowser.getAsset().setRole("foreground image");
        this.myForegroundColorPanel.setSelectedColor(DEFAULT_FOREGROUND_COLOR);
        this.myBackgroundAssetType = new SelectedRadioButtonProperty<BackgroundAssetType>(DEFAULT_BACKGROUND_ASSET_TYPE, (T[])BackgroundAssetType.values(), this.myBackgroundImageRadioButton, this.myBackgroundColorRadioButton);
        this.myBackgroundImageAsset = OptionalValueProperty.fromNullable(this.myBackgroundAssetType.get() == BackgroundAssetType.IMAGE ? this.myBackgroundImageAssetBrowser.getAsset() : null);
        this.myBackgroundImageAssetBrowser.getAsset().setRole("background image");
        this.myBackgroundColorPanel.setSelectedColor((Color)this.myIconGenerator.backgroundColor().get());
        InvalidationListener onTextChanged = () -> {
            ActionEvent e = new ActionEvent(this, 1001, null);
            for (ActionListener listener2 : this.myAssetListeners) {
                listener2.actionPerformed(e);
            }
        };
        TextAsset textAsset = this.myForegroundTextAssetEditor.getAsset();
        textAsset.text().addListener(onTextChanged);
        textAsset.fontFamily().addListener(onTextChanged);
        this.initializeListenersAndBindings();
        this.initializeValidators();
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myForegroundImageAssetBrowser);
        Disposer.register((Disposable)this, (Disposable)this.myBackgroundImageAssetBrowser);
        Disposer.register((Disposable)this, (Disposable)this.myIconGenerator);
        this.add(this.myRootPanel);
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state = new PersistentState();
        state.setChild(FOREGROUND_IMAGE_PROPERTY, this.myForegroundImageAssetBrowser.getAsset().getState());
        state.setChild(FOREGROUND_TEXT_PROPERTY, this.myForegroundTextAssetEditor.getAsset().getState());
        state.setChild(BACKGROUND_IMAGE_PROPERTY, this.myBackgroundImageAssetBrowser.getAsset().getState());
        state.set(BACKGROUND_ASSET_TYPE_PROPERTY, (Enum)this.myBackgroundAssetType.get(), DEFAULT_BACKGROUND_ASSET_TYPE);
        state.set(BACKGROUND_COLOR_PROPERTY, (Color)this.myBackgroundColor.get(), TvBannerGenerator.DEFAULT_BACKGROUND_COLOR);
        state.set(GENERATE_LEGACY_ICON_PROPERTY, (Boolean)this.myGenerateLegacyIcon.get(), true);
        state.set(OUTPUT_NAME_PROPERTY, (String)this.myOutputName.get(), DEFAULT_OUTPUT_NAME);
        state.set(FOREGROUND_LAYER_NAME_PROPERTY, (String)this.myForegroundLayerName.get(), this.defaultForegroundLayerName());
        state.set(BACKGROUND_LAYER_NAME_PROPERTY, (String)this.myBackgroundLayerName.get(), this.defaultBackgroundLayerName());
        return state;
    }

    public void loadState(@NotNull PersistentState state) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(this.myFacet);
            LocalResourceRepository projectResources = repositoryManager.getProjectResources();
            List<ResourceItem> items2 = projectResources.getResources(repositoryManager.getNamespace(), ResourceType.STRING, "app_name");
            ResourceValue resourceValue2 = !items2.isEmpty() ? items2.get(0).getResourceValue() : null;
            String defaultIconText = resourceValue2 == null || resourceValue2.getValue() == null ? "Application Name" : resourceValue2.getValue();
            UIUtil.invokeLaterIfNeeded(() -> {
                this.myForegroundTextAssetEditor.getAsset().setDefaultText(defaultIconText);
                this.loadStateInternal(state);
            });
        });
    }

    private void loadStateInternal(@NotNull PersistentState state) {
        PersistentStateUtil.load(this.myForegroundImageAssetBrowser.getAsset(), state.getChild(FOREGROUND_IMAGE_PROPERTY));
        PersistentStateUtil.load(this.myForegroundTextAssetEditor.getAsset(), state.getChild(FOREGROUND_TEXT_PROPERTY));
        PersistentStateUtil.load(this.myBackgroundImageAssetBrowser.getAsset(), state.getChild(BACKGROUND_IMAGE_PROPERTY));
        this.myBackgroundAssetType.set(state.get(BACKGROUND_ASSET_TYPE_PROPERTY, DEFAULT_BACKGROUND_ASSET_TYPE));
        this.myBackgroundColor.set(state.get(BACKGROUND_COLOR_PROPERTY, TvBannerGenerator.DEFAULT_BACKGROUND_COLOR));
        this.myGenerateLegacyIcon.set(state.get(GENERATE_LEGACY_ICON_PROPERTY, true));
        this.myOutputName.set(state.get(OUTPUT_NAME_PROPERTY, DEFAULT_OUTPUT_NAME));
        this.myForegroundLayerName.set(state.get(FOREGROUND_LAYER_NAME_PROPERTY, this.defaultForegroundLayerName()));
        this.myBackgroundLayerName.set(state.get(BACKGROUND_LAYER_NAME_PROPERTY, this.defaultBackgroundLayerName()));
    }

    private void initializeListenersAndBindings() {
        this.myForegroundImageResizePercent = new SliderValueProperty(this.myForegroundImageResizeSlider);
        TextProperty foregroundImageResizeValueString = new TextProperty(this.myForegroundImageResizeValueLabel);
        this.myGeneralBindings.bind(foregroundImageResizeValueString, new FormatExpression("%d %%", this.myForegroundImageResizePercent));
        this.myForegroundTextResizePercent = new SliderValueProperty(this.myForegroundTextResizeSlider);
        TextProperty foregroundTextResizeValueString = new TextProperty(this.myForegroundTextResizeValueLabel);
        this.myGeneralBindings.bind(foregroundTextResizeValueString, new FormatExpression("%d %%", this.myForegroundTextResizePercent));
        this.myBackgroundResizePercent = new SliderValueProperty(this.myBackgroundResizeSlider);
        TextProperty backgroundResizeValueString = new TextProperty(this.myBackgroundResizeValueLabel);
        this.myGeneralBindings.bind(backgroundResizeValueString, new FormatExpression("%d %%", this.myBackgroundResizePercent));
        this.myForegroundTextColor = new ColorProperty(this.myForegroundColorPanel);
        this.myBackgroundColor = ObjectProperty.wrap(new ColorProperty(this.myBackgroundColorPanel));
        this.myGenerateLegacyIcon = new SelectedProperty(this.myGenerateLegacyIconYesRadioButton);
        this.updateBindingsAndUiForActiveIconType();
        this.myBackgroundAssetType.addListener(() -> {
            if (this.myBackgroundAssetType.get() == BackgroundAssetType.IMAGE) {
                this.myBackgroundImageAsset.setValue(this.myBackgroundImageAssetBrowser.getAsset());
            } else {
                this.myBackgroundImageAsset.clear();
            }
        });
        ActionListener assetPanelListener = e -> this.fireAssetListeners();
        this.myForegroundImageAssetBrowser.addAssetListener(assetPanelListener);
        this.myBackgroundImageAssetBrowser.addAssetListener(assetPanelListener);
        Runnable onAssetModified = this::fireAssetListeners;
        this.myListeners.listenAll(this.myForegroundImageResizePercent, this.myForegroundTextResizePercent, this.myForegroundTextColor, this.myBackgroundResizePercent, this.myBackgroundColor, this.myGenerateLegacyIcon).with(onAssetModified);
        BoolValueProperty foregroundImageIsResizable = new BoolValueProperty();
        this.myListeners.listenAndFire(this.myForegroundActiveAsset, () -> {
            this.myForegroundActiveAssetBindings.releaseAll();
            BaseAsset asset = (BaseAsset)this.myForegroundActiveAsset.get();
            this.myForegroundActiveAssetBindings.bindTwoWay(this.myForegroundImageResizePercent, asset.scalingPercent());
            this.myForegroundActiveAssetBindings.bind(foregroundImageIsResizable, asset.isResizable());
            if (asset instanceof ImageAsset) {
                this.myForegroundActiveAssetBindings.bind(this.myForegroundAssetValidityState, ((ImageAsset)asset).getValidityState());
            } else {
                this.myForegroundAssetValidityState.set(Validator.Result.OK);
            }
            this.myIconGenerator.sourceAsset().setValue(asset);
            TextAsset textAsset = this.myForegroundTextAssetEditor.getAsset();
            this.myIconGenerator.textAsset().setNullableValue(textAsset);
            this.myGeneralBindings.bindTwoWay(this.myForegroundTextResizePercent, textAsset.scalingPercent());
            OptionalValueProperty<Color> assetColor = textAsset.color();
            if (assetColor.getValueOrNull() == null) {
                assetColor.setNullableValue((Color)this.myForegroundTextColor.getValueOrNull());
            }
            this.myGeneralBindings.bindTwoWay(this.myForegroundTextColor, assetColor);
            onAssetModified.run();
        });
        BoolValueProperty backgroundIsResizable = new BoolValueProperty();
        Runnable onBackgroundAssetModified = () -> {
            this.myBackgroundActiveAssetBindings.releaseAll();
            ImageAsset asset = this.myBackgroundImageAsset.getValueOrNull();
            if (asset != null) {
                this.myBackgroundActiveAssetBindings.bindTwoWay(this.myBackgroundResizePercent, asset.scalingPercent());
                this.myBackgroundActiveAssetBindings.bind(backgroundIsResizable, asset.isResizable());
                this.myBackgroundActiveAssetBindings.bind(this.myBackgroundAssetValidityState, asset.getValidityState());
            } else {
                backgroundIsResizable.set(false);
                this.myBackgroundAssetValidityState.set(Validator.Result.OK);
            }
            this.getIconGenerator().backgroundImageAsset().setNullableValue(asset);
            onAssetModified.run();
        };
        this.myListeners.listenAndFire(this.myBackgroundImageAsset, () -> onBackgroundAssetModified.run());
        ImmutableMap.Builder layoutPropertiesBuilder = ImmutableMap.builder();
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myForegroundImageResizeSlider), (Object)foregroundImageIsResizable);
        SelectedProperty backgroundIsImage = new SelectedProperty(this.myBackgroundImageRadioButton);
        SelectedProperty backgroundIsColor = new SelectedProperty(this.myBackgroundColorRadioButton);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myBackgroundImageAssetRowPanel), (Object)backgroundIsImage);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myBackgroundColorRowPanel), (Object)backgroundIsColor);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myBackgroundResizeSlider), (Object)backgroundIsResizable);
        ImmutableMap layoutProperties = layoutPropertiesBuilder.build();
        for (Map.Entry entry : layoutProperties.entrySet()) {
            ((BoolProperty)entry.getKey()).set(false);
            this.myGeneralBindings.bind((SettableValue)entry.getKey(), (ObservableValue)entry.getValue());
        }
        this.myListeners.listenAll((Collection<? extends ObservableValue<?>>)layoutProperties.keySet()).with(() -> {
            SwingUtilities.updateComponentTreeUI(this.myForegroundAllOptionsPanel);
            SwingUtilities.updateComponentTreeUI(this.myBackgroundAllOptionsPanel);
        });
    }

    private void initializeValidators() {
        VisibleProperty isActive = new VisibleProperty(this);
        this.myValidatorPanel.registerTest(Expression.create(() -> isActive.get() == false || this.myBuildSdkVersion.getFeatureLevel() >= 26, isActive), "Project must be built with SDK 26 or later to use adaptive icons");
        this.myValidatorPanel.registerTest(ConfigureTvBannerPanel.nameIsNotEmptyExpression(isActive, this.myForegroundLayerName), "Foreground layer name must be set");
        this.myValidatorPanel.registerTest(ConfigureTvBannerPanel.nameIsNotEmptyExpression(isActive, this.myBackgroundLayerName), "Background layer name must be set");
        this.myValidatorPanel.registerTest(ConfigureTvBannerPanel.namesAreDistinctExpression(isActive, this.myOutputName, this.myForegroundLayerName), "Foreground layer must have a name distinct from the icon name");
        this.myValidatorPanel.registerTest(ConfigureTvBannerPanel.namesAreDistinctExpression(isActive, this.myOutputName, this.myBackgroundLayerName), "Background layer must have a name distinct from the icon name");
        this.myValidatorPanel.registerTest(ConfigureTvBannerPanel.namesAreDistinctExpression(isActive, this.myForegroundLayerName, this.myBackgroundLayerName), "Background and foreground layers must have distinct names");
        this.myValidatorPanel.registerValidator(this.myForegroundAssetValidityState, validity -> validity, new ObservableValue[0]);
        this.myValidatorPanel.registerValidator(this.myBackgroundAssetValidityState, validity -> validity, new ObservableValue[0]);
    }

    @NotNull
    private static Expression<Boolean> nameIsNotEmptyExpression(@NotNull VisibleProperty isActive, @NotNull StringProperty name) {
        return Expression.create(() -> isActive.get() == false || !StringUtil.isEmptyOrSpaces((String)((String)name.get())), isActive, name);
    }

    @NotNull
    private static Expression<Boolean> namesAreDistinctExpression(@NotNull VisibleProperty isActive, @NotNull StringProperty name1, @NotNull StringProperty name2) {
        return Expression.create(() -> isActive.get() == false || !StringUtil.equalsTrimWhitespaces((CharSequence)((CharSequence)name1.get()), (CharSequence)((CharSequence)name2.get())), isActive, name1, name2);
    }

    @Override
    @NotNull
    public TvBannerGenerator getIconGenerator() {
        return this.myIconGenerator;
    }

    @Override
    @NotNull
    public JComponent getRootComponent() {
        return this;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener listener2) {
        this.myAssetListeners.add(listener2);
    }

    @Override
    @NotNull
    public StringProperty outputName() {
        return this.myOutputName;
    }

    private void fireAssetListeners() {
        ActionEvent e = new ActionEvent(this, 1001, null);
        for (ActionListener assetListener : this.myAssetListeners) {
            assetListener.actionPerformed(e);
        }
    }

    private void updateBindingsAndUiForActiveIconType() {
        this.myOutputName.set(DEFAULT_OUTPUT_NAME);
        this.myForegroundLayerName.set(this.defaultForegroundLayerName());
        this.myBackgroundLayerName.set(this.defaultBackgroundLayerName());
        this.myGeneralBindings.bind(this.myIconGenerator.sourceAsset(), new AsOptionalExpression<BaseAsset>((ObservableValue<BaseAsset>)this.myForegroundActiveAsset));
        this.myGeneralBindings.bind(this.myIconGenerator.outputName(), this.myOutputName);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.backgroundImageAsset(), this.myBackgroundImageAsset);
        this.myGeneralBindings.bindTwoWay(this.myBackgroundColor, this.myIconGenerator.backgroundColor());
        this.myGeneralBindings.bindTwoWay(this.myGenerateLegacyIcon, this.myIconGenerator.generateLegacyIcon());
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.foregroundLayerName(), this.myForegroundLayerName);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.backgroundLayerName(), this.myBackgroundLayerName);
    }

    public void dispose() {
        this.myGeneralBindings.releaseAll();
        this.myForegroundActiveAssetBindings.releaseAll();
        this.myBackgroundActiveAssetBindings.releaseAll();
        this.myListeners.releaseAll();
        this.myAssetListeners.clear();
    }

    @NotNull
    private String defaultForegroundLayerName() {
        return (String)this.myOutputName.get() + "_foreground";
    }

    @NotNull
    private String defaultBackgroundLayerName() {
        return (String)this.myOutputName.get() + "_background";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        JBScrollPane jBScrollPane;
        JLabel jLabel;
        JSlider jSlider;
        JPanel jPanel4;
        JBLabel jBLabel2;
        JPanel jPanel5;
        JPanel jPanel6;
        TitledSeparator titledSeparator;
        ColorPanel colorPanel;
        JBLabel jBLabel3;
        JPanel jPanel7;
        ImageAssetBrowser imageAssetBrowser;
        JBLabel jBLabel4;
        JPanel jPanel8;
        JPanel jPanel9;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel10;
        JLabel jLabel2;
        JPanel jPanel11;
        TitledSeparator titledSeparator2;
        JTextField jTextField;
        JBLabel jBLabel5;
        JPanel jPanel12;
        JPanel jPanel13;
        JBScrollPane jBScrollPane2;
        JLabel jLabel3;
        JSlider jSlider2;
        JPanel jPanel14;
        JBLabel jBLabel6;
        JPanel jPanel15;
        ColorPanel colorPanel2;
        JBLabel jBLabel7;
        JPanel jPanel16;
        MultiLineTextAssetEditor multiLineTextAssetEditor;
        JBLabel jBLabel8;
        JPanel jPanel17;
        TitledSeparator titledSeparator3;
        JPanel jPanel18;
        JLabel jLabel4;
        JSlider jSlider3;
        JPanel jPanel19;
        JBLabel jBLabel9;
        JPanel jPanel20;
        ImageAssetBrowser imageAssetBrowser2;
        JBLabel jBLabel10;
        JPanel jPanel21;
        JPanel jPanel22;
        TitledSeparator titledSeparator4;
        JTextField jTextField2;
        JBLabel jBLabel11;
        JPanel jPanel23;
        JPanel jPanel24;
        JBScrollPane jBScrollPane3;
        JTextField jTextField3;
        JBLabel jBLabel12;
        JPanel jPanel25;
        JPanel jPanel26;
        this.myRootPanel = jPanel26 = new JPanel();
        jPanel26.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myOutputNamePanelRow = jPanel25 = new JPanel();
        jPanel25.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel26.add((Component)jPanel25, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        jPanel25.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), null, 0, 0, null, null));
        this.myOutputNameLabel = jBLabel12 = new JBLabel();
        jBLabel12.setText("Name:");
        jPanel25.add((Component)jBLabel12, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(80, -1), null, null));
        JPanel jPanel27 = new JPanel();
        jPanel27.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel25.add((Component)jPanel27, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myOutputNameTextField = jTextField3 = new JTextField();
        jTextField3.setText("(name)");
        jTextField3.setToolTipText("The filename which will be used for these icons.");
        jPanel27.add((Component)jTextField3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        jBTabbedPane.setTabPlacement(1);
        jPanel26.add((Component)jBTabbedPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jBTabbedPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0), null, 0, 0, null, null));
        JPanel jPanel28 = new JPanel();
        jPanel28.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Foreground Layer", null, jPanel28, null);
        this.myForegroundScrollPane = jBScrollPane3 = new JBScrollPane();
        jBScrollPane3.setHorizontalScrollBarPolicy(31);
        jPanel28.add((Component)jBScrollPane3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myForegroundAllOptionsPanel = jPanel24 = new JPanel();
        jPanel24.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane3.setViewportView(jPanel24);
        this.myForegroundLayerNamePanel = jPanel23 = new JPanel();
        jPanel23.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel23).setVisible(true);
        jPanel24.add((Component)jPanel23, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 0, null, null, null, 0, true));
        this.myForegroundLayerNameLabel = jBLabel11 = new JBLabel();
        jBLabel11.setText("Layer Name:");
        jPanel23.add((Component)jBLabel11, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null));
        JPanel jPanel29 = new JPanel();
        jPanel29.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel23.add((Component)jPanel29, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myForegroundLayerNameTextField = jTextField2 = new JTextField();
        jTextField2.setText("(name)");
        jTextField2.setToolTipText("The filename which will be used for these icons.");
        jPanel29.add((Component)jTextField2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myForegroundImageTitleSeparator = titledSeparator4 = new TitledSeparator();
        titledSeparator4.setText("Image");
        jPanel24.add((Component)titledSeparator4, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myForegroundImageAssetPanel = jPanel22 = new JPanel();
        jPanel22.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel24.add((Component)jPanel22, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundImageSourcePanel = jPanel21 = new JPanel();
        jPanel21.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel22.add((Component)jPanel21, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundImagePathLabel = jBLabel10 = new JBLabel();
        jBLabel10.setText("Image File:");
        jPanel21.add((Component)jBLabel10, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundImageAssetBrowser = imageAssetBrowser2 = new ImageAssetBrowser();
        jPanel21.add((Component)((Object)imageAssetBrowser2), new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myForegroundImageResizePanel = jPanel20 = new JPanel();
        jPanel20.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel20).setVisible(true);
        jPanel22.add((Component)jPanel20, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundImageResizeLabel = jBLabel9 = new JBLabel();
        jBLabel9.setText("Resize:");
        jPanel20.add((Component)jBLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundImageResizeSliderPanel = jPanel19 = new JPanel();
        jPanel19.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel20.add((Component)jPanel19, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myForegroundImageResizeSlider = jSlider3 = new JSlider();
        jSlider3.setMaximum(400);
        jSlider3.setMinimum(0);
        jSlider3.setMinorTickSpacing(20);
        jSlider3.setPaintLabels(false);
        jSlider3.setPaintTicks(true);
        jSlider3.setSnapToTicks(false);
        jSlider3.setToolTipText("Resize the original asset using the specified scaling factor (in percent). This happens after any trimming.");
        jSlider3.setValue(100);
        jSlider3.setValueIsAdjusting(false);
        jPanel19.add((Component)jSlider3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myForegroundImageResizeValueLabel = jLabel4 = new JLabel();
        jLabel4.setHorizontalAlignment(4);
        jLabel4.setText("100 %");
        jPanel19.add((Component)jLabel4, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(40, -1), null));
        this.myForegroundTextOptionsPanel = jPanel18 = new JPanel();
        jPanel18.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel24.add((Component)jPanel18, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundTextTitleSeparator = titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText("Label");
        jPanel18.add((Component)titledSeparator3, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myForegroundTextAssetRowPanel = jPanel17 = new JPanel();
        jPanel17.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel18.add((Component)jPanel17, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundTextLabel = jBLabel8 = new JBLabel();
        jBLabel8.setText("Text:");
        jBLabel8.setVerifyInputWhenFocusTarget(false);
        jPanel17.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundTextAssetEditor = multiLineTextAssetEditor = new MultiLineTextAssetEditor();
        jPanel17.add((Component)multiLineTextAssetEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myForegroundColorRowPanel = jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel18.add((Component)jPanel16, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundColorLabel = jBLabel7 = new JBLabel();
        jBLabel7.setText("Color:");
        jPanel16.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundColorPanel = colorPanel2 = new ColorPanel();
        colorPanel2.setSelectedColor(new Color(-16777216));
        jPanel16.add((Component)colorPanel2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(78, -1), null, null));
        this.myForegroundTextResizePanel = jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel15).setVisible(true);
        jPanel18.add((Component)jPanel15, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundTextResizeLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("Resize:");
        jPanel15.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundTextResizeSliderPanel = jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel14, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myForegroundTextResizeSlider = jSlider2 = new JSlider();
        jSlider2.setMaximum(400);
        jSlider2.setMinimum(0);
        jSlider2.setMinorTickSpacing(20);
        jSlider2.setPaintLabels(false);
        jSlider2.setPaintTicks(true);
        jSlider2.setSnapToTicks(false);
        jSlider2.setToolTipText("Resize the original asset using the specified scaling factor (in percent). This happens after any trimming.");
        jSlider2.setValue(100);
        jSlider2.setValueIsAdjusting(false);
        jPanel14.add((Component)jSlider2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myForegroundTextResizeValueLabel = jLabel3 = new JLabel();
        jLabel3.setHorizontalAlignment(4);
        jLabel3.setText("100 %");
        jPanel14.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(40, -1), null));
        Spacer spacer = new Spacer();
        jPanel24.add((Component)spacer, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel30 = new JPanel();
        jPanel30.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Background Layer", null, jPanel30, null);
        this.myBackgroundScrollPane = jBScrollPane2 = new JBScrollPane();
        jBScrollPane2.setHorizontalScrollBarPolicy(31);
        jPanel30.add((Component)jBScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myBackgroundAllOptionsPanel = jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane2.setViewportView(jPanel13);
        this.myBackgroundLayerNamePanel = jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel12).setVisible(true);
        jPanel13.add((Component)jPanel12, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 3, null, null, null, 0, true));
        this.myBackgroundLayerNameLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Layer Name:");
        jPanel12.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null));
        JPanel jPanel31 = new JPanel();
        jPanel31.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel31, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myBackgroundLayerNameTextField = jTextField = new JTextField();
        jTextField.setText("(name)");
        jTextField.setToolTipText("The filename which will be used for these icons.");
        jPanel31.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBackgroundSourceAssetTitleSeparator = titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Source Asset");
        jPanel13.add((Component)titledSeparator2, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myBackgroundAssetTypePanel = jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel11, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundAssetTypeLabel = jLabel2 = new JLabel();
        jLabel2.setText("Asset Type:");
        jPanel11.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundAssetRadioButtonsPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel10, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myBackgroundImageRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Image");
        jRadioButton3.setToolTipText("Select an image, e.g. PNG, SVG, PSD, or a drawable from disk to generate Android icons for your app.");
        jPanel10.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundColorRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Color");
        jRadioButton2.setToolTipText("Select from a background color for the Android icons for your app.");
        jPanel10.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundAssetTypeSourcePanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel9, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundImageAssetRowPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel8, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, new Dimension(30, 30), null, null, 0, true));
        this.myBackgroundImagePathLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Path:");
        jPanel8.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundImageAssetBrowser = imageAssetBrowser = new ImageAssetBrowser();
        jPanel8.add((Component)((Object)imageAssetBrowser), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBackgroundColorRowPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel7, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, new Dimension(30, 30), null, null, 0, true));
        this.myBackgroundColorLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Color:");
        jPanel7.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundColorPanel = colorPanel = new ColorPanel();
        colorPanel.setSelectedColor(new Color(-16777216));
        jPanel7.add((Component)colorPanel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, new Dimension(78, -1), null, null));
        this.myBackgroundScalingTitleSeparator = titledSeparator = new TitledSeparator();
        titledSeparator.setText("Scaling");
        jPanel9.add((Component)titledSeparator, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myBackgroundImageOptionsPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel6, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundResizeRowPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel5).setVisible(true);
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myBackgroundResizeLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Resize:");
        jPanel5.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundResizeSliderPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBackgroundResizeSlider = jSlider = new JSlider();
        jSlider.setMaximum(400);
        jSlider.setMinimum(0);
        jSlider.setMinorTickSpacing(20);
        jSlider.setPaintLabels(false);
        jSlider.setPaintTicks(true);
        jSlider.setSnapToTicks(false);
        jSlider.setToolTipText("Resize the original asset using the specified scaling factor (in percent). This happens after any trimming.");
        jSlider.setValue(100);
        jPanel4.add((Component)jSlider, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBackgroundResizeValueLabel = jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setText("100 %");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(40, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel13.add((Component)spacer2, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel32 = new JPanel();
        jPanel32.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Options", null, jPanel32, null);
        this.myOtherIconsScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel32.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myOtherIconsAllOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), null, 0, 0, null, null));
        TitledSeparator titledSeparator5 = new TitledSeparator();
        titledSeparator5.setText("Legacy Icon (API \u2264 25)");
        jPanel3.add((Component)titledSeparator5, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myGenerateLegacyIconRowPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setVisible(true);
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myGenerateLegacyIconLabel = jBLabel = new JBLabel();
        jBLabel.setText("Generate:");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.mGenerateLegacyIconRadioButtonsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGenerateLegacyIconYesRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(true);
        jRadioButton.setText("Yes");
        jRadioButton.setToolTipText("Generate legacy icon (API \u2264 25)");
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton4 = new JRadioButton();
        jRadioButton4.setSelected(false);
        jRadioButton4.setText("No");
        jRadioButton4.setToolTipText("");
        jPanel.add((Component)jRadioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static enum BackgroundAssetType {
        IMAGE,
        COLOR;

    }
}

