/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.LayeredImageConverter;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageAsset
extends BaseAsset {
    private static final String IMAGE_PATH_PROPERTY = "imagePath";
    @NotNull
    private final OptionalValueProperty<File> myImagePath;
    @NotNull
    private final ObservableBool myIsResizable;
    @NotNull
    private final BoolValueProperty myXmlDrawableIsResizable = new BoolValueProperty();
    @NotNull
    private final ObjectValueProperty<Validator.Result> myValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
    @NotNull
    private String myRole = "image";
    @Nullable
    private File myDefaultImagePath;
    private boolean isClipart;
    @NotNull
    private final Object myLock = new Object();
    @Nullable
    private File myImageFile;
    @Nullable
    private ListenableFuture<String> myXmlDrawableFuture;
    @Nullable
    private ListenableFuture<BufferedImage> myImageFuture;

    @UiThread
    public ImageAsset() {
        this.myImagePath = new OptionalValueProperty();
        this.myImagePath.addListener(() -> {
            this.myXmlDrawableIsResizable.set(false);
            Object object = this.myLock;
            synchronized (object) {
                this.myImageFile = (File)this.myImagePath.getValueOrNull();
                this.myXmlDrawableFuture = null;
                this.myImageFuture = null;
            }
        });
        this.myIsResizable = new BooleanExpression(new ObservableValue[]{this.myImagePath, this.myXmlDrawableIsResizable}){

            @Override
            @NotNull
            public Boolean get() {
                FileType fileType = ImageAsset.getFileType((File)ImageAsset.this.myImagePath.getValueOrNull());
                if (fileType == null) {
                    return false;
                }
                if (fileType == FileType.RASTER_IMAGE_CANDIDATE) {
                    return true;
                }
                ImageAsset.this.getXmlDrawable();
                return ImageAsset.this.myXmlDrawableIsResizable.get();
            }
        };
    }

    @UiThread
    public void setRole(@NotNull String role) {
        this.myRole = role;
    }

    @UiThread
    public void setDefaultImagePath(@Nullable File file2) {
        boolean wasDefault = FileUtil.filesEqual((File)((File)this.myImagePath.getValueOrNull()), (File)this.myDefaultImagePath);
        this.myDefaultImagePath = file2;
        if (wasDefault) {
            this.myImagePath.setNullableValue(this.myDefaultImagePath);
        }
    }

    @UiThread
    public void setClipart(boolean clipart) {
        this.isClipart = clipart;
    }

    @UiThread
    public boolean isClipart() {
        return this.isClipart;
    }

    @Override
    @UiThread
    public boolean isColorable() {
        return this.isClipart;
    }

    @UiThread
    @NotNull
    public OptionalValueProperty<File> imagePath() {
        return this.myImagePath;
    }

    @Override
    @UiThread
    @NotNull
    public ObservableBool isResizable() {
        return this.myIsResizable;
    }

    @UiThread
    @NotNull
    public ObjectValueProperty<Validator.Result> getValidityState() {
        return this.myValidityState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UiThread
    @Nullable
    public ListenableFuture<BufferedImage> toImage() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myImageFuture == null) {
                File file2 = this.myImageFile;
                if (file2 == null || ImageAsset.isVectorGraphics(FileType.fromFile(file2))) {
                    return null;
                }
                this.myImageFuture = FutureUtils.executeOnPooledThread(() -> this.loadImage(file2));
            }
            return this.myImageFuture;
        }
    }

    @Override
    @UiThread
    public PersistentState getState() {
        PersistentState state = super.getState();
        state.setEncoded(IMAGE_PATH_PROPERTY, this.myImagePath.getValueOrNull(), file2 -> FileUtil.filesEqual((File)file2, (File)this.myDefaultImagePath) ? null : file2.getPath());
        return state;
    }

    @Override
    @UiThread
    public void loadState(@NotNull PersistentState state) {
        super.loadState(state);
        File file2 = (File)state.getDecoded(IMAGE_PATH_PROPERTY, path2 -> path2 == null ? this.myDefaultImagePath : new File((String)path2));
        if (file2 != null) {
            this.myImagePath.setValue(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    @Nullable
    public ListenableFuture<String> getXmlDrawable() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myXmlDrawableFuture == null) {
                if (this.myImageFile == null) {
                    return null;
                }
                FileType fileType = FileType.fromFile(this.myImageFile);
                if (!ImageAsset.isVectorGraphics(fileType)) {
                    return null;
                }
                File file2 = this.myImageFile;
                this.myXmlDrawableFuture = FutureUtils.executeOnPooledThread(() -> this.loadXmlDrawable(file2));
            }
            return this.myXmlDrawableFuture;
        }
    }

    @Nullable
    private String loadXmlDrawable(@NotNull File file2) {
        String xmlText = null;
        Validator.Result validityState = this.checkFileExistence(file2);
        if (validityState.getSeverity() == Validator.Severity.OK) {
            FileType fileType = FileType.fromFile(file2);
            try {
                switch (fileType) {
                    case XML_DRAWABLE: {
                        xmlText = new String(Files.readAllBytes(file2.toPath()), StandardCharsets.UTF_8);
                        break;
                    }
                    case SVG: {
                        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        String message2 = Svg2Vector.parseSvgToXml((File)file2, (OutputStream)outStream);
                        xmlText = outStream.toString(StandardCharsets.UTF_8.name());
                        if (xmlText.isEmpty()) {
                            xmlText = null;
                        }
                        if (message2.isEmpty()) break;
                        Validator.Severity severity = xmlText == null ? Validator.Severity.ERROR : Validator.Severity.WARNING;
                        validityState = this.createValidatorResult(severity, message2);
                        break;
                    }
                    case LAYERED_IMAGE: {
                        xmlText = new LayeredImageConverter().toVectorDrawableXml(file2);
                        break;
                    }
                }
            }
            catch (Exception e) {
                StringBuilder message3 = new StringBuilder();
                message3.append("Error while parsing ").append(file2.getName());
                String errorDetail = e.getLocalizedMessage();
                if (errorDetail != null) {
                    message3.append(" - ").append(errorDetail);
                }
                validityState = Validator.Result.fromNullableMessage((String)message3.toString());
            }
        }
        if (xmlText == null && validityState.getSeverity() == Validator.Severity.OK) {
            validityState = Validator.Result.fromNullableMessage((String)("The " + this.myRole + " file could not be parsed. Please choose another file."));
        }
        boolean resizable = xmlText != null && "vector".equals(XmlUtils.getRootTagName(xmlText));
        this.updateValidityStateAndResizability(file2, validityState, resizable);
        return xmlText;
    }

    @NotNull
    private Validator.Result createValidatorResult(@NotNull Validator.Severity severity, @NotNull String errors2) {
        if (errors2.indexOf(10) < 0) {
            return new Validator.Result(severity, "The " + this.myRole + " may be incomplete: " + errors2);
        }
        String shortMessage = "<html>The " + this.myRole + " may be incomplete due to encountered <a href=\"issues\">issues</a></html>";
        return new Validator.Result(severity, shortMessage, errors2);
    }

    @Nullable
    private BufferedImage loadImage(@NotNull File file2) {
        FileType fileType;
        BufferedImage image = null;
        Validator.Result validityState = this.checkFileExistence(file2);
        if (validityState.getSeverity() == Validator.Severity.OK && (fileType = FileType.fromFile(file2)) == FileType.RASTER_IMAGE_CANDIDATE) {
            try {
                image = ImageIO.read(file2);
            }
            catch (IOException e) {
                validityState = Validator.Result.fromThrowable((Throwable)e);
            }
        }
        this.updateValidityStateAndResizability(file2, validityState, image != null);
        return image;
    }

    @NotNull
    private Validator.Result checkFileExistence(@NotNull File file2) {
        if (!file2.exists()) {
            return Validator.Result.fromNullableMessage((String)("File " + file2.getName() + " does not exist"));
        }
        if (file2.isDirectory()) {
            return new Validator.Result(Validator.Severity.WARNING, "Please select " + ImageAsset.getIndefiniteArticlePrefixFor(this.myRole) + this.myRole + " file");
        }
        return Validator.Result.OK;
    }

    @NotNull
    private static String getIndefiniteArticlePrefixFor(@NotNull String nounClause) {
        if (nounClause.isEmpty()) {
            return "";
        }
        return StringUtil.isVowel((char)Character.toLowerCase(nounClause.charAt(0))) ? "an " : "a ";
    }

    @AnyThread
    private void updateValidityStateAndResizability(@NotNull File file2, @NotNull Validator.Result validityState, boolean resizable) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (FileUtil.filesEqual((File)file2, (File)((File)this.myImagePath.getValueOrNull()))) {
                this.myValidityState.set(validityState);
                this.myXmlDrawableIsResizable.set(resizable);
            }
        });
    }

    private static boolean isVectorGraphics(@Nullable FileType fileType) {
        return fileType == FileType.XML_DRAWABLE || fileType == FileType.SVG || fileType == FileType.LAYERED_IMAGE;
    }

    @Nullable
    private static FileType getFileType(@Nullable File file2) {
        return file2 == null ? null : FileType.fromFile(file2);
    }

    private static enum FileType {
        XML_DRAWABLE,
        SVG,
        LAYERED_IMAGE,
        RASTER_IMAGE_CANDIDATE;


        @NotNull
        static FileType fromFile(@NotNull File file2) {
            String path2 = file2.getPath();
            if (SdkUtils.endsWithIgnoreCase((String)path2, (String)".xml")) {
                return XML_DRAWABLE;
            }
            if (SdkUtils.endsWithIgnoreCase((String)path2, (String)".svg")) {
                return SVG;
            }
            if (SdkUtils.endsWithIgnoreCase((String)path2, (String)".psd")) {
                return LAYERED_IMAGE;
            }
            return RASTER_IMAGE_CANDIDATE;
        }
    }
}

