/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.tools.idea.npw.assetstudio.BuiltInImages;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MaterialDesignIcons {
    private static final String DEFAULT_ICON_NAME = "action/ic_android_black_24dp.xml";
    private static final String PATH = "images/material_design_icons/";
    private static final Pattern CATEGORY_PATTERN = Pattern.compile("images/material_design_icons/(\\w+)/");

    private MaterialDesignIcons() {
    }

    @Nullable
    public static String getPathForBasename(@NotNull String basename) {
        return MaterialDesignIcons.getBasenameToPathMap(path2 -> BuiltInImages.getResourcesNames(path2, ".xml")).get(basename);
    }

    @NotNull
    @VisibleForTesting
    static Map<String, String> getBasenameToPathMap(@NotNull Function<String, List<String>> generator2) {
        ImmutableMap.Builder builder2 = new ImmutableMap.Builder();
        int dotXmlLength = ".xml".length();
        for (String category : MaterialDesignIcons.getCategories()) {
            String path2 = PATH + category + '/';
            for (String name : generator2.apply(path2)) {
                builder2.put((Object)name.substring(0, name.length() - dotXmlLength), (Object)(path2 + name));
            }
        }
        return builder2.build();
    }

    @NotNull
    public static Collection<String> getCategories() {
        return MaterialDesignIcons.getCategories(MaterialDesignIcons.getResourceUrl(PATH));
    }

    @NotNull
    public static List<String> getIconNames(@NotNull String categoryName) {
        return BuiltInImages.getResourcesNames(MaterialDesignIcons.getIconDirectoryPath(categoryName), ".xml");
    }

    @NotNull
    public static URL getIcon(@NotNull String iconName, @NotNull String categoryName) {
        return MaterialDesignIcons.getResourceUrl(MaterialDesignIcons.getIconDirectoryPath(categoryName) + iconName);
    }

    @NotNull
    public static URL getDefaultIcon() {
        URL url = MaterialDesignIcons.getResourceUrl("images/material_design_icons/action/ic_android_black_24dp.xml");
        assert (url != null);
        return url;
    }

    @VisibleForTesting
    static Collection<String> getCategories(@Nullable URL url) {
        if (url == null) {
            return Collections.emptyList();
        }
        switch (url.getProtocol()) {
            case "file": {
                return MaterialDesignIcons.getCategoriesFromFile(new File(url.getPath()));
            }
            case "jar": {
                try {
                    JarURLConnection connection = (JarURLConnection)url.openConnection();
                    return MaterialDesignIcons.getCategoriesFromJar(connection.getJarFile());
                }
                catch (IOException e) {
                    return Collections.emptyList();
                }
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    @VisibleForTesting
    static Collection<String> getCategoriesFromFile(@NotNull File file2) {
        String[] array = file2.list();
        if (array == null) {
            return Collections.emptyList();
        }
        List<String> list = Arrays.asList(array);
        list.sort(String::compareTo);
        return list;
    }

    @NotNull
    @VisibleForTesting
    static Collection<String> getCategoriesFromJar(@NotNull ZipFile jar) {
        return jar.stream().map(MaterialDesignIcons::getCategory).filter(Objects::nonNull).sorted().collect(Collectors.toList());
    }

    @Nullable
    private static String getCategory(@NotNull ZipEntry entry) {
        Matcher matcher = CATEGORY_PATTERN.matcher(entry.getName());
        return matcher.matches() ? matcher.group(1) : null;
    }

    @NotNull
    private static String getIconDirectoryPath(String categoryName) {
        return PATH + StringUtil.toLowerCase((String)categoryName) + '/';
    }

    private static URL getResourceUrl(String iconPath) {
        return MaterialDesignIcons.class.getClassLoader().getResource(iconPath);
    }
}

