/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeJavaArtifact;
import com.android.ide.common.util.PathString;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidViewModuleNode;
import com.android.tools.idea.navigator.nodes.android.AndroidJniFolderNode;
import com.android.tools.idea.navigator.nodes.android.AndroidManifestsGroupNode;
import com.android.tools.idea.navigator.nodes.android.AndroidResFolderNode;
import com.android.tools.idea.navigator.nodes.android.AndroidSourceTypeNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkModuleNodeKt;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.FileExtensions;
import com.google.common.collect.HashMultimap;
import com.intellij.codeInsight.dataflow.SetUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleNode
extends AndroidViewModuleNode {
    public AndroidModuleNode(@NotNull Project project, @NotNull Module module2, @NotNull AndroidProjectViewPane projectViewPane, @NotNull ViewSettings settings) {
        super(project, module2, projectViewPane, settings);
    }

    @Override
    @NotNull
    protected Collection<AbstractTreeNode<?>> getModuleChildren() {
        Module module2 = (Module)this.getValue();
        if (module2 == null || module2.isDisposed()) {
            return Collections.emptyList();
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null || AndroidModel.get(facet2) == null) {
            return this.platformGetChildren();
        }
        return AndroidModuleNode.getChildren(facet2, this.getSettings(), this.myProjectViewPane, AndroidProjectViewPane.getSourceProviders(facet2));
    }

    @NotNull
    static Collection<AbstractTreeNode<?>> getChildren(@NotNull AndroidFacet facet2, @NotNull ViewSettings settings, @NotNull AndroidProjectViewPane projectViewPane, @NotNull Iterable<NamedIdeaSourceProvider> providers2) {
        AndroidModuleSystem moduleSystem;
        PsiDirectory sampleDataPsi;
        ArrayList result2 = new ArrayList();
        Project project = facet2.getModule().getProject();
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet2);
        HashMultimap<AndroidSourceType, VirtualFile> sourcesByType = AndroidModuleNode.getSourcesBySourceType(providers2, androidModuleModel);
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(facet2.getModule());
        for (AndroidSourceType sourceType : sourcesByType.keySet()) {
            if (sourceType == AndroidSourceType.CPP && ndkModuleModel != null) continue;
            if (sourceType == AndroidSourceType.MANIFEST) {
                result2.add((AbstractTreeNode<?>)new AndroidManifestsGroupNode(project, facet2, settings, sourcesByType.get((Object)sourceType)));
                continue;
            }
            if (sourceType == AndroidSourceType.RES || sourceType == AndroidSourceType.GENERATED_RES) {
                result2.add((AbstractTreeNode<?>)new AndroidResFolderNode(project, facet2, sourceType, settings, (Set<VirtualFile>)sourcesByType.get((Object)sourceType), projectViewPane));
                continue;
            }
            if (sourceType == AndroidSourceType.SHADERS && (androidModuleModel == null || !androidModuleModel.getFeatures().isShadersSupported())) continue;
            result2.add((AbstractTreeNode<?>)new AndroidSourceTypeNode(project, facet2, settings, sourceType, sourcesByType.get((Object)sourceType), projectViewPane));
        }
        if (ndkModuleModel != null) {
            result2.add((AbstractTreeNode<?>)new AndroidJniFolderNode(project, ndkModuleModel, settings));
        }
        if ((sampleDataPsi = AndroidModuleNode.getPsiDirectory(project, (moduleSystem = ProjectSystemUtil.getModuleSystem(facet2.getModule())).getSampleDataDirectory())) != null) {
            result2.add((AbstractTreeNode<?>)new PsiDirectoryNode(project, sampleDataPsi, settings));
        }
        return result2;
    }

    @Nullable
    private static PsiDirectory getPsiDirectory(@NotNull Project project, @Nullable PathString path2) {
        VirtualFile virtualFile = FileExtensions.toVirtualFile(path2);
        return virtualFile != null ? PsiManager.getInstance((Project)project).findDirectory(virtualFile) : null;
    }

    @NotNull
    private static HashMultimap<AndroidSourceType, VirtualFile> getSourcesBySourceType(@NotNull Iterable<NamedIdeaSourceProvider> providers2, @Nullable AndroidModuleModel androidModel) {
        HashMultimap sourcesByType = HashMultimap.create();
        HashSet<VirtualFile> allSources = new HashSet<VirtualFile>();
        for (AndroidSourceType sourceType : AndroidSourceType.values()) {
            Set<VirtualFile> sources;
            if (sourceType == AndroidSourceType.SHADERS && (androidModel == null || !androidModel.getFeatures().isShadersSupported()) || (sources = sourceType == AndroidSourceType.GENERATED_JAVA ? AndroidModuleNode.getGeneratedSources(androidModel) : (sourceType == AndroidSourceType.GENERATED_RES ? AndroidModuleNode.getGeneratedResFolders(androidModel) : AndroidModuleNode.getSources(sourceType, providers2))).isEmpty()) continue;
            if (SetUtil.intersect(allSources, sources).isEmpty()) {
                sourcesByType.putAll((Object)sourceType, sources);
            } else if (!allSources.containsAll(sources)) {
                sources.removeAll(allSources);
                sourcesByType.putAll((Object)sourceType, sources);
            }
            allSources.addAll(sources);
        }
        return sourcesByType;
    }

    @NotNull
    private static Set<VirtualFile> getSources(@NotNull AndroidSourceType sourceType, @NotNull Iterable<NamedIdeaSourceProvider> providers2) {
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        for (NamedIdeaSourceProvider provider2 : providers2) {
            sources.addAll(sourceType.getSources(provider2));
        }
        return sources;
    }

    @NotNull
    private static Set<VirtualFile> getGeneratedSources(@Nullable AndroidModuleModel androidModuleModel) {
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        if (androidModuleModel != null) {
            IdeJavaArtifact unitTestArtifact;
            ArrayList<File> files2 = new ArrayList<File>(GradleUtil.getGeneratedSourceFoldersToUse((IdeBaseArtifact)androidModuleModel.getMainArtifact(), androidModuleModel));
            IdeAndroidArtifact androidTestArtifact = androidModuleModel.getArtifactForAndroidTest();
            if (androidTestArtifact != null) {
                files2.addAll(GradleUtil.getGeneratedSourceFoldersToUse((IdeBaseArtifact)androidTestArtifact, androidModuleModel));
            }
            if ((unitTestArtifact = androidModuleModel.getSelectedVariant().getUnitTestArtifact()) != null) {
                files2.addAll(unitTestArtifact.getGeneratedSourceFolders());
            }
            for (File file2 : files2) {
                VirtualFile vFile = VfsUtil.findFileByIoFile((File)file2, (boolean)false);
                if (vFile == null) continue;
                sources.add(vFile);
            }
        }
        return sources;
    }

    @NotNull
    private static Set<VirtualFile> getGeneratedResFolders(@Nullable AndroidModuleModel androidModuleModel) {
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        if (androidModuleModel != null) {
            ArrayList files2 = new ArrayList(androidModuleModel.getMainArtifact().getGeneratedResourceFolders());
            IdeAndroidArtifact androidTest = androidModuleModel.getArtifactForAndroidTest();
            if (androidTest != null) {
                files2.addAll(androidTest.getGeneratedResourceFolders());
            }
            for (File file2 : files2) {
                VirtualFile vFile = VfsUtil.findFileByIoFile((File)file2, (boolean)false);
                if (vFile == null) continue;
                sources.add(vFile);
            }
        }
        return sources;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (super.contains(file2)) {
            return true;
        }
        Module module2 = (Module)this.getValue();
        if (module2 == null || module2.isDisposed()) {
            return false;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null || AndroidModel.get(facet2) == null) {
            return false;
        }
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(facet2.getModule());
        if (ndkModuleModel != null) {
            return NdkModuleNodeKt.containedInIncludeFolders(this.myProject, ndkModuleModel, file2);
        }
        return false;
    }

    @Nullable
    public Comparable getSortKey() {
        Module module2 = (Module)this.getValue();
        if (module2 == null || module2.isDisposed()) {
            return null;
        }
        return module2.getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Override
    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        Module module2 = (Module)this.getValue();
        if (module2 == null || module2.isDisposed()) {
            return module2 == null ? "(null)" : "(Disposed)";
        }
        return String.format("%1$s (Android)", super.toTestString(printInfo));
    }

    @Override
    public void update(@NotNull PresentationData presentation) {
        super.update(presentation);
        Module module2 = (Module)this.getValue();
        if (module2 == null || module2.isDisposed()) {
            return;
        }
        presentation.setIcon(GradleUtil.getModuleIcon(module2));
    }
}

