/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.mlkit.MlProjectService;
import com.android.tools.idea.mlkit.MlUtils;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.AndroidLightPackage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MlClassFinder
extends PsiElementFinder {
    private final Project myProject;

    public MlClassFinder(@NotNull Project project) {
        this.myProject = project;
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        PsiClass[] lightClasses2 = this.findClasses(qualifiedName, scope2);
        return lightClasses2.length > 0 ? lightClasses2[0] : null;
    }

    @NotNull
    public @NotNull PsiClass @NotNull [] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (!((Boolean)StudioFlags.ML_MODEL_BINDING.get()).booleanValue() || !qualifiedName.contains(".ml")) {
            return PsiClass.EMPTY_ARRAY;
        }
        String className2 = StringUtil.getShortName((String)qualifiedName);
        return (PsiClass[])MlProjectService.getInstance(this.myProject).getLightClassListByClassName(className2).stream().filter(lightClass2 -> PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope2, (PsiElement)lightClass2) && qualifiedName.equals(lightClass2.getQualifiedName())).toArray(PsiClass[]::new);
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String packageName) {
        if (!((Boolean)StudioFlags.ML_MODEL_BINDING.get()).booleanValue() || !packageName.endsWith(".ml")) {
            return null;
        }
        String modulePackageName = StringUtil.substringBeforeLast((String)packageName, (String)".ml");
        for (AndroidFacet facet2 : ProjectSystemUtil.getProjectSystem(this.myProject).getAndroidFacetsWithPackageName(this.myProject, modulePackageName, GlobalSearchScope.projectScope((Project)this.myProject))) {
            if (!MlUtils.isMlModelBindingBuildFeatureEnabled(facet2.getModule())) continue;
            return AndroidLightPackage.withName(packageName, this.myProject);
        }
        return null;
    }
}

