/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.lint.AndroidLintMissingConstraintsInspection;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioSdkUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.lint.checks.ConstraintLayoutDetector;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeConstraintLayoutFix
implements LintIdeQuickFix {
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Module module2 = AndroidPsiUtils.getModuleSafely((PsiElement)startElement);
        UpgradeConstraintLayoutFix.apply(module2);
    }

    public static void apply(@Nullable Module module2) {
        if (module2 != null) {
            GradleCoordinate gc;
            StudioSdkUtil.reloadRemoteSdkWithModalProgress();
            AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(AndroidLintMissingConstraintsInspection.class);
            RepoPackage p = SdkMavenRepository.findLatestVersion((GradleCoordinate)ConstraintLayoutDetector.LATEST_KNOWN_VERSION, (AndroidSdkHandler)sdkHandler, null, (ProgressIndicator)progress);
            if (p != null && (gc = SdkMavenRepository.getCoordinateFromSdkPath((String)p.getPath())) != null) {
                GradleDependencyManager manager = GradleDependencyManager.getInstance(module2.getProject());
                manager.updateLibrariesToVersion(module2, Collections.singletonList(gc), null);
            }
        }
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return true;
    }

    @NotNull
    public String getName() {
        return "Upgrade to recommended version";
    }
}

