/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.psi.SearchUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

class MigrateDrawableToMipmapFix
implements LintIdeQuickFix {
    private final ResourceUrl myUrl;

    MigrateDrawableToMipmapFix(@NotNull ResourceUrl url) {
        this.myUrl = url;
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Project project = startElement.getProject();
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)startElement);
        if (facet2 == null) {
            return;
        }
        final ArrayList bitmaps = Lists.newArrayList();
        final HashSet references = Sets.newHashSet();
        GlobalSearchScope useScope = GlobalSearchScope.projectScope((Project)project);
        LocalResourceRepository projectResources = ResourceRepositoryManager.getProjectResources(facet2);
        List<ResourceItem> resourceItems = projectResources.getResources(ResourceNamespace.TODO(), this.myUrl.type, this.myUrl.name);
        for (ResourceItem item : resourceItems) {
            PsiFile file2 = IdeResourcesUtil.getItemPsiFile(project, item);
            if (file2 == null) continue;
            bitmaps.add(file2);
            Iterable allReferences = SearchUtils.findAllReferences((PsiElement)file2, (SearchScope)useScope);
            for (PsiReference next : allReferences) {
                PsiElement element2 = next.getElement();
                if (element2 == null) continue;
                references.add(element2);
            }
        }
        PsiField[] resourceFields = IdeResourcesUtil.findResourceFields(facet2, ResourceType.DRAWABLE.getName(), this.myUrl.name, true);
        if (resourceFields.length == 1) {
            Iterable allReferences = SearchUtils.findAllReferences((PsiElement)resourceFields[0], (SearchScope)useScope);
            for (PsiReference next : allReferences) {
                PsiElement element3 = next.getElement();
                if (element3 == null) continue;
                references.add(element3);
            }
        }
        HashSet applicableFiles = Sets.newHashSet();
        applicableFiles.addAll(bitmaps);
        for (PsiElement element4 : references) {
            PsiFile containingFile = element4.getContainingFile();
            if (containingFile == null) continue;
            applicableFiles.add(containingFile);
        }
        WriteCommandAction<Void> action2 = new WriteCommandAction<Void>(project, "Migrate Drawable to Bitmap", applicableFiles.toArray(PsiFile.EMPTY_ARRAY)){

            protected void run(@NotNull Result<Void> result2) throws Throwable {
                for (PsiFile bitmap : bitmaps) {
                    FolderConfiguration configuration;
                    VirtualFile parent;
                    VirtualFile file2 = bitmap.getVirtualFile();
                    if (file2 == null || (parent = file2.getParent()) == null) continue;
                    if (file2.getFileType() == XmlFileType.INSTANCE && parent.getName().startsWith("values")) {
                        XmlFile xmlFile = (XmlFile)bitmap;
                        XmlTag root2 = xmlFile.getRootTag();
                        if (root2 == null) continue;
                        for (XmlTag item : root2.getSubTags()) {
                            String name = item.getAttributeValue("name");
                            if (!((MigrateDrawableToMipmapFix)MigrateDrawableToMipmapFix.this).myUrl.name.equals(name)) continue;
                            if (ResourceType.DRAWABLE.getName().equals(item.getName())) {
                                item.setName(ResourceType.MIPMAP.getName());
                                continue;
                            }
                            if (!ResourceType.DRAWABLE.getName().equals(item.getAttributeValue("type"))) continue;
                            item.setAttribute("type", ResourceType.MIPMAP.getName());
                        }
                        continue;
                    }
                    VirtualFile res = parent.getParent();
                    if (res == null || (configuration = FolderConfiguration.getConfigForFolder((String)parent.getName())) == null) continue;
                    String targetFolderName = configuration.getFolderName(ResourceFolderType.MIPMAP);
                    VirtualFile targetFolder = res.findChild(targetFolderName);
                    if (targetFolder == null) {
                        targetFolder = res.createChildDirectory((Object)this, targetFolderName);
                    }
                    file2.move((Object)this, targetFolder);
                }
                for (PsiElement reference2 : references) {
                    PsiReferenceExpression outer;
                    PsiReferenceExpression inner;
                    PsiExpression qualifier;
                    if (reference2 instanceof XmlAttributeValue) {
                        XmlAttributeValue value2 = (XmlAttributeValue)reference2;
                        XmlAttribute attribute = (XmlAttribute)value2.getParent();
                        attribute.setValue(ResourceUrl.create((ResourceType)ResourceType.MIPMAP, (String)((MigrateDrawableToMipmapFix)MigrateDrawableToMipmapFix.this).myUrl.name, (boolean)false).toString());
                        continue;
                    }
                    if (!(reference2 instanceof PsiReferenceExpression) || !((qualifier = (inner = (PsiReferenceExpression)reference2).getQualifierExpression()) instanceof PsiReferenceExpression) || !((outer = (PsiReferenceExpression)qualifier).getReferenceNameElement() instanceof PsiIdentifier)) continue;
                    PsiIdentifier identifier = (PsiIdentifier)outer.getReferenceNameElement();
                    if (!ResourceType.DRAWABLE.getName().equals(identifier.getText())) continue;
                    Project project = reference2.getProject();
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                    PsiIdentifier newIdentifier = elementFactory.createIdentifier(ResourceType.MIPMAP.getName());
                    identifier.replace((PsiElement)newIdentifier);
                }
            }
        };
        action2.execute();
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return true;
    }

    @NotNull
    public String getName() {
        return "Convert " + this.myUrl + " to @mipmap/" + this.myUrl.name;
    }
}

