/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.manifmerger.Actions;
import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.diagnostics.crash.GenericStudioReport;
import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.editors.manifest.ManifestUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.repositories.IdeGoogleMavenRepository;
import com.android.tools.idea.lint.IdeDeprecatedSdkRegistry;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintResult;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.android.tools.idea.res.FileResourceReader;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.utils.Pair;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;

public class AndroidLintIdeClient
extends LintIdeClient {
    protected static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.lint.AndroidLintIdeClient");
    protected com.intellij.openapi.project.Project myProject;
    private AndroidSdkHandler sdk = null;
    private static final String MERGED_MANIFEST_INFO = "lint-merged-manifest-info";

    public AndroidLintIdeClient(com.intellij.openapi.project.Project project, @NotNull LintResult lintResult) {
        super(project, lintResult);
        this.myProject = project;
    }

    @Nullable
    public GradleVersion getHighestKnownVersion(GradleCoordinate coordinate, @Nullable Predicate<GradleVersion> filter2) {
        GradleCoordinate found;
        AndroidSdkHandler sdkHandler = this.getSdk();
        if (sdkHandler == null) {
            return null;
        }
        StudioLoggerProgressIndicator logger2 = new StudioLoggerProgressIndicator(((Object)((Object)this)).getClass());
        RemotePackage sdkPackage = SdkMavenRepository.findLatestRemoteVersion((GradleCoordinate)coordinate, (AndroidSdkHandler)sdkHandler, filter2, (ProgressIndicator)logger2);
        if (sdkPackage != null && (found = SdkMavenRepository.getCoordinateFromSdkPath((String)sdkPackage.getPath())) != null) {
            return found.getVersion();
        }
        return null;
    }

    @NotNull
    public byte[] readBytes(@NotNull PathString resourcePath) throws IOException {
        return FileResourceReader.readBytes(resourcePath);
    }

    @Nullable
    public File getSdkHome() {
        File home;
        String path2;
        Sdk moduleSdk;
        Module module2 = this.getModule();
        if (module2 != null && (moduleSdk = ModuleRootManager.getInstance((Module)module2).getSdk()) != null && moduleSdk.getSdkType() instanceof AndroidSdkType && (path2 = moduleSdk.getHomePath()) != null && (home = new File(path2)).exists()) {
            return home;
        }
        File sdkHome = super.getSdkHome();
        if (sdkHome != null) {
            return sdkHome;
        }
        for (Module m : ModuleManager.getInstance((com.intellij.openapi.project.Project)this.myProject).getModules()) {
            File home2;
            String path3;
            Sdk moduleSdk2 = ModuleRootManager.getInstance((Module)m).getSdk();
            if (moduleSdk2 == null || !(moduleSdk2.getSdkType() instanceof AndroidSdkType) || (path3 = moduleSdk2.getHomePath()) == null || !(home2 = new File(path3)).exists()) continue;
            return home2;
        }
        return IdeSdks.getInstance().getAndroidSdkPath();
    }

    @Nullable
    public AndroidSdkHandler getSdk() {
        if (this.sdk == null) {
            Module module2 = this.getModule();
            AndroidSdkHandler localSdk = AndroidLintIdeClient.getLocalSdk(module2);
            if (localSdk != null) {
                this.sdk = localSdk;
            } else {
                for (Module m : ModuleManager.getInstance((com.intellij.openapi.project.Project)this.myProject).getModules()) {
                    localSdk = AndroidLintIdeClient.getLocalSdk(m);
                    if (localSdk == null) continue;
                    this.sdk = localSdk;
                    break;
                }
                if (localSdk == null) {
                    this.sdk = super.getSdk();
                }
            }
        }
        return this.sdk;
    }

    @Nullable
    private static AndroidSdkHandler getLocalSdk(@Nullable Module module2) {
        AndroidSdkData sdkData;
        AndroidFacet facet2;
        if (module2 != null && (facet2 = AndroidFacet.getInstance((Module)module2)) != null && (sdkData = AndroidSdkData.getSdkData(facet2)) != null) {
            return sdkData.getSdkHandler();
        }
        return null;
    }

    @Nullable
    public Revision getBuildToolsRevision(Project project) {
        AndroidSdkHandler sdk;
        String buildToolsVersion2;
        GradleVersion version2;
        AndroidModuleModel model2;
        Module module2;
        if (project.isGradleProject() && (module2 = this.getModule(project)) != null && (model2 = AndroidModuleModel.get(module2)) != null && (version2 = model2.getModelVersion()) != null && version2.isAtLeast(2, 1, 0) && (buildToolsVersion2 = model2.getAndroidProject().getBuildToolsVersion()) != null && (sdk = this.getSdk()) != null) {
            try {
                Revision revision = Revision.parseRevision((String)buildToolsVersion2);
                BuildToolInfo buildToolInfo = sdk.getBuildToolInfo(revision, this.getRepositoryLogger());
                if (buildToolInfo != null) {
                    return buildToolInfo.getRevision();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.getBuildToolsRevision(project);
    }

    public boolean isGradleProject(@NotNull Project project) {
        Module module2 = this.getModule(project);
        if (module2 != null) {
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
            return facet2 != null && AndroidModel.isRequired(facet2);
        }
        return AndroidProjectInfo.getInstance(this.myProject).requiresAndroidModel();
    }

    @Nullable
    public File getCacheDir(@Nullable String name, boolean create2) {
        if ("maven.google".equals(name)) {
            return IdeGoogleMavenRepository.INSTANCE.getCacheDir();
        }
        if ("sdk-registry.xml".equals(name)) {
            return IdeDeprecatedSdkRegistry.INSTANCE.getCacheDir();
        }
        return super.getCacheDir(name, create2);
    }

    @Nullable
    public Document getMergedManifest(Project project) {
        MergedManifestSnapshot mergedManifest;
        Document document;
        AndroidFacet facet2;
        Module module2 = this.findModuleForLintProject(this.myProject, project);
        if (module2 != null && (facet2 = AndroidFacet.getInstance((Module)module2)) != null && (document = (mergedManifest = MergedManifestManager.getSnapshot(facet2)).getDocument()) != null) {
            Element root2 = document.getDocumentElement();
            if (root2 != null && !this.isMergeManifestNode(root2)) {
                this.resolveMergeManifestSources(document, project.getDir());
                document.setUserData(MERGED_MANIFEST_INFO, mergedManifest, null);
            }
            return document;
        }
        return null;
    }

    @Nullable
    public Pair<File, ? extends Node> findManifestSourceNode(Node mergedNode) {
        Map sourceNodeCache = this.getSourceNodeCache();
        Pair source = (Pair)sourceNodeCache.get(mergedNode);
        if (source != null) {
            if (source == NOT_FOUND) {
                return null;
            }
            return source;
        }
        Document doc = mergedNode.getOwnerDocument();
        if (doc == null) {
            return null;
        }
        MergedManifestSnapshot mergedManifest = (MergedManifestSnapshot)doc.getUserData(MERGED_MANIFEST_INFO);
        if (mergedManifest == null) {
            return null;
        }
        source = NOT_FOUND;
        List<? extends Actions.Record> records = ManifestUtils.getRecords(mergedManifest, mergedNode);
        for (Actions.Record record : records) {
            Node sourceNode;
            if (record.getActionType() != Actions.ActionType.ADDED && record.getActionType() != Actions.ActionType.MERGED || (sourceNode = ManifestUtils.getSourceNode(mergedManifest.getModule(), record)) == null) continue;
            File file2 = record.getActionLocation().getFile().getSourceFile();
            source = Pair.of((Object)file2, (Object)sourceNode);
            break;
        }
        sourceNodeCache.put(mergedNode, source);
        return source != NOT_FOUND ? source : null;
    }

    @NotNull
    public Set<Desugaring> getDesugaring(@NotNull Project project) {
        Module module2 = this.getModule(project);
        if (module2 == null) {
            return Desugaring.DEFAULT;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            return Desugaring.DEFAULT;
        }
        AndroidModel model2 = AndroidModel.get(module2);
        if (model2 == null) {
            return Desugaring.DEFAULT;
        }
        return model2.getDesugaring();
    }

    public List<File> getResourceFolders(Project project) {
        Module module2 = this.getModule(project);
        if (module2 == null) {
            return super.getResourceFolders(project);
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 != null) {
            return AndroidLintIdeClient.getResourceFolders(facet2);
        }
        return super.getResourceFolders(project);
    }

    @NotNull
    public static List<File> getResourceFolders(@NotNull AndroidFacet facet2) {
        ArrayList<File> resDirectories = new ArrayList<File>();
        for (IdeaSourceProvider ideaSourceProvider : SourceProviderManager.getInstance(facet2).getCurrentSourceProviders()) {
            for (VirtualFile resDirectory : ideaSourceProvider.getResDirectories()) {
                resDirectories.add(VfsUtilCore.virtualToIoFile((VirtualFile)resDirectory));
            }
        }
        return resDirectories;
    }

    @Nullable
    public ResourceRepository getResourceRepository(@NotNull Project project, boolean includeModuleDependencies, boolean includeLibraries) {
        AndroidFacet facet2;
        Module module2 = this.findModuleForLintProject(this.myProject, project);
        if (module2 != null && (facet2 = AndroidFacet.getInstance((Module)module2)) != null) {
            if (includeLibraries) {
                return ResourceRepositoryManager.getAppResources(facet2);
            }
            if (includeModuleDependencies) {
                return ResourceRepositoryManager.getProjectResources(facet2);
            }
            return ResourceRepositoryManager.getModuleResources(facet2);
        }
        return null;
    }

    public Location.Handle createResourceItemHandle(ResourceItem item) {
        XmlTag tag = IdeResourcesUtil.getItemTag(this.myProject, item);
        if (tag != null) {
            PathString source = item.getSource();
            assert (source != null) : item;
            File file2 = source.toFile();
            assert (file2 != null) : item;
            return new LocationHandle(file2, (XmlElement)tag);
        }
        return super.createResourceItemHandle(item);
    }

    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        ResourceRepositoryManager repoManager;
        ResourceVisibilityLookup.Provider provider2;
        AndroidFacet facet2;
        Module module2 = this.getModule();
        if (module2 != null && (facet2 = AndroidFacet.getInstance((Module)module2)) != null && (provider2 = (repoManager = ResourceRepositoryManager.getInstance(facet2)).getResourceVisibilityProvider()) != null) {
            return provider2;
        }
        return super.getResourceVisibilityProvider();
    }

    @Nullable
    public XmlPullParser createXmlPullParser(@NotNull PathString resourcePath) throws IOException {
        return FileResourceReader.createXmlPullParser(resourcePath);
    }

    protected void notifyReadCanceled(StackTraceElement[] stackDumpRaw, long cancelTimeMs, long actionTimeMs) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement e : stackDumpRaw) {
            sb.append(e.toString());
            sb.append("\n");
        }
        String stackDump = sb.toString();
        StudioCrashReporter.getInstance().submit(new GenericStudioReport.Builder("LintReadActionDelay").addDataNoPii("summary", "Android Lint either took too long to run a read action (" + actionTimeMs + "ms),\nor took too long to cancel and yield to a pending write action (" + cancelTimeMs + "ms)").addDataNoPii("timeToCancelMs", String.valueOf(cancelTimeMs)).addDataNoPii("readActionTimeMs", String.valueOf(actionTimeMs)).addDataNoPii("stackDump", stackDump).build());
    }

    private static class LocationHandle
    implements Location.Handle,
    Computable<Location> {
        private final File myFile;
        private final XmlElement myNode;
        private Object myClientData;

        LocationHandle(File file2, XmlElement node2) {
            this.myFile = file2;
            this.myNode = node2;
        }

        public Location resolve() {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (Location)ApplicationManager.getApplication().runReadAction((Computable)this);
            }
            TextRange textRange = this.myNode.getTextRange();
            if (this.myNode instanceof XmlTag) {
                String tag = ((XmlTag)this.myNode).getName();
                int index2 = this.myNode.getText().indexOf(tag);
                if (index2 != -1) {
                    int start2 = textRange.getStartOffset() + index2;
                    textRange = new TextRange(start2, start2 + tag.length());
                }
            }
            DefaultPosition start3 = new DefaultPosition(-1, -1, textRange.getStartOffset());
            DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
            return Location.create((File)this.myFile, (Position)start3, (Position)end);
        }

        public Location compute() {
            return this.resolve();
        }

        public void setClientData(@Nullable Object clientData) {
            this.myClientData = clientData;
        }

        @Nullable
        public Object getClientData() {
            return this.myClientData;
        }
    }
}

