/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.lint.AddTargetApiQuickFix;
import com.android.tools.idea.lint.AddTargetVersionCheckQuickFix;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import org.jetbrains.android.intentions.OverrideResourceAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidLintApiInspection
extends AndroidLintInspectionBase {
    public AndroidLintApiInspection(String displayName, Issue issue2) {
        super(displayName, issue2);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2, @Nullable LintFix fixData) {
        Integer apiLevel = (Integer)LintFix.getData((LintFix)fixData, Integer.class);
        if (apiLevel != null) {
            Class filter2;
            int api = apiLevel;
            ArrayList list = Lists.newArrayList();
            PsiFile file2 = startElement.getContainingFile();
            boolean isXml = false;
            if (file2 instanceof XmlFile) {
                FolderConfiguration config;
                isXml = true;
                ResourceFolderType folderType = IdeResourcesUtil.getFolderType(file2);
                if (folderType != null && (config = IdeResourcesUtil.getFolderConfiguration(file2)) != null) {
                    config.setVersionQualifier(new VersionQualifier(api));
                    String folder = config.getFolderName(folderType);
                    list.add(OverrideResourceAction.createFix(folder));
                }
            }
            if ((filter2 = (Class)LintFix.getData((LintFix)fixData, Class.class)) == null) {
                list.add(new AddTargetVersionCheckQuickFix(api));
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            Project project = startElement.getProject();
            if (!isXml && AndroidLintApiInspection.requiresApiAvailable(project)) {
                list.add(new AddTargetApiQuickFix(api, true, startElement, filter2));
            } else {
                list.add(new AddTargetApiQuickFix(api, false, startElement, filter2));
            }
            return list.toArray(LintIdeQuickFix.EMPTY_ARRAY);
        }
        return super.getQuickFixes(startElement, endElement, message2, fixData);
    }

    public static boolean requiresApiAvailable(Project project) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope2 = GlobalSearchScope.allScope((Project)project);
        return facade.findClass(ApiDetector.REQUIRES_API_ANNOTATION.oldName(), scope2) != null || facade.findClass(ApiDetector.REQUIRES_API_ANNOTATION.newName(), scope2) != null;
    }
}

