/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.model;

import com.android.tools.idea.layoutinspector.model.DrawViewNode;
import com.android.tools.idea.layoutinspector.model.DrawViewNodeKt;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.ui.DeviceViewSettings;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/layoutinspector/model/DrawViewChild;", "Lcom/android/tools/idea/layoutinspector/model/DrawViewNode;", "owner", "Lcom/android/tools/idea/layoutinspector/model/ViewNode;", "(Lcom/android/tools/idea/layoutinspector/model/ViewNode;)V", "canCollapse", "", "getCanCollapse", "()Z", "computeLabelPosition", "Lkotlin/Pair;", "", "border", "Ljava/awt/Shape;", "textWidth", "paint", "", "g2", "Ljava/awt/Graphics2D;", "model", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "paintBorder", "isSelected", "isHovered", "viewSettings", "Lcom/android/tools/idea/layoutinspector/ui/DeviceViewSettings;", "intellij.android.layout-inspector"})
public final class DrawViewChild
extends DrawViewNode {
    private final boolean canCollapse;

    @Override
    public boolean getCanCollapse() {
        return this.canCollapse;
    }

    @Override
    public void paint(@NotNull Graphics2D g2, @NotNull InspectorModel model2) {
    }

    @Override
    public void paintBorder(@NotNull Graphics2D g2, boolean isSelected, boolean isHovered, @NotNull DeviceViewSettings viewSettings) {
        if (isSelected || isHovered) {
            g2.setColor(DrawViewNodeKt.access$getEMPHASIZED_LINE_OUTLINE_COLOR$p());
            g2.setStroke(DrawViewNodeKt.access$getEMPHASIZED_LINE_OUTLINE_STROKE$p());
            if (viewSettings.getDrawBorders()) {
                g2.draw(this.getOwner().getTransformedBounds());
            }
            if (viewSettings.getDrawUntransformedBounds()) {
                g2.draw(this.getOwner().getLayoutBounds());
            }
        }
        float labelX = 0.0f;
        float labelY = 0.0f;
        float borderWidth = 0.0f;
        if (isSelected && viewSettings.getDrawLabel()) {
            g2.setFont(g2.getFont().deriveFont(JBUIScale.scale((float)30.0f)));
            FontMetrics fontMetrics = g2.getFontMetrics();
            float textWidth = fontMetrics.stringWidth(this.getOwner().getUnqualifiedName());
            Shape border = viewSettings.getDrawBorders() || isSelected && !viewSettings.getDrawUntransformedBounds() ? this.getOwner().getTransformedBounds() : (Shape)this.getOwner().getLayoutBounds();
            Pair<Float, Float> position = this.computeLabelPosition(border, textWidth);
            labelX = ((Number)position.getFirst()).floatValue();
            labelY = ((Number)position.getSecond()).floatValue();
            float textHeight = fontMetrics.getMaxAscent();
            borderWidth = textHeight * 0.3f;
            g2.draw(new Rectangle2D.Float(labelX, labelY - textHeight - 2.0f * borderWidth, textWidth + 2.0f * borderWidth, textHeight + 2.0f * borderWidth));
            g2.setColor(DrawViewNodeKt.access$getSELECTED_LINE_COLOR$p());
            g2.fill(new Rectangle2D.Float(labelX - 2.5f, labelY - textHeight - 2.0f * borderWidth - 2.5f, textWidth + 2.0f * borderWidth + 5.0f, textHeight + 2.0f * borderWidth + 5.0f));
        }
        if (isSelected) {
            g2.setColor(DrawViewNodeKt.access$getSELECTED_LINE_COLOR$p());
            g2.setStroke(DrawViewNodeKt.access$getSELECTED_LINE_STROKE$p());
        } else if (isHovered) {
            g2.setColor(DrawViewNodeKt.access$getEMPHASIZED_LINE_COLOR$p());
            g2.setStroke(DrawViewNodeKt.access$getEMPHASIZED_LINE_STROKE$p());
        } else {
            g2.setColor((Color)DrawViewNodeKt.access$getNORMAL_LINE_COLOR$p());
            g2.setStroke(DrawViewNodeKt.access$getNORMAL_LINE_STROKE$p());
        }
        if (viewSettings.getDrawBorders() || isHovered || isSelected && !viewSettings.getDrawUntransformedBounds()) {
            g2.draw(this.getOwner().getTransformedBounds());
        }
        if (viewSettings.getDrawUntransformedBounds()) {
            g2.draw(this.getOwner().getLayoutBounds());
        }
        if (isSelected && viewSettings.getDrawLabel()) {
            g2.setColor(Color.WHITE);
            g2.drawString(this.getOwner().getUnqualifiedName(), labelX + borderWidth, labelY - borderWidth - 2.5f);
        }
    }

    private final Pair<Float, Float> computeLabelPosition(Shape border, float textWidth) {
        boolean bl;
        float minY = (float)border.getBounds().getMinY();
        float minSlope = Float.MAX_VALUE;
        float[] nextPoint = new float[6];
        PathIterator pathIter = border.getPathIterator(null);
        pathIter.currentSegment(nextPoint);
        float prevX = 0.0f;
        float prevY = 0.0f;
        float leastSlopedSideWidth = 0.0f;
        float topLeftY = 0.0f;
        float x = 0.0f;
        while (true) {
            prevX = nextPoint[0];
            prevY = nextPoint[1];
            pathIter.next();
            if (pathIter.isDone()) break;
            pathIter.currentSegment(nextPoint);
            if (prevY != minY && nextPoint[1] != minY) continue;
            float f = prevX - nextPoint[0];
            bl = false;
            if ((double)Math.abs(f) < 0.001) continue;
            float slope = (nextPoint[1] - prevY) / (nextPoint[0] - prevX);
            bl = false;
            bl = false;
            if (!(Math.abs(slope) < Math.abs(minSlope))) continue;
            float f2 = nextPoint[0];
            boolean bl2 = false;
            x = Math.min(f2, prevX);
            minSlope = slope;
            f2 = nextPoint[0] - prevX;
            bl2 = false;
            leastSlopedSideWidth = Math.abs(f2);
            topLeftY = nextPoint[0] < prevX ? nextPoint[1] : prevY;
        }
        bl = false;
        float connectionWidth = Math.min(leastSlopedSideWidth, textWidth) / 2.0f;
        return new Pair((Object)Float.valueOf(x), (Object)Float.valueOf(minSlope * connectionWidth + topLeftY));
    }

    public DrawViewChild(@NotNull ViewNode owner) {
        super(owner, null);
    }
}

