/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseTreeBuilder;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.TreeBuilderSpeedSearch;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.BitUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NotNull;

public final class UiUtil {
    private UiUtil() {
    }

    public static void revalidateAndRepaint(@NotNull JComponent c) {
        c.doLayout();
        c.revalidate();
        c.repaint();
    }

    @NotNull
    public static JScrollPane setUp(@NotNull AbstractBaseTreeBuilder treeBuilder, @NotNull String name) {
        JTree tree = treeBuilder.getUi().getTree();
        tree.setExpandsSelectedPaths(true);
        tree.setRootVisible(false);
        tree.setName(name);
        TreeSelectionModel selectionModel = tree.getSelectionModel();
        selectionModel.setSelectionMode(4);
        TreeBuilderSpeedSearch.installTo(treeBuilder);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)tree);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        return scrollPane;
    }

    public static boolean isMetaOrCtrlKeyPressed(@NotNull KeyEvent e) {
        return e.getKeyCode() == (SystemInfo.isMac ? 157 : 17);
    }

    public static boolean isMetaOrCtrlKeyPressed(@NotNull MouseEvent e) {
        int modifiers = e.getModifiers();
        return BitUtil.isSet((int)modifiers, (int)(SystemInfo.isMac ? 4 : 2));
    }
}

