/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables;

import com.android.tools.idea.gradle.structure.configurables.BaseNamedConfigurable;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesByTypeAndTextComparator;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollectionKt;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class PsModuleCellRenderer
extends ColoredTreeCellRenderer {
    @NotNull
    private final PsContext myContext;

    public PsModuleCellRenderer(@NotNull PsContext context) {
        this.myContext = context;
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value2 instanceof MasterDetailsComponent.MyNode) {
            MasterDetailsComponent.MyNode node2 = (MasterDetailsComponent.MyNode)value2;
            NamedConfigurable namedConfigurable = node2.getConfigurable();
            if (namedConfigurable == null) {
                return;
            }
            this.setIcon(namedConfigurable.getIcon(expanded));
            this.setToolTipText(null);
            this.setFont(UIUtil.getTreeFont());
            SimpleTextAttributes textAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (node2.isDisplayInBold()) {
                textAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            } else if (namedConfigurable instanceof BaseNamedConfigurable) {
                Object module2 = ((BaseNamedConfigurable)namedConfigurable).getEditableObject();
                List<PsIssue> issues = this.myContext.getAnalyzerDaemon().getIssues().findIssues(((PsModule)module2).getPath(), IssuesByTypeAndTextComparator.INSTANCE);
                this.setToolTipText(PsIssueCollectionKt.getTooltipText(issues, true));
                if (!issues.isEmpty()) {
                    PsIssue issue2 = issues.get(0);
                    Color waveColor = issue2.getSeverity().getColor();
                    textAttributes = textAttributes.derive(8, null, null, waveColor);
                }
            }
            this.append(node2.getDisplayName(), textAttributes);
        }
    }
}

