/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.tools.idea.gradle.run.MakeBeforeRunTask;
import com.android.tools.idea.gradle.run.MakeBeforeRunTaskProvider;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MakeBeforeRunTaskProviderUtil {
    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(MakeBeforeRunTaskProviderUtil.class);
    }

    public static List<RunConfiguration> getConfigurationsMissingBeforeRunTask(@NotNull Project project) {
        if (project.isDisposed()) {
            return new ArrayList<RunConfiguration>();
        }
        return RunManagerEx.getInstanceEx((Project)project).getAllConfigurationsList().stream().filter(config -> MakeBeforeRunTaskProviderUtil.isBeforeRunTaskMissing(project, config)).collect(Collectors.toList());
    }

    public static List<RunConfiguration> fixConfigurationsMissingBeforeRunTask(@NotNull Project project) {
        ArrayList<RunConfiguration> result2 = new ArrayList<RunConfiguration>();
        if (project.isDisposed()) {
            return result2;
        }
        MakeBeforeRunTaskProviderUtil.getLogger().info(String.format("Trying to fix run configurations of project \"%s\"", project.getName()));
        List<RunConfiguration> list = MakeBeforeRunTaskProviderUtil.getConfigurationsMissingBeforeRunTask(project);
        for (RunConfiguration config : list) {
            MakeBeforeRunTaskProviderUtil.getLogger().info(String.format("Trying to fix config \"%s\"", config.getName()));
            if (!MakeBeforeRunTaskProviderUtil.addBeforeRunTaskToConfig(project, config)) continue;
            result2.add(config);
        }
        return result2;
    }

    private static boolean isBeforeRunTaskMissing(@NotNull Project project, @NotNull RunConfiguration config) {
        BeforeRunTaskProvider taskProvider = BeforeRunTaskProvider.getProvider((Project)project, MakeBeforeRunTaskProvider.ID);
        if (!(taskProvider instanceof MakeBeforeRunTaskProvider)) {
            return false;
        }
        MakeBeforeRunTaskProvider beforeRunTaskProvider = (MakeBeforeRunTaskProvider)taskProvider;
        if (!beforeRunTaskProvider.configurationTypeIsSupported(config)) {
            return false;
        }
        if (!beforeRunTaskProvider.configurationTypeIsEnabledByDefault(config)) {
            return false;
        }
        List tasks = RunManagerEx.getInstanceEx((Project)project).getBeforeRunTasks(config, MakeBeforeRunTaskProvider.ID);
        return !tasks.stream().anyMatch(task2 -> task2.isEnabled());
    }

    private static boolean addBeforeRunTaskToConfig(@NotNull Project project, @NotNull RunConfiguration config) {
        RunManagerEx runManagerEx = RunManagerEx.getInstanceEx((Project)project);
        MakeBeforeRunTaskProvider provider2 = (MakeBeforeRunTaskProvider)BeforeRunTaskProvider.getProvider((Project)project, MakeBeforeRunTaskProvider.ID);
        if (provider2 == null) {
            MakeBeforeRunTaskProviderUtil.getLogger().warn(String.format("Skipping config \"%s\" because task provider is not found", config.getName()));
            return false;
        }
        MakeBeforeRunTask newTask = provider2.createTask(config);
        if (newTask == null) {
            MakeBeforeRunTaskProviderUtil.getLogger().warn(String.format("Skipping config \"%s\" because provider returned a null task", config.getName()));
            return false;
        }
        List tasks = runManagerEx.getBeforeRunTasks(config).stream().collect(Collectors.toList());
        tasks.add(newTask);
        runManagerEx.setBeforeRunTasks(config, tasks);
        MakeBeforeRunTaskProviderUtil.getLogger().info(String.format("Added missing task to config \"%s\"", config.getName()));
        return true;
    }
}

