/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.tools.idea.gradle.project.sync.setup.post.TimeBasedReminder;
import com.android.tools.idea.memorysettings.MemorySettingsRecommendation;
import com.android.tools.idea.memorysettings.MemorySettingsUtil;
import com.google.wireless.android.sdk.stats.MemorySettingsEvent;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import java.util.Locale;
import org.jetbrains.android.util.AndroidBundle;

public class MemorySettingsPostSyncChecker {
    private static final Logger LOG = Logger.getInstance(MemorySettingsPostSyncChecker.class);
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Memory Settings Notification", NotificationDisplayType.STICKY_BALLOON, true, null, null, null, PluginId.getId((String)"org.jetbrains.android"));

    public static void checkSettings(Project project, TimeBasedReminder reminder) {
        LOG.info(String.format(Locale.US, "64bits? : %b, current: %d, available RAM: %d", SystemInfo.is64Bit, MemorySettingsUtil.getCurrentXmx(), MemorySettingsUtil.getMachineMem()));
        if (!MemorySettingsUtil.memorySettingsEnabled() || !reminder.shouldAsk() || MemorySettingsPostSyncChecker.hasNotification(project)) {
            LOG.info("Skipped checking memory settings");
            return;
        }
        int currentXmx = MemorySettingsUtil.getCurrentXmx();
        int recommended = MemorySettingsRecommendation.getRecommended(project, currentXmx);
        if (recommended > 0) {
            MemorySettingsPostSyncChecker.showNotification(project, currentXmx, recommended, reminder);
        }
    }

    private static boolean hasNotification(Project project) {
        return ((MemorySettingsNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(MemorySettingsNotification.class, project)).length > 0;
    }

    private static void showNotification(Project project, final int currentXmx, final int recommended, final TimeBasedReminder reminder) {
        MemorySettingsPostSyncChecker.log(MemorySettingsEvent.EventKind.SHOW_RECOMMENDATION, currentXmx, recommended);
        reminder.updateLastTimestamp();
        MemorySettingsNotification notification = new MemorySettingsNotification(AndroidBundle.message("memory.settings.postsync.message", String.valueOf(currentXmx), String.valueOf(recommended)));
        notification.setTitle(AndroidBundle.message("memory.settings.postsync.title", new Object[0]));
        NotificationAction saveRestartAction = NotificationAction.createSimple((String)AndroidBundle.message("memory.settings.postsync.save", new Object[0]), () -> {
            MemorySettingsPostSyncChecker.log(MemorySettingsEvent.EventKind.SAVE_AND_RESTART, currentXmx, recommended);
            MemorySettingsUtil.saveXmx(recommended);
            Application app = ApplicationManager.getApplication();
            if (app instanceof ApplicationEx) {
                ((ApplicationEx)app).restart(true);
            }
        });
        NotificationAction configAction = NotificationAction.createSimple((String)AndroidBundle.message("memory.settings.postsync.configure", new Object[0]), () -> {
            MemorySettingsPostSyncChecker.log(MemorySettingsEvent.EventKind.CONFIGURE, currentXmx, recommended);
            ShowSettingsUtilImpl.showSettingsDialog((Project)project, (String)"memory.settings", (String)"");
            notification.expire();
            reminder.setDoNotAskForProject(true);
        });
        notification.addAction((AnAction)saveRestartAction);
        notification.addAction((AnAction)configAction);
        notification.addAction((AnAction)new NotificationAction(AndroidBundle.message("memory.settings.postsync.do.not.ask.for.project", new Object[0])){

            public void actionPerformed(AnActionEvent e, Notification n) {
                MemorySettingsPostSyncChecker.log(MemorySettingsEvent.EventKind.DO_NOT_ASK, currentXmx, recommended);
                n.expire();
                reminder.setDoNotAskForProject(true);
            }
        });
        notification.addAction((AnAction)new NotificationAction(AndroidBundle.message("memory.settings.postsync.do.not.show.again", new Object[0])){

            public void actionPerformed(AnActionEvent e, Notification n) {
                MemorySettingsPostSyncChecker.log(MemorySettingsEvent.EventKind.DO_NOT_ASK, currentXmx, recommended);
                n.expire();
                reminder.setDoNotAskForApplication(true);
            }
        });
        notification.notify(project);
    }

    private static void log(MemorySettingsEvent.EventKind kind, int currentXmx, int recommended) {
        MemorySettingsUtil.log(kind, currentXmx, -1, -1, recommended, -1, -1, -1, -1, -1);
    }

    static class MemorySettingsNotification
    extends Notification {
        public MemorySettingsNotification(String content2) {
            super(NOTIFICATION_GROUP.getDisplayId(), "Memory Settings", content2, NotificationType.INFORMATION);
        }
    }
}

