/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.idea.java;

import com.android.tools.idea.gradle.project.sync.setup.module.common.ModuleDependenciesSetup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

class JavaModuleDependenciesSetup
extends ModuleDependenciesSetup {
    private static final Logger LOG = Logger.getInstance(JavaModuleDependenciesSetup.class);

    JavaModuleDependenciesSetup() {
    }

    void setUpLibraryDependency(@NotNull Module module2, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull String libraryName, @NotNull DependencyScope scope2, @NotNull File binaryPath, @Nullable File sourcePath, @Nullable File documentationPath, boolean isExported) {
        String prefix = GradleConstants.SYSTEM_ID.getReadableName() + ": ";
        libraryName = libraryName.isEmpty() || StringUtil.startsWith((CharSequence)libraryName, (CharSequence)prefix) ? libraryName : prefix + libraryName;
        boolean newLibrary = false;
        Library library = modelsProvider.getLibraryByName(libraryName);
        if (library == null || !JavaModuleDependenciesSetup.isLibraryValid(modelsProvider.getModifiableLibraryModel(library), new File[]{binaryPath})) {
            if (library != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(library.getName() + " not valid after sync.");
                }
                modelsProvider.removeLibrary(library);
            }
            library = modelsProvider.createLibrary(libraryName);
            newLibrary = true;
        }
        if (newLibrary) {
            this.updateLibraryRootPath(library, OrderRootType.CLASSES, modelsProvider, binaryPath);
            this.updateLibraryRootPath(library, OrderRootType.SOURCES, modelsProvider, sourcePath);
            this.updateLibraryRootPath(library, JavadocOrderRootType.getInstance(), modelsProvider, documentationPath);
        }
        this.addLibraryAsDependency(library, libraryName, scope2, module2, modelsProvider, isExported);
    }

    private void updateLibraryRootPath(@NotNull Library library, @NotNull OrderRootType rootType, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable File path2) {
        if (path2 != null) {
            this.updateLibraryRootTypePaths(library, rootType, modelsProvider, path2);
        }
    }
}

