/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues.processor;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class AddRepoProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final List<VirtualFile> myBuildFiles;
    @NotNull
    private final Repository myRepository;
    private final boolean myRequestSync;

    public AddRepoProcessor(@NotNull Project project, @NotNull List<VirtualFile> buildFiles, @NotNull Repository repository, boolean requestSync) {
        super(project);
        this.myBuildFiles = buildFiles;
        this.myRequestSync = requestSync;
        this.myRepository = repository;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new UsageViewDescriptor(){

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return String.format(Locale.US, "File%s to add %s repository to (%d file%s found)", filesCount == 1 ? "" : "s", AddRepoProcessor.this.myRepository.getDisplayName(), filesCount, filesCount == 1 ? "" : "s");
            }

            @NotNull
            public PsiElement[] getElements() {
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return "Add " + AddRepoProcessor.this.myRepository.getDisplayName() + " repository";
            }
        };
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get(this.myProject);
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (VirtualFile file2 : this.myBuildFiles) {
            GradleBuildModel buildModel;
            PsiElement psiElement;
            if (!file2.isValid() || !file2.isWritable() || (psiElement = (buildModel = projectBuildModel2.getModuleBuildModel(file2)).getPsiElement()) == null) continue;
            usages.add(new UsageInfo(psiElement));
        }
        return usages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get(this.myProject);
        List elements = Arrays.stream(usages).map(usage -> usage.getElement()).collect(Collectors.toList());
        block3: for (VirtualFile file2 : this.myBuildFiles) {
            GradleBuildModel buildModel = projectBuildModel2.getModuleBuildModel(file2);
            PsiElement filePsiElement = buildModel.getPsiElement();
            if (filePsiElement == null || !elements.contains(filePsiElement)) continue;
            switch (this.myRepository) {
                case GOOGLE: {
                    GradleVersion gradleVersion2 = GradleVersions.getInstance().getGradleVersionOrDefault(this.myProject, new GradleVersion(1, 0));
                    buildModel.repositories().addGoogleMavenRepository(gradleVersion2);
                    PsiElement buildScriptElement = buildModel.buildscript().getPsiElement();
                    if (buildScriptElement == null) continue block3;
                    buildModel.buildscript().repositories().addGoogleMavenRepository(gradleVersion2);
                    continue block3;
                }
            }
            throw new IllegalStateException("No handle for requested repository: " + this.myRepository.name());
        }
        projectBuildModel2.applyChanges();
        if (this.myRequestSync) {
            GradleSyncInvoker.getInstance().requestProjectSync(this.myProject, GradleSyncStats.Trigger.TRIGGER_QF_REPOSITORY_ADDED);
        }
    }

    @NotNull
    protected String getCommandName() {
        return "Add " + this.myRepository.getDisplayName() + " repository";
    }

    public static enum Repository {
        GOOGLE("Google");

        @NotNull
        private final String myName;

        private Repository(String name) {
            this.myName = name;
        }

        @NotNull
        public String getDisplayName() {
            return this.myName;
        }
    }
}

