/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.issues;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.idea.issues.JdkImportCheckException;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmName;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\u0005"}, d2={"validateJdk", "", "", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "intellij.android.core"})
@JvmName(name="JdkImportCheck")
public final class JdkImportCheck {
    public static final void validateJdk() {
        String string = JdkImportCheck.validateJdk(IdeSdks.getInstance().getJdk());
        if (string == null) {
            return;
        }
        String jdkValidationError = string;
        throw (Throwable)new JdkImportCheckException(jdkValidationError);
    }

    private static final String validateJdk(Sdk jdk) {
        if (jdk == null) {
            return "Jdk location is not set.";
        }
        String string = jdk.getHomePath();
        if (string == null) {
            return "Could not find valid Jdk home from the selected Jdk location.";
        }
        String jdkHomePath = string;
        String selectedJdkMsg = "Selected Jdk location is " + jdkHomePath + ".\n";
        JavaSdkVersion runningJdkVersion = IdeSdks.getInstance().getRunningVersionOrDefault();
        if (!((Boolean)StudioFlags.ALLOW_DIFFERENT_JDK_VERSION.get()).booleanValue() && !IdeSdks.isJdkSameVersion(new File(jdkHomePath), runningJdkVersion)) {
            return "The version of selected Jdk doesn't match the Jdk used by Studio. Please choose a valid Jdk " + runningJdkVersion.getDescription() + " directory.\n" + selectedJdkMsg;
        }
        if (!JdkUtil.checkForJdk((String)jdkHomePath)) {
            return "The Jdk installation is invalid.\n" + selectedJdkMsg;
        }
        return !Jdks.isJdkRunnableOnPlatform(jdk) ? "The selected Jdk could not run on current OS.\nIf you are using embedded Jdk, please make sure to download Android Studio bundle compatible\nwith the current OS. For example, for x86 systems please choose a 32 bits download option.\n" + selectedJdkMsg : null;
    }
}

