/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.quickFixes.OpenPluginBuildFileQuickFix;
import com.android.tools.idea.gradle.project.sync.quickFixes.UpgradeGradleVersionsQuickFix;
import com.android.tools.idea.gradle.project.upgrade.AgpGradleVersionRefactoringProcessor;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.tooling.UnsupportedVersionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/OldAndroidPluginIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "tryToGetPluginTooOldMessage", "tryToGetUnsupportedGradleMessage", "Companion", "intellij.android.core"})
public final class OldAndroidPluginIssueChecker
implements GradleIssueChecker {
    private static final Pattern PATTERN;
    private static final String PLUGIN_TOO_OLD = "Plugin is too old, please update to a more recent version";
    private static final Pattern UNSUPPORTED_GRADLE_VERSION_PATTERN;
    @NotNull
    private static final GradleVersion MINIMUM_AGP_VERSION_JDK_8;
    @NotNull
    private static final GradleVersion MINIMUM_AGP_VERSION_JDK_11;
    private static final GradleVersion MINIMUM_GRADLE_VERSION;
    public static final Companion Companion;

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String string = rootCause.getMessage();
        if (string == null) {
            return null;
        }
        String message2 = string;
        if (StringsKt.isBlank((CharSequence)message2)) {
            return null;
        }
        String parsedMessage = this.tryToGetPluginTooOldMessage(message2);
        boolean withMinimumVersion = false;
        if (parsedMessage == null && rootCause instanceof UnsupportedVersionException) {
            parsedMessage = this.tryToGetUnsupportedGradleMessage(message2);
            withMinimumVersion = true;
        }
        if (parsedMessage == null) {
            return null;
        }
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(issueData){
            final /* synthetic */ GradleIssueData $issueData$inlined;
            {
                this.$issueData$inlined = gradleIssueData;
            }

            public final void run() {
                boolean bl = false;
                BuildIssueUtilKt.updateUsageTracker(this.$issueData$inlined.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.OLD_ANDROID_PLUGIN);
            }
        }, ModalityState.defaultModalityState());
        BuildIssueComposer composer = new BuildIssueComposer(parsedMessage, null, 2, null);
        if (withMinimumVersion) {
            JavaSdkVersion javaSdkVersion;
            Sdk jdk = IdeSdks.getInstance().getJdk();
            if (jdk != null && jdk.getVersionString() != null) {
                String string2 = jdk.getVersionString();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                javaSdkVersion = JavaSdkVersion.fromVersionString((String)string2);
            } else {
                javaSdkVersion = null;
            }
            JavaSdkVersion jdkVersion = javaSdkVersion;
            boolean isJdk8OrOlder = jdkVersion != null && jdkVersion.compareTo((Enum)JavaSdkVersion.JDK_1_8) <= 0;
            GradleVersion minAgpToUse = isJdk8OrOlder ? MINIMUM_AGP_VERSION_JDK_8 : MINIMUM_AGP_VERSION_JDK_11;
            composer.addQuickFix(new UpgradeGradleVersionsQuickFix(AgpGradleVersionRefactoringProcessor.Companion.getCompatibleGradleVersion(minAgpToUse).getVersion(), minAgpToUse, "minimum"));
        }
        composer.addQuickFix(new UpgradeGradleVersionsQuickFix(GradleVersion.parse((String)"6.7.1"), GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get()), "latest"));
        composer.addQuickFix("Open build file", new OpenPluginBuildFileQuickFix());
        return composer.composeBuildIssue();
    }

    private final String tryToGetPluginTooOldMessage(String message2) {
        if (StringsKt.startsWith$default((String)message2, (String)PLUGIN_TOO_OLD, (boolean)false, (int)2, null) || PATTERN.matcher((CharSequence)StringsKt.lines((CharSequence)message2).get(0)).matches()) {
            return message2;
        }
        return null;
    }

    private final String tryToGetUnsupportedGradleMessage(String message2) {
        Matcher matcher = UNSUPPORTED_GRADLE_VERSION_PATTERN.matcher(message2);
        if (matcher.matches()) {
            GradleVersion minimumVersion = GradleVersion.parse((String)matcher.group(1));
            GradleVersion usedVersion = GradleVersion.parse((String)matcher.group(2));
            if (minimumVersion.compareTo(MINIMUM_GRADLE_VERSION) <= 0) {
                return "This version of Android Studio requires projects to use Gradle " + MINIMUM_GRADLE_VERSION + " or newer. This project is using Gradle " + usedVersion + '.';
            }
        }
        return null;
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        return this.tryToGetPluginTooOldMessage(failureCause) != null || this.tryToGetUnsupportedGradleMessage(failureCause) != null;
    }

    static {
        Companion = new Companion(null);
        PATTERN = Pattern.compile("The android gradle plugin version .+ is too old, please update to the latest version.");
        UNSUPPORTED_GRADLE_VERSION_PATTERN = Pattern.compile("Support for builds using Gradle versions older than (.*?) .* You are currently using Gradle version (.*?). .*", 32);
        MINIMUM_AGP_VERSION_JDK_8 = new GradleVersion(3, 1, 0);
        MINIMUM_AGP_VERSION_JDK_11 = new GradleVersion(3, 2, 0);
        MINIMUM_GRADLE_VERSION = GradleVersion.parse((String)"4.8.1");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0019\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0006R\u0016\u0010\f\u001a\n \n*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \n*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/OldAndroidPluginIssueChecker$Companion;", "", "()V", "MINIMUM_AGP_VERSION_JDK_11", "Lcom/android/ide/common/repository/GradleVersion;", "getMINIMUM_AGP_VERSION_JDK_11", "()Lcom/android/ide/common/repository/GradleVersion;", "MINIMUM_AGP_VERSION_JDK_8", "getMINIMUM_AGP_VERSION_JDK_8", "MINIMUM_GRADLE_VERSION", "kotlin.jvm.PlatformType", "getMINIMUM_GRADLE_VERSION", "PATTERN", "Ljava/util/regex/Pattern;", "PLUGIN_TOO_OLD", "", "UNSUPPORTED_GRADLE_VERSION_PATTERN", "intellij.android.core"})
    public static final class Companion {
        @NotNull
        public final GradleVersion getMINIMUM_AGP_VERSION_JDK_8() {
            return MINIMUM_AGP_VERSION_JDK_8;
        }

        @NotNull
        public final GradleVersion getMINIMUM_AGP_VERSION_JDK_11() {
            return MINIMUM_AGP_VERSION_JDK_11;
        }

        public final GradleVersion getMINIMUM_GRADLE_VERSION() {
            return MINIMUM_GRADLE_VERSION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

