/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.quickFixes.OpenFileAtLocationQuickFix;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import java.io.File;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016JD\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00190\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/MissingAndroidSdkIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "FIX_SDK_DIR_PROPERTY", "", "RUNTIME_EXCEPTION_TRACE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "SDK_DIR_PROPERTY_MISSING", "SDK_NOT_FOUND_PATTERN", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "intellij.android.core"})
public final class MissingAndroidSdkIssueChecker
implements GradleIssueChecker {
    private final String FIX_SDK_DIR_PROPERTY;
    private final String SDK_DIR_PROPERTY_MISSING;
    private final Pattern SDK_NOT_FOUND_PATTERN = Pattern.compile("The SDK directory '(.*?)' does not exist.");
    private final Pattern RUNTIME_EXCEPTION_TRACE_PATTERN = Pattern.compile("Caused by: java.lang.RuntimeException(.*)");

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String string = rootCause.getMessage();
        if (string == null) {
            return null;
        }
        String message2 = string;
        if (!(rootCause instanceof RuntimeException) || StringsKt.isBlank((CharSequence)message2) || Intrinsics.areEqual((Object)message2, (Object)this.SDK_DIR_PROPERTY_MISSING) ^ true && !this.SDK_NOT_FOUND_PATTERN.matcher(message2).matches()) {
            return null;
        }
        BuildIssueUtilKt.updateUsageTracker(issueData.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.SDK_NOT_FOUND);
        File propertiesFile = new File(issueData.getProjectPath(), "local.properties");
        if (!propertiesFile.isFile()) {
            return null;
        }
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(message2, null, 2, null);
        boolean bl = false;
        boolean bl2 = false;
        BuildIssueComposer $this$apply = buildIssueComposer;
        boolean bl3 = false;
        $this$apply.addDescription(this.FIX_SDK_DIR_PROPERTY);
        $this$apply.addQuickFix("Open local.properties File", new OpenFileAtLocationQuickFix(new FilePosition(propertiesFile, 0, 0)));
        return buildIssueComposer.composeBuildIssue();
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        return stacktrace != null && this.RUNTIME_EXCEPTION_TRACE_PATTERN.matcher(stacktrace).find() && (Intrinsics.areEqual((Object)failureCause, (Object)this.SDK_DIR_PROPERTY_MISSING) || this.SDK_NOT_FOUND_PATTERN.matcher(failureCause).matches());
    }

    public MissingAndroidSdkIssueChecker() {
        this.FIX_SDK_DIR_PROPERTY = "Please fix the 'sdk.dir' property in the local.properties file.";
        this.SDK_DIR_PROPERTY_MISSING = "No sdk.dir property defined in local.properties file.";
    }
}

