/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.notification;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.actions.RefreshLinkedCppProjectsAction;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.sync.GradleFiles;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.projectsystem.AndroidProjectSettingsService;
import com.android.utils.BuildScriptUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.BuildContentManager;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSyncStatusNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final long PROJECT_STRUCTURE_NOTIFICATION_RESHOW_TIMEOUT_MS = TimeUnit.DAYS.toMillis(30L);
    @NotNull
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.gradle.sync.status");
    @NotNull
    private final GradleProjectInfo myProjectInfo;
    @NotNull
    private final GradleSyncState mySyncState;

    public ProjectSyncStatusNotificationProvider(@NotNull Project project) {
        this(GradleProjectInfo.getInstance(project), GradleSyncState.getInstance(project));
    }

    @NonInjectable
    public ProjectSyncStatusNotificationProvider(@NotNull GradleProjectInfo projectInfo, @NotNull GradleSyncState syncState) {
        this.myProjectInfo = projectInfo;
        this.mySyncState = syncState;
    }

    @NotNull
    public final Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @AnyThread
    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor editor2, @NotNull Project project) {
        NotificationPanel.Type newPanelType = this.notificationPanelType();
        return newPanelType.create(project, file2, this.myProjectInfo);
    }

    @VisibleForTesting
    @NotNull
    NotificationPanel.Type notificationPanelType() {
        if (!this.myProjectInfo.isBuildWithGradle()) {
            return NotificationPanel.Type.NONE;
        }
        if (this.mySyncState.isSyncInProgress()) {
            return NotificationPanel.Type.IN_PROGRESS;
        }
        if (this.mySyncState.lastSyncFailed()) {
            return NotificationPanel.Type.FAILED;
        }
        ThreeState gradleSyncNeeded = this.mySyncState.isSyncNeeded();
        if (gradleSyncNeeded == ThreeState.YES) {
            return NotificationPanel.Type.SYNC_NEEDED;
        }
        return NotificationPanel.Type.NONE;
    }

    @VisibleForTesting
    static class ProjectStructureNotificationPanel
    extends NotificationPanel {
        ProjectStructureNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text2, @NotNull Module module2) {
            super(type, text2);
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"ShowProjectStructureSettings");
            String label = "Open";
            if (shortcutText != "") {
                label = label + " (" + shortcutText + ")";
            }
            this.createActionLabel(label, () -> {
                ProjectSettingsService projectSettingsService = ProjectSettingsService.getInstance((Project)project);
                if (projectSettingsService instanceof AndroidProjectSettingsService) {
                    projectSettingsService.openModuleSettings(module2);
                }
            });
            this.createActionLabel("Hide notification", () -> {
                PropertiesComponent.getInstance().setValue("PROJECT_STRUCTURE_NOTIFICATION_LAST_HIDDEN_TIMESTAMP", Long.toString(System.currentTimeMillis()));
                this.setVisible(false);
            });
        }

        public Color getBackground() {
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            return color == null ? UIUtil.getPanelBackground() : color;
        }
    }

    @VisibleForTesting
    static class SyncProblemNotificationPanel
    extends NotificationPanel {
        SyncProblemNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text2) {
            super(type, text2);
            this.createActionLabel("Try Again", () -> GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_USER_TRY_AGAIN));
            this.createActionLabel("Open 'Build' View", () -> {
                ToolWindow tw = BuildContentManager.getInstance((Project)project).getOrCreateToolWindow();
                if (tw != null && !tw.isActive()) {
                    tw.activate(null, false);
                }
            });
            this.createActionLabel("Show Log in " + RevealFileAction.getFileManagerName(), () -> {
                File logFile = new File(PathManager.getLogPath(), "idea.log");
                RevealFileAction.openFile((File)logFile);
            });
        }
    }

    @VisibleForTesting
    static class StaleGradleModelNotificationPanel
    extends NotificationPanel {
        StaleGradleModelNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text2) {
            super(type, text2);
            if (GradleFiles.getInstance(project).areExternalBuildFilesModified()) {
                project.putUserData(RefreshLinkedCppProjectsAction.REFRESH_EXTERNAL_NATIVE_MODELS_KEY, (Object)true);
            }
            this.createActionLabel("Sync Now", () -> GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_USER_STALE_CHANGES));
            this.createActionLabel("Ignore these changes", () -> {
                GradleFiles.getInstance(project).removeChangedFiles();
                this.setVisible(false);
            });
        }
    }

    @VisibleForTesting
    static class NotificationPanel
    extends EditorNotificationPanel {
        @NotNull
        private final Type type;

        NotificationPanel(@NotNull Type type, @NotNull String text2) {
            this.type = type;
            this.setText(text2);
        }

        static enum Type {
            NONE{

                @Override
                @Nullable
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GradleProjectInfo projectInfo) {
                    if (!IdeInfo.getInstance().isAndroidStudio()) {
                        return null;
                    }
                    if (System.currentTimeMillis() - Long.parseLong(PropertiesComponent.getInstance().getValue("PROJECT_STRUCTURE_NOTIFICATION_LAST_HIDDEN_TIMESTAMP", "0")) > PROJECT_STRUCTURE_NOTIFICATION_RESHOW_TIMEOUT_MS) {
                        if (!projectInfo.isBuildWithGradle()) {
                            return null;
                        }
                        if (!BuildScriptUtil.isDefaultGradleBuildFile((File)VfsUtilCore.virtualToIoFile((VirtualFile)file2))) {
                            return null;
                        }
                        Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)project);
                        if (module2 == null) {
                            if (ApplicationManager.getApplication().isUnitTestMode()) {
                                module2 = ModuleManager.getInstance((Project)project).getModules()[0];
                            } else {
                                return null;
                            }
                        }
                        return new ProjectStructureNotificationPanel(project, this, "You can use the Project Structure dialog to view and edit your project configuration", module2);
                    }
                    return null;
                }
            }
            ,
            IN_PROGRESS{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GradleProjectInfo projectInfo) {
                    return new NotificationPanel(this, "Gradle project sync in progress...");
                }
            }
            ,
            FAILED{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GradleProjectInfo projectInfo) {
                    String text2 = "Gradle project sync failed. Basic functionality (e.g. editing, debugging) will not work properly.";
                    return new SyncProblemNotificationPanel(project, this, text2);
                }
            }
            ,
            SYNC_NEEDED{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GradleProjectInfo projectInfo) {
                    boolean buildFilesModified = GradleFiles.getInstance(project).areExternalBuildFilesModified();
                    String text2 = (buildFilesModified ? "External build files" : "Gradle files") + " have changed since last project sync. A project sync may be necessary for the IDE to work properly.";
                    return new StaleGradleModelNotificationPanel(project, this, text2);
                }
            };


            @Nullable
            abstract NotificationPanel create(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull GradleProjectInfo var3);
        }
    }
}

