/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.java;

import com.google.common.collect.Sets;
import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaSourceDirectory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleContentRoot
implements Serializable {
    private static final long serialVersionUID = 3L;
    @NotNull
    private final File myRootDirPath;
    @NotNull
    private final Collection<File> mySourceDirPaths;
    @NotNull
    private final Collection<File> myGenSourceDirPaths;
    @NotNull
    private final Collection<File> myResourceDirPaths;
    @NotNull
    private final Collection<File> myTestDirPaths;
    @NotNull
    private final Collection<File> myGenTestDirPaths;
    @NotNull
    private final Collection<File> myTestResourceDirPaths;
    @NotNull
    private final Collection<File> myExcludeDirPaths;

    @NotNull
    public static JavaModuleContentRoot copy(@NotNull IdeaContentRoot original) {
        File rootDirPath = original.getRootDirectory();
        Collection<File> sourceDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getSourceDirectories());
        Collection<File> genSourceDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getGeneratedSourceDirectories());
        Collection<File> testDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getTestDirectories());
        Collection<File> genTestDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getGeneratedTestDirectories());
        Set<File> resourceDirPaths = Collections.emptySet();
        Set<File> testResourceDirPaths = Collections.emptySet();
        try {
            resourceDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getResourceDirectories());
            testResourceDirPaths = JavaModuleContentRoot.copy((DomainObjectSet<? extends IdeaSourceDirectory>)original.getTestResourceDirectories());
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            // empty catch block
        }
        HashSet excludeDirPaths = Collections.emptySet();
        Set exclude = original.getExcludeDirectories();
        if (exclude != null) {
            excludeDirPaths = Sets.newHashSet();
            for (File path2 : exclude) {
                if (path2 == null) continue;
                excludeDirPaths.add(path2);
            }
        }
        return new JavaModuleContentRoot(rootDirPath, sourceDirPaths, genSourceDirPaths, resourceDirPaths, testDirPaths, genTestDirPaths, testResourceDirPaths, excludeDirPaths);
    }

    @NotNull
    private static Collection<File> copy(@Nullable DomainObjectSet<? extends IdeaSourceDirectory> directories) {
        if (directories == null) {
            return Collections.emptySet();
        }
        HashSet paths = Sets.newHashSet();
        for (IdeaSourceDirectory directory : directories) {
            paths.add(directory.getDirectory());
        }
        return paths;
    }

    @PropertyMapping(value={"myRootDirPath", "mySourceDirPaths", "myGenSourceDirPaths", "myResourceDirPaths", "myTestDirPaths", "myGenTestDirPaths", "myTestResourceDirPaths", "myExcludeDirPaths"})
    public JavaModuleContentRoot(@NotNull File rootDirPath, @NotNull Collection<File> sourceDirPaths, @NotNull Collection<File> genSourceDirPaths, @NotNull Collection<File> resourceDirPaths, @NotNull Collection<File> testDirPaths, @NotNull Collection<File> genTestDirPaths, @NotNull Collection<File> testResourceDirPaths, @NotNull Collection<File> excludeDirPaths) {
        this.myRootDirPath = rootDirPath;
        this.mySourceDirPaths = sourceDirPaths;
        this.myGenSourceDirPaths = genSourceDirPaths;
        this.myResourceDirPaths = resourceDirPaths;
        this.myTestDirPaths = testDirPaths;
        this.myGenTestDirPaths = genTestDirPaths;
        this.myTestResourceDirPaths = testResourceDirPaths;
        this.myExcludeDirPaths = excludeDirPaths;
    }

    @NotNull
    public File getRootDirPath() {
        return this.myRootDirPath;
    }

    @NotNull
    public Collection<File> getSourceDirPaths() {
        return this.mySourceDirPaths;
    }

    @NotNull
    public Collection<File> getGenSourceDirPaths() {
        return this.myGenSourceDirPaths;
    }

    @NotNull
    public Collection<File> getResourceDirPaths() {
        return this.myResourceDirPaths;
    }

    @NotNull
    public Collection<File> getTestDirPaths() {
        return this.myTestDirPaths;
    }

    @NotNull
    public Collection<File> getGenTestDirPaths() {
        return this.myGenTestDirPaths;
    }

    @NotNull
    public Collection<File> getTestResourceDirPaths() {
        return this.myTestResourceDirPaths;
    }

    @NotNull
    public Collection<File> getExcludeDirPaths() {
        return this.myExcludeDirPaths;
    }

    public int hashCode() {
        return Objects.hash(this.myRootDirPath, this.mySourceDirPaths, this.myGenSourceDirPaths, this.myTestDirPaths, this.myGenTestDirPaths, this.myTestResourceDirPaths, this.myExcludeDirPaths);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaModuleContentRoot)) {
            return false;
        }
        JavaModuleContentRoot root2 = (JavaModuleContentRoot)obj;
        return Objects.equals(this.myRootDirPath, root2.myRootDirPath) && Objects.equals(this.mySourceDirPaths, root2.mySourceDirPaths) && Objects.equals(this.myGenSourceDirPaths, root2.myGenSourceDirPaths) && Objects.equals(this.myTestDirPaths, root2.myTestDirPaths) && Objects.equals(this.myGenTestDirPaths, root2.myGenTestDirPaths) && Objects.equals(this.myTestResourceDirPaths, root2.myTestResourceDirPaths) && Objects.equals(this.myExcludeDirPaths, root2.myExcludeDirPaths);
    }
}

